/*
 * Decompiled with CFR 0.152.
 */
package net.astah.ui.control.mode;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.CommandManager;
import net.astah.golf.draw.GNode;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.golf.widget.CPopupMenu;
import net.astah.golf.widget.StructuredSelection;
import net.astah.jmodel.Presentation;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.notation.edit.layout.DiagramElementOperations;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class DiagramPopupMode
extends DiagramMode {
    protected GNode minDepthNode = null;

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!InputEventSupport.isRightMouseButton(mouseEvent) || mouseEvent.isShiftDown()) {
            return;
        }
        if (InputEventSupport.isMacExchangedButton(mouseEvent)) {
            return;
        }
        Rectangle rectangle = this.getRectToPick(mouseEvent);
        List list = this.ignoreRimmedPick(() -> this.getPickedNodes(rectangle, 1, true));
        if (list == null || list.isEmpty()) {
            this.maybeShowPopup(mouseEvent, null);
            return;
        }
        this.minDepthNode = (GNode)list.get(0);
        List<GNode> list2 = this.canvas.getSelectedNodes(1);
        if (list2 != null && list2.size() > 1 && list2.contains(this.minDepthNode)) {
            boolean bl = this.a(this.minDepthNode, list);
            if (bl) {
                this.maybeShowPopup(mouseEvent, list2);
            } else {
                this.de.unselect();
                this.de.select(this.minDepthNode);
                ArrayList<GNode> arrayList = new ArrayList<GNode>();
                arrayList.add(this.minDepthNode);
                this.maybeShowPopup(mouseEvent, arrayList);
            }
        } else {
            this.de.unselect();
            this.de.select(this.minDepthNode);
            this.canvas.selectAndNotify(Collections.singletonList(this.minDepthNode));
            this.maybeShowPopup(mouseEvent, Collections.singletonList(this.minDepthNode));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.editingNodeModify(mouseEvent, true);
    }

    protected void maybeShowPopup(MouseEvent mouseEvent, List<GNode> list) {
        CommandManager.instance().setPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        CPopupMenu cPopupMenu = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list == null || list.isEmpty()) {
            arrayList.add(this.de.getDiagram());
            cPopupMenu = this.de.createContextMenu(new StructuredSelection(arrayList));
        } else {
            for (GNode gNode : list) {
                arrayList.add(gNode.getModel());
            }
            if (arrayList.isEmpty()) {
                return;
            }
            cPopupMenu = this.de.createContextMenu(new StructuredSelection(arrayList));
        }
        if (cPopupMenu != null) {
            this.a(cPopupMenu, mouseEvent);
            cPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private boolean a(GNode gNode, List<GNode> list) {
        List<GNode> list2 = this.canvas.getSelectedNodes(1);
        if (list2.size() < 2) {
            return false;
        }
        if (list2.size() >= 2 && this.a(list2)) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(0).equals(gNode)) continue;
            return true;
        }
        return false;
    }

    private boolean a(List<GNode> list) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        for (GNode gNode : list) {
            DiagramElement diagramElement = DiagramElementOperations.getDiagramElement(gNode);
            arrayList.add(diagramElement);
        }
        return this.b(arrayList);
    }

    private boolean b(List<DiagramElement> list) {
        DiagramElement diagramElement = list.get(0);
        if (!(diagramElement instanceof Presentation)) {
            return false;
        }
        Presentation presentation = (Presentation)diagramElement;
        if (presentation.getModel() == null) {
            return false;
        }
        for (int i2 = 1; i2 < list.size(); ++i2) {
            if (presentation == list.get(i2)) continue;
            return false;
        }
        return true;
    }

    private void a(CPopupMenu cPopupMenu, MouseEvent mouseEvent) {
        this.de.updatePasteLocation(cPopupMenu, mouseEvent);
    }
}

