/*
 * Decompiled with CFR 0.152.
 */
package net.astah.ui.control.mode;

import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import net.astah.golf.draw.GCanvas;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.widget.swing.SwingCanvas;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jcontrol.mode.IDnDMode;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class DiagramDnDMode
extends DiagramMode
implements DropTargetListener,
IDnDMode {
    protected DropTarget dropTarget;
    protected List<DropTargetListener> extensionDropTargetListeners = new ArrayList<DropTargetListener>();
    private static final Logger a = LoggerFactory.getLogger(DiagramDnDMode.class);

    @Override
    public void setDiagramEditor(DiagramEditor diagramEditor) {
        super.setDiagramEditor(diagramEditor);
        GCanvas gCanvas = (GCanvas)((SwingCanvas)this.canvas).getComponent();
        this.extensionDropTargetListeners.addAll(JomtGlobal.modeManager.getDropTargetListeners());
        this.dropTarget = new DropTarget(gCanvas, 3, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    protected Pnt2d getLocation(DropTargetEvent dropTargetEvent) {
        int n2;
        int n3;
        if (dropTargetEvent instanceof DropTargetDragEvent) {
            n3 = ((DropTargetDragEvent)dropTargetEvent).getLocation().x;
            n2 = ((DropTargetDragEvent)dropTargetEvent).getLocation().y;
        } else if (dropTargetEvent instanceof DropTargetDropEvent) {
            n3 = ((DropTargetDropEvent)dropTargetEvent).getLocation().x;
            n2 = ((DropTargetDropEvent)dropTargetEvent).getLocation().y;
        } else {
            return null;
        }
        return new Pnt2d(this.camera.toWorldCoordX(n3), this.camera.toWorldCoordY(n2));
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.dropExecute(dropTargetDropEvent);
        this.postDrop(dropTargetDropEvent);
    }

    protected void dropExecute(DropTargetDropEvent dropTargetDropEvent) {
    }

    protected void postDrop(DropTargetDropEvent dropTargetDropEvent) {
        this.de.unselect();
        dropTargetDropEvent.dropComplete(true);
        this.de.repaintCanvas();
    }
}

