/*
 * Decompiled with CFR 0.152.
 */
package net.astah.ui.control.mode;

import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import net.astah.dd.dc.AlignmentKind;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dg.DGFactory;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Group;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Style;
import net.astah.dd.dg.Text;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jomt.jcontrol.CreateTextCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.IItemEditorFactory;
import net.astah.notation.provider.graphics.DGSetSizeHelper;
import net.astah.notation.resource.NotationResources;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.project.StylePreferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class CreateTextMode
extends DiagramMode {
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    protected GraphicalShape prepareShape(Bounds bounds) {
        GraphicalElement graphicalElement = this.createFigure(bounds);
        GraphicalShape graphicalShape = this.createShape();
        graphicalShape.setFigure(graphicalElement);
        return graphicalShape;
    }

    protected GraphicalShape createShape() {
        IItemEditorFactory iItemEditorFactory = ItemProviders.adapt(this.getDiagram(), IItemEditorFactory.class);
        EClass eClass = iItemEditorFactory.getGraphicalShapeClass();
        if (eClass == null) {
            throw new UnsupportedOperationException("\u672a\u5bfe\u5fdc\u306e\u56f3");
        }
        return (GraphicalShape)EcoreUtil.create(eClass);
    }

    protected GraphicalElement createText(Bounds bounds) {
        Text text = DGFactory.eINSTANCE.createText();
        text.setData(PropertyManager.getProjectViewResourceBundle().getString("uml.text.label"));
        text.setAlignment(AlignmentKind.START);
        text.setBounds(DGSetSizeHelper.innerizeText(this.a(bounds, text)));
        return text;
    }

    protected GraphicalElement createFigure(Bounds bounds) {
        Project project = ProjectManagerAdapter.getRootProject(this.getDiagram());
        GraphicalElement graphicalElement = this.createText(bounds);
        this.addTextSharedStyles(graphicalElement, project);
        Rectangle rectangle = DGFactory.eINSTANCE.createRectangle();
        rectangle.setBounds(this.a(bounds, graphicalElement));
        this.addSharedStyles(rectangle, project);
        Style style = this.createLocalStyle();
        if (style != null) {
            rectangle.getLocalStyles().add(style);
        }
        Group group = DGFactory.eINSTANCE.createGroup();
        group.getMembers().addAll(Arrays.asList(graphicalElement, rectangle));
        return group;
    }

    protected Style createLocalStyle() {
        Style style = DGFactory.eINSTANCE.createStyle();
        style.setStrokeWidth(0.0);
        style.setFillColor(null);
        return style;
    }

    protected void addTextSharedStyles(GraphicalElement graphicalElement, Project project) {
        EList<Style> eList = graphicalElement.getSharedStyles();
        StylePreferences stylePreferences = project.getStylePreferences();
        eList.add((Style)stylePreferences.getStyle("common_figure.font"));
    }

    protected void addSharedStyles(GraphicalElement graphicalElement, Project project) {
        EList<Style> eList = graphicalElement.getSharedStyles();
        StylePreferences stylePreferences = project.getStylePreferences();
        eList.add((Style)stylePreferences.getStyle("common_figure"));
        eList.add(NotationResources.getLibraryStyle(this.getDiagram(), "TextBox"));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        CJomtTextNode cJomtTextNode = this.de.getEditingNode();
        if (cJomtTextNode != null) {
            this.fireEditingNodeModifyCommand(mouseEvent, cJomtTextNode);
            cJomtTextNode.setComponentFocus(false);
            this.canvas.requestFocus();
        }
        CreateTextCommand createTextCommand = new CreateTextCommand();
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        double d4 = 150.0;
        double d5 = 10.0;
        Bounds bounds = DCFactory.eINSTANCE.createBounds(d2, d3, d4, d5);
        createTextCommand.setPresentation(this.prepareShape(bounds));
        this.canvas.unselect();
        createTextCommand.setShiftPressedState(mouseEvent.isShiftDown());
        createTextCommand.setDiagram(this.getDiagram());
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "CreateText", createTextCommand, mouseEvent.getModifiers()));
        mouseEvent.consume();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private Bounds a(Bounds bounds, Text text) {
        Font font = DGSetSizeHelper.getFont(text);
        Bounds bounds2 = DCFactory.eINSTANCE.createBounds(bounds.getX(), bounds.getY(), DGSetSizeHelper.getRawTextWidth(font, text.getData()), DGSetSizeHelper.getRawTextHeight(font, text.getData()));
        return bounds2;
    }

    private Bounds a(Bounds bounds, GraphicalElement graphicalElement) {
        Font font = DGSetSizeHelper.getFont(graphicalElement);
        Bounds bounds2 = DCFactory.eINSTANCE.createBounds(bounds.getX(), bounds.getY(), DGSetSizeHelper.getDefaultTextWidth(font, ((Text)graphicalElement).getData()), DGSetSizeHelper.getDefaultTextHeight(font, ((Text)graphicalElement).getData()));
        return bounds2;
    }
}

