/*
 * Decompiled with CFR 0.152.
 */
package net.astah.ui.control.mode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.RightAngleUtil;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jutil.IconButtonUtil;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jviewElement.DiagramViewElement;
import net.astah.notation.AnchorConstraint;
import net.astah.notation.Curve;
import net.astah.notation.Edge;
import net.astah.notation.LineConstraint;
import net.astah.notation.NotationFactory;
import net.astah.notation.NotationPackage;
import net.astah.notation.Shape;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.editor.EdgeAnchorHelper;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElements;
import net.astah.notation.util.NotationGetPointsHelper;
import net.astah.ui.control.CreateEdgeCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public abstract class CreateRelationMode
extends DiagramMode {
    private static final Map<String, EClass> a = new HashMap<String, EClass>(){
        private static final long serialVersionUID = -9030661142655813187L;
        {
            this.put("line", NotationPackage.Literals.LINE);
            this.put("line_right_angle", NotationPackage.Literals.RIGHT_ANGLE_LINE);
            this.put("curve", NotationPackage.Literals.CURVE);
            this.put("curve_right_angle", NotationPackage.Literals.RIGHT_ANGLE_CURVE);
        }
    };
    protected List<Pnt2d> points = new ArrayList<Pnt2d>();
    protected Pnt2d start = null;
    protected Pnt2d end = null;
    protected GNode source = null;
    protected GNode target = null;
    protected GArrow tempLine;
    protected GPolyline line;
    protected Pnt2d startPoint = null;
    protected boolean hasFirstReleased = false;
    private static final double b = 15.0;
    protected GNode tempRect0;
    protected GNode tempRect1;
    protected GNode tempRectShape;

    protected static DiagramElement getDiagramElement(GNode gNode) {
        if (gNode == null) {
            return null;
        }
        return DiagramElementOperations.getDiagramElement(gNode);
    }

    protected static boolean hasModel(DiagramElement diagramElement, Class<?> clazz) {
        if (diagramElement != null) {
            return DiagramElements.isModelElementPresent(diagramElement, clazz);
        }
        return false;
    }

    protected abstract Edge createEdge();

    protected abstract EModelElement createModelElement();

    protected Object[] createEdgeFactor() {
        Object[] objectArray = new Object[4];
        Edge edge = this.createEdge();
        DiagramElements.setModelElement(edge, this.createModelElement());
        LineConstraint lineConstraint = this.getLineConstraint();
        DiagramElement diagramElement = CreateRelationMode.getDiagramElement(this.source);
        DiagramElement diagramElement2 = CreateRelationMode.getDiagramElement(this.target);
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        AnchorConstraint anchorConstraint = EdgeAnchorHelper.createAnchor(diagramElement, Geometries.toPoint(this.points.get(0)));
        AnchorConstraint anchorConstraint2 = EdgeAnchorHelper.createAnchor(diagramElement2, Geometries.toPoint(this.points.get(this.points.size() - 1)));
        Point point = layoutCalculator.getOrigin(diagramElement);
        Bounds bounds = layoutCalculator.getEdgeEndBounds(edge, diagramElement, layoutCalculator.getAnchorPoint(diagramElement, anchorConstraint, point), null);
        point = layoutCalculator.getOrigin(diagramElement2);
        Bounds bounds2 = layoutCalculator.getEdgeEndBounds(edge, diagramElement2, layoutCalculator.getAnchorPoint(diagramElement2, anchorConstraint2, point), null);
        objectArray[0] = edge;
        List list = (List)NotationGetPointsHelper.INSTANCE.doSwitch(lineConstraint);
        if (RightAngleUtil.isRightAngle(lineConstraint)) {
            Rectangle2d rectangle2d = Geometries.toRectangle2d(bounds);
            Rectangle2d rectangle2d2 = Geometries.toRectangle2d(bounds2);
            if (this.isSetCenterPnt() || diagramElement instanceof Edge) {
                this.points.set(0, new Pnt2d(rectangle2d.getCenterX(), rectangle2d.getCenterY()));
            }
            if (this.isSetCenterPnt() || diagramElement2 instanceof Edge) {
                this.points.set(this.points.size() - 1, new Pnt2d(rectangle2d2.getCenterX(), rectangle2d2.getCenterY()));
            }
            List<Point> list2 = Geometries.toPoint(RightAngleUtil.getPointsForRightAngle(rectangle2d, rectangle2d2, this.points));
            list.addAll(list2);
        } else if (lineConstraint instanceof Curve && this.points.size() > 4) {
            Point point2 = Geometries.toPoint(this.points.get(1));
            Point point3 = Geometries.toPoint(this.points.get(this.points.size() - 2));
            list.add(point2);
            list.add(point3);
        } else {
            list.addAll(Geometries.toPoint(this.points).subList(1, this.points.size() - 1));
        }
        if (this.isSameEnds() && list.isEmpty()) {
            objectArray[1] = bounds;
            objectArray[2] = bounds;
            objectArray[3] = bounds;
        } else {
            if (diagramElement instanceof Edge || !this.isSetCenterPnt()) {
                objectArray[1] = anchorConstraint;
            }
            if (diagramElement2 instanceof Edge || !this.isSetCenterPnt()) {
                objectArray[2] = anchorConstraint2;
            }
            objectArray[3] = lineConstraint;
        }
        return objectArray;
    }

    protected LineConstraint getLineConstraint() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        String string = diagramEditor.getLineShapeButtonMode();
        EClass eClass = a.get(string);
        LineConstraint lineConstraint = eClass != null ? (LineConstraint)NotationFactory.eINSTANCE.create(eClass) : NotationFactory.eINSTANCE.createLine();
        return lineConstraint;
    }

    protected CreateEdgeCommand getCommand() {
        return new CreateEdgeCommand();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.start == null) {
            if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
                return;
            }
            mouseEvent.consume();
            return;
        }
        Pnt2d pnt2d = this.getMouseLocation(mouseEvent);
        this.canvas.draw();
        this.canvas.requestFocus();
        GNode gNode = this.getPickedNode(mouseEvent);
        this.editingNodeModify(mouseEvent, true);
        if (this.start != null) {
            if (InputEventSupport.isRightMouseButton(mouseEvent)) {
                this.cancelEditing();
                return;
            }
            if (CreateRelationMode.getDiagramElement(gNode) == null || !this.isValidTarget(CreateRelationMode.getDiagramElement(gNode))) {
                this.addTempLinePoint(pnt2d);
            } else {
                this.target = gNode;
                this.hasFirstReleased = true;
                if (this.hasFirstReleased && this.hasMoved(pnt2d)) {
                    this.createRelation(mouseEvent);
                } else if (!this.isSameEnds()) {
                    this.createRelation(mouseEvent);
                }
            }
        }
        mouseEvent.consume();
    }

    protected void addTempLinePoint(Pnt2d pnt2d) {
        this.points.add(pnt2d);
        Pnt2d[] pnt2dArray = new Pnt2d[]{this.end, pnt2d};
        this.line = new GPolyline(pnt2dArray);
        this.line.setColorNo((byte)2);
        this.setLineStyle();
        this.scene.addTempNode(this.line);
        this.end = pnt2d;
        if (this.tempLine != null) {
            this.scene.removeTempNode(this.tempLine);
            this.tempLine = null;
        }
        this.hasFirstReleased = true;
        this.canvas.clear();
        this.canvas.draw();
        this.canvas.drawTemp();
        this.canvas.repaint();
    }

    protected void setLineStyle() {
        this.line.setRimPattern((byte)0);
        this.line.setRimPatternScale(5);
    }

    protected void createRelation(MouseEvent mouseEvent) {
        Pnt2d pnt2d = this.getMouseLocation(mouseEvent);
        this.points.add(pnt2d);
        this.fireCommand(mouseEvent);
        this.clear();
    }

    protected boolean isSameEnds() {
        return CreateRelationMode.getDiagramElement(this.source) == CreateRelationMode.getDiagramElement(this.target);
    }

    protected boolean hasMoved(Pnt2d pnt2d) {
        return this.startPoint.distance(pnt2d) > 15.0;
    }

    protected void cancelEditing() {
        this.clear();
    }

    protected void clear() {
        this.points.clear();
        this.start = null;
        this.end = null;
        this.scene.removeAllTempNodes();
        this.tempLine = null;
        this.hasFirstReleased = false;
        this.source = null;
        this.target = null;
        this.canvas.clear();
        this.canvas.draw();
        this.canvas.repaint();
    }

    protected abstract void fireCommand(MouseEvent var1);

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.hightLightStart(mouseEvent);
        if (this.end == null) {
            mouseEvent.consume();
            return;
        }
        this.doAutoScroll(mouseEvent);
        if (this.tempLine != null) {
            this.scene.removeTempNode(this.tempLine);
        }
        Pnt2d[] pnt2dArray = new Pnt2d[]{this.end, this.getMouseLocation(mouseEvent)};
        this.tempLine = new GArrow();
        this.tempLine.setColorNo((byte)4);
        this.tempLine.setBackgroundNo((byte)0);
        this.tempLine.setPoints(pnt2dArray);
        this.scene.addTempNode(this.tempLine);
        this.target = null;
        GNode gNode = this.getPickedNode(mouseEvent);
        if (gNode != null) {
            this.target = gNode;
            this.highlightEnd(gNode, 1);
        } else {
            this.removeTempRect(this.tempRect1);
        }
        this.canvas.repaintSync();
        this.canvas.drawTempFront();
        mouseEvent.consume();
    }

    protected void hightLightStart(MouseEvent mouseEvent) {
        if (this.start == null) {
            GNode gNode = this.getPickedNode(mouseEvent);
            DiagramElement diagramElement = CreateRelationMode.getDiagramElement(gNode);
            if (diagramElement != null) {
                if (diagramElement != CreateRelationMode.getDiagramElement(this.source)) {
                    if (this.isLegalStart(diagramElement)) {
                        this.highlightEnd(gNode, 0);
                    } else {
                        this.removeTempRect(this.tempRect0);
                    }
                }
            } else {
                this.removeTempRect(this.tempRect0);
            }
        }
    }

    protected void highlightEnd(GNode gNode, int n2) {
        DiagramElement diagramElement = CreateRelationMode.getDiagramElement(gNode);
        if (!this.isValidTarget(diagramElement) || n2 == 1 && !this.isLegalEnd(diagramElement)) {
            return;
        }
        this.tempRectShape = n2 == 0 ? this.tempRect0 : this.tempRect1;
        if (this.tempRectShape != null) {
            this.scene.removeTempNode(this.tempRectShape);
            this.tempRectShape = null;
        }
        this.tempRectShape = ((IViewElement)((Object)gNode)).createFeedbackShape();
        if (this.tempRectShape != null) {
            if (this.tempRectShape instanceof GRimmedGeometry) {
                ((GRimmedGeometry)this.tempRectShape).setRimWidth(2);
            }
            this.scene.addTempNode(this.tempRectShape);
        }
        if (n2 == 0) {
            this.tempRect0 = this.tempRectShape;
        } else {
            this.tempRect1 = this.tempRectShape;
        }
        this.canvas.repaintSync();
        this.canvas.drawTempFront();
    }

    protected void removeTempRect(GNode gNode) {
        boolean bl = false;
        if (gNode == this.tempRect0) {
            bl = true;
        }
        if (gNode != null && this.tempRectShape != null) {
            this.scene.removeTempNode(this.tempRectShape);
            this.tempRectShape = null;
        }
        gNode = null;
        if (bl) {
            this.canvas.repaintSync();
            this.canvas.drawTempFront();
        }
    }

    protected void doAutoScroll(MouseEvent mouseEvent) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        this.autoScroll(mouseEvent, bl3, bl4, bl, bl2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        Pnt2d pnt2d = this.getMouseLocation(mouseEvent);
        this.canvas.draw();
        this.editingNodeModify(mouseEvent, true);
        if (this.start == null) {
            if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
                mouseEvent.consume();
                return;
            }
            this.source = this.getPickedNode(mouseEvent);
            if (this.isLegalStart(CreateRelationMode.getDiagramElement(this.source))) {
                Pnt2d pnt2d2;
                this.end = this.isSetCenterPnt() && (pnt2d2 = this.getCenterPoint(this.source)) != null ? (this.start = new Pnt2d(pnt2d2)) : (this.start = pnt2d);
                this.startPoint = pnt2d;
                this.points.add(this.start);
            } else {
                this.source = null;
            }
            mouseEvent.consume();
            return;
        }
        mouseEvent.consume();
    }

    protected boolean isValidTarget(DiagramElement diagramElement) {
        return true;
    }

    public boolean isLegalStart(DiagramElement diagramElement) {
        return true;
    }

    public boolean isLegalEnd(DiagramElement diagramElement) {
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.cancelEditing();
        }
    }

    protected int getPickableType() {
        return 65;
    }

    protected GNode getPickedNode(MouseEvent mouseEvent) {
        GNode gNode = this.getFrontNode(mouseEvent);
        if (gNode == null || gNode.getModel() == null) {
            return null;
        }
        IViewElement iViewElement = ViewElements.getAncestor(gNode, IViewElement.class);
        if (iViewElement == null || !(iViewElement.getModel() instanceof DiagramElement)) {
            return null;
        }
        GNode gNode2 = this.getAppropriateNode((GNode)((Object)iViewElement));
        return this.excludeAncestorIfContainPath(gNode2);
    }

    protected GNode getFrontNode(MouseEvent mouseEvent) {
        GNode gNode = (GNode)((Object)IconButtonUtil.getStartPickedObject(IViewElement.class));
        if (gNode == null) {
            gNode = CreateRelationMode.getMinDepthNode(this.ignoreRimmedPick(() -> {
                List<GNode> list = this.getPickedNodes(mouseEvent, this.getPickableType());
                return list.stream().filter(gNode -> this.isValidTarget(CreateRelationMode.getDiagramElement(gNode))).collect(Collectors.toList());
            }));
        }
        return gNode;
    }

    protected GNode getAppropriateNode(GNode gNode) {
        if (gNode instanceof IViewElement) {
            return gNode;
        }
        return null;
    }

    protected GNode excludeAncestorIfContainPath(GNode gNode) {
        if (gNode == null || this.source == null || this.points.isEmpty() || gNode == this.source) {
            return gNode;
        }
        GNode gNode2 = ViewElements.getCommonAncestor(gNode, this.source);
        if (gNode2 instanceof DiagramViewElement || gNode2 != gNode) {
            return gNode;
        }
        Bounds bounds = new LayoutCalculator().getBounds(CreateRelationMode.getDiagramElement(gNode2));
        if (bounds == null) {
            return gNode;
        }
        Rectangle2d rectangle2d = Geometries.toRectangle2d(bounds);
        if (this.points.stream().allMatch(rectangle2d::contains)) {
            return null;
        }
        return gNode;
    }

    protected boolean isSetCenterPnt() {
        return this.de.getDiagramScene().getDiagramViewInfo().isSetCenterPntMode();
    }

    protected Pnt2d getCenterPoint(GNode gNode) {
        DiagramElement diagramElement = DiagramElementOperations.getDiagramElement(gNode);
        if (diagramElement instanceof Shape) {
            Bounds bounds = new LayoutCalculator().getBounds(diagramElement);
            return new Pnt2d(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
        }
        return null;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }
}

