/*
 * Decompiled with CFR 0.152.
 */
package net.astah.ui.control.mode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import net.astah.dd.dc.Point;
import net.astah.dd.dg.DGFactory;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Style;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GFreeHandArrow;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jomt.jcontrol.CreatePolyLineCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.IItemEditorFactory;
import net.astah.notation.resource.NotationResources;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class CreatePolyLineMode
extends DiagramMode {
    private static final double c = 5.0;
    private GFreeHandArrow d;
    private Pnt2d e;
    private Pnt2d f;
    List<Pnt2d> a = new ArrayList<Pnt2d>();
    boolean b = false;

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    protected GraphicalShape prepareShape(List<Point> list) {
        GraphicalElement graphicalElement = this.createFigure(list);
        GraphicalShape graphicalShape = this.createShape();
        graphicalShape.setFigure(graphicalElement);
        return graphicalShape;
    }

    protected GraphicalShape createShape() {
        IItemEditorFactory iItemEditorFactory = ItemProviders.adapt(this.getDiagram(), IItemEditorFactory.class);
        EClass eClass = iItemEditorFactory.getGraphicalShapeClass();
        if (eClass == null) {
            throw new UnsupportedOperationException("\u672a\u5bfe\u5fdc\u306e\u56f3");
        }
        return (GraphicalShape)EcoreUtil.create(eClass);
    }

    protected GraphicalElement createFigure(List<Point> list) {
        Style style = NotationResources.getLibraryStyle(this.getDiagram(), "FreeHand");
        Polyline polyline = DGFactory.eINSTANCE.createPolyline();
        polyline.getPoints().addAll(list);
        polyline.getSharedStyles().add(style);
        return polyline;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.isDragged = false;
        if (this.f == null || !this.b) {
            mouseEvent.consume();
            return;
        }
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            this.scene.removeTempNode(this.d);
            this.canvas.repaint();
        } else {
            this.canvas.unselect();
            CreatePolyLineCommand createPolyLineCommand = new CreatePolyLineCommand();
            createPolyLineCommand.setPresentation(this.prepareShape(Geometries.toPoint(this.a)));
            createPolyLineCommand.setDiagram(this.getDiagram());
            createPolyLineCommand.setShiftPressedState(mouseEvent.isShiftDown());
            this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "CreatePolyLine", createPolyLineCommand, mouseEvent.getModifiers()));
            this.scene.removeTempNode(this.d);
            this.canvas.repaint();
            this.f = null;
            this.b = false;
            mouseEvent.consume();
        }
    }

    protected GFreeHandArrow getGFreeHandArrow() {
        GFreeHandArrow gFreeHandArrow = new GFreeHandArrow();
        gFreeHandArrow.setColorNo((byte)4);
        gFreeHandArrow.setRimWidth(5);
        gFreeHandArrow.setAlpha(0.4f);
        return gFreeHandArrow;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.de.hidePopupMenus();
        this.d = this.getGFreeHandArrow();
        this.scene.addTempNode(this.d);
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        this.e = new Pnt2d(d2, d3);
        this.a.clear();
        this.a.add(this.e);
        this.f = new Pnt2d();
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.isDragged = true;
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
        if (this.f == null) {
            return;
        }
        if (!this.isDragged) {
            return;
        }
        this.b = true;
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        this.f.set(d2, d3);
        if (this.a.isEmpty() || this.a(this.f, this.a.get(this.a.size() - 1)) > 5.0) {
            this.a.add(new Pnt2d(this.f.x, this.f.y));
            this.d.setPoints(this.a.toArray(new Pnt2d[this.a.size()]));
            this.canvas.drawTemp();
            this.canvas.repaint();
        }
    }

    private double a(Pnt2d pnt2d, Pnt2d pnt2d2) {
        double d2 = Math.sqrt(Math.pow(pnt2d2.x - pnt2d.x, 2.0) + Math.pow(pnt2d2.y - pnt2d.y, 2.0));
        return d2;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.scene.removeTempNode(this.d);
            this.canvas.repaint();
        }
    }
}

