/*
 * Decompiled with CFR 0.152.
 */
package net.astah.ui.control.mode;

import java.awt.event.MouseEvent;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dg.DGFactory;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Image;
import net.astah.dd.dg.Style;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jomt.jcontrol.CreateImageCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.IItemEditorFactory;
import net.astah.notation.resource.NotationResources;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class CreateImageMode
extends DiagramMode {
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        CJomtTextNode cJomtTextNode = this.de.getEditingNode();
        if (cJomtTextNode != null) {
            this.fireEditingNodeModifyCommand(mouseEvent, cJomtTextNode);
            cJomtTextNode.setComponentFocus(false);
            this.canvas.requestFocus();
        }
        this.canvas.unselect();
        this.a(mouseEvent);
        mouseEvent.consume();
        this.scene.removeAllTempNodes();
    }

    private void a(MouseEvent mouseEvent) {
        CreateImageCommand createImageCommand = new CreateImageCommand();
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        createImageCommand.setPresentation(this.prepareShape(DCFactory.eINSTANCE.createBounds(d2, d3, 0.0, 0.0)));
        createImageCommand.setDiagram(this.getDiagram());
        createImageCommand.setShiftPressedState(mouseEvent.isShiftDown());
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "CreateImage", createImageCommand, mouseEvent.getModifiers()));
    }

    protected GraphicalShape prepareShape(Bounds bounds) {
        GraphicalElement graphicalElement = this.createFigure(bounds);
        GraphicalShape graphicalShape = this.createShape();
        graphicalShape.setFigure(graphicalElement);
        return graphicalShape;
    }

    protected GraphicalShape createShape() {
        IItemEditorFactory iItemEditorFactory = ItemProviders.adapt(this.getDiagram(), IItemEditorFactory.class);
        EClass eClass = iItemEditorFactory.getGraphicalShapeClass();
        if (eClass == null) {
            throw new UnsupportedOperationException("\u672a\u5bfe\u5fdc\u306e\u56f3");
        }
        return (GraphicalShape)EcoreUtil.create(eClass);
    }

    protected GraphicalElement createFigure(Bounds bounds) {
        Style style = NotationResources.getLibraryStyle(this.getDiagram(), "Image");
        Image image = DGFactory.eINSTANCE.createImage();
        image.setBounds(bounds);
        image.getSharedStyles().add(style);
        return image;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }
}

