/*
 * Decompiled with CFR 0.152.
 */
package net.astah.swing;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import net.astah.dd.di.Diagram;
import net.astah.jomt.jutil.CastUtil;
import net.astah.swing.c;
import net.astah.swing.d;

public class SortableTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 5054016015679607554L;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    a[] directives;
    protected int column = 0;
    protected Map<Class<?>, Comparator<?>> columnComparators = new HashMap();
    public static final Comparator<Comparable<Object>> COMPARABLE_COMPARATOR = new net.astah.swing.b();
    public static final Comparator<Object> LEXICAL_COMPARATOR = new c();
    public static final Comparator<Diagram> DIAGRAM_COMPARATOR = new d();
    protected b[] viewToModel;

    public SortableTableModel(int n2) {
        this(n2, true);
    }

    public SortableTableModel(int n2, boolean bl) {
        if (bl) {
            this.initSortingInfo(n2);
        }
    }

    public SortableTableModel(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initSortingInfo(this.getColumnCount());
    }

    protected void initSortingInfo(int n2) {
        this.directives = new a[n2];
        for (int i2 = 0; i2 < this.directives.length; ++i2) {
            this.directives[i2] = new a(i2, 1);
        }
        this.updateSortingInfo();
    }

    public void updateSortingInfo() {
        if (this.viewToModel == null || this.viewToModel.length != this.getRowCount()) {
            int n2 = this.getRowCount();
            this.viewToModel = new b[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.viewToModel[i2] = new b(i2);
            }
        }
    }

    public void changeDirection(int n2) {
        this.directives[n2].b = this.directives[n2].b != 1 ? 1 : -1;
    }

    public boolean isDesending(int n2) {
        return this.directives[n2].b == -1;
    }

    public boolean isNotSorted(int n2) {
        return this.directives[n2].b == 0;
    }

    public boolean isAscending(int n2) {
        return this.directives[n2].b == 1;
    }

    public void changeOrder(int n2) {
        this.changeDirection(n2);
        this.sort(n2);
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        Vector vector = (Vector)CastUtil.automaticCast(this.dataVector.elementAt(0));
        Object e2 = vector.elementAt(n2);
        if (e2 == null) {
            return super.getColumnClass(n2);
        }
        return e2.getClass();
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        Class<?> clazz = this.getColumnClass(n3);
        return clazz == Boolean.class;
    }

    public void sort(int n2) {
        this.column = n2;
        Arrays.sort(this.viewToModel);
    }

    public void setColumnComparator(Class<?> clazz, Comparator<?> comparator) {
        if (comparator == null) {
            this.columnComparators.remove(clazz);
        } else {
            this.columnComparators.put(clazz, comparator);
        }
    }

    protected Comparator<?> getComparator(Class<?> clazz) {
        Comparator<?> comparator = this.columnComparators.get(clazz);
        if (comparator != null) {
            return comparator;
        }
        if (Diagram.class.isAssignableFrom(clazz)) {
            return DIAGRAM_COMPARATOR;
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            return COMPARABLE_COMPARATOR;
        }
        return LEXICAL_COMPARATOR;
    }

    protected int modelIndex(int n2) {
        return this.viewToModel[n2].a;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        this.updateSortingInfo();
        return super.getValueAt(this.modelIndex(n2), n3);
    }

    public Object getSuperValueAt(int n2, int n3) {
        return super.getValueAt(n2, n3);
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this.updateSortingInfo();
        int n4 = this.modelIndex(n2);
        Vector vector = (Vector)this.dataVector.elementAt(n4);
        vector.setElementAt(object, n3);
        this.fireTableCellUpdated(n2, n3);
    }

    public void moveUp(int n2, Object[] objectArray) {
        int n3;
        if (n2 < 1) {
            return;
        }
        int n4 = this.viewToModel[n2].a;
        this.viewToModel[n2].a = n3 = this.viewToModel[n2 - 1].a;
        this.viewToModel[n2 - 1].a = n4;
    }

    public void moveDown(int n2, Object[] objectArray) {
        int n3;
        if (n2 < 0 || n2 == objectArray.length - 1) {
            return;
        }
        int n4 = this.viewToModel[n2].a;
        this.viewToModel[n2].a = n3 = this.viewToModel[n2 + 1].a;
        this.viewToModel[n2 + 1].a = n4;
    }

    public int getSortedViewIndex(int n2) {
        for (int i2 = 0; i2 < this.viewToModel.length - 1; ++i2) {
            if (this.viewToModel[i2].a != n2) continue;
            return i2;
        }
        return this.viewToModel.length - 1;
    }

    protected static class a {
        protected int a;
        protected int b;

        public a(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }
    }

    protected class b
    implements Comparable<Object> {
        protected int a;

        public b(int n2) {
            this.a = n2;
        }

        @Override
        public int compareTo(Object object) {
            a a2 = SortableTableModel.this.directives[SortableTableModel.this.column];
            int n2 = a2.a;
            Object object2 = SortableTableModel.this.getSuperValueAt(this.a, n2);
            Object object3 = SortableTableModel.this.getSuperValueAt(((b)object).a, n2);
            int n3 = 0;
            if (object2 == null && object3 == null) {
                n3 = 0;
            } else if (object2 == null) {
                n3 = -1;
            } else if (object3 == null) {
                n3 = 1;
            } else {
                Comparator<?> comparator = SortableTableModel.this.getComparator(SortableTableModel.this.getColumnClass(n2));
                n3 = comparator.compare(CastUtil.automaticCast(object2), CastUtil.automaticCast(object3));
            }
            if (n3 != 0) {
                return a2.b == -1 ? -n3 : n3;
            }
            return 0;
        }
    }
}

