/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.edit.provider.IDisposable;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class TreeNodeExpander
implements PropertyChangeListener,
TreeExpansionListener,
TreeModelListener,
IDisposable {
    protected final JTree tree;
    private final Set<TreePath> a = new HashSet<TreePath>();

    public TreeNodeExpander(JTree jTree) {
        Assert.isNotNull(jTree, "tree");
        this.tree = jTree;
        jTree.addPropertyChangeListener(this);
        jTree.addTreeExpansionListener(this);
        TreeModel treeModel = jTree.getModel();
        if (treeModel != null) {
            treeModel.addTreeModelListener(this);
        }
    }

    @Override
    public void dispose() {
        this.tree.removePropertyChangeListener(this);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (this.tree.getModel() == treeModelEvent.getSource()) {
            this.tree.expandPath(treeModelEvent.getTreePath());
            if (treeModelEvent.getChildren().length > 0 && treeModelEvent.getChildren()[0] != null) {
                TreePath treePath = treeModelEvent.getTreePath().pathByAddingChild(treeModelEvent.getChildren()[0]);
                this.tree.scrollPathToVisible(treePath);
                this.tree.clearSelection();
            }
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath() == null || treeModelEvent.getTreePath().getPathCount() == 1) {
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>(this.a);
            this.a.clear();
            for (TreePath treePath : arrayList) {
                this.tree.expandPath(treePath);
            }
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.a.add(treeExpansionEvent.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.a.remove(treeExpansionEvent.getPath());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.tree && "model".equals(propertyChangeEvent.getPropertyName())) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof TreeModel) {
                ((TreeModel)object2).removeTreeModelListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof TreeModel) {
                ((TreeModel)object).addTreeModelListener(this);
            }
        }
    }
}

