/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.proptab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.ModelParameters;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.ModelVersionInfo;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.VersionHistoryTable;
import net.astah.jomt.jview.proptab.ModelTab;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class VersionHistoryTab
extends ModelTab {
    private final PropertyChangeListener listener = propertyChangeEvent -> SwingInvoker.runInEDT(this::update);
    protected JLabel productVersion;
    protected JLabel projectVersion;
    protected VersionHistoryTable table;
    protected JLabel lastModifiedTime;

    public VersionHistoryTab() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (iJomtEntityStore != null) {
            iJomtEntityStore.addPropertyChangeListener("modified", this.listener);
        }
    }

    @Override
    public void remove() {
        super.remove();
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (iJomtEntityStore != null) {
            iJomtEntityStore.removePropertyChangeListener("modified", this.listener);
        }
    }

    @Override
    protected void initPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        this.lastModifiedTime = new JLabel();
        this.productVersion = new JLabel();
        this.projectVersion = new JLabel();
        this.updateVersionLabel();
        jPanel2.add(this.lastModifiedTime);
        jPanel2.add(this.productVersion);
        jPanel2.add(this.projectVersion);
        this.table = new VersionHistoryTable();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.add(jPanel);
    }

    protected void updateVersionLabel() {
        if (ModelGlobal.prjManager.getCurrentProject() == null) {
            return;
        }
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        ResourceSet resourceSet = iJomtEntityStore.getDomain().getResourceSet();
        Project project = ProjectManagerAdapter.getRootProject(resourceSet);
        String string = "-";
        if (project != null && project.getLastModified() != null) {
            string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).format(project.getLastModified());
        }
        this.lastModifiedTime.setText(VersionHistoryTab.getTitle("projectview.item.last_modified_time.label") + " : " + string);
        String string2 = String.valueOf(ModelVersionInfo.getModelVersion());
        this.productVersion.setText(VersionHistoryTab.getTitle("projectview.item.product_model_version.label") + " : " + string2);
        this.updateProjectVersion(project);
    }

    protected void updateProjectVersion(Project project) {
        String string = "";
        if (project != null) {
            string = String.valueOf(project.getLastModelVersion());
        }
        this.projectVersion.setText(VersionHistoryTab.getTitle("projectview.item.project_model_version.label") + " : " + string);
    }

    @Override
    public List<ModelParameters> getModelParameters() {
        return new ArrayList<ModelParameters>(0);
    }

    @Override
    public String getTabName() {
        return VersionHistoryTab.getTitle("projectview.tab.version_history.label");
    }

    @Override
    protected void update() {
        this.init();
        this.updateVersionLabel();
        this.table.updateVersionHistory();
    }

    @Override
    protected void updatePanelEditors() {
        super.updatePanelEditors();
        if (this.table != null) {
            this.table.setEnabled(false);
        }
    }
}

