/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.proptab;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.astah.golf.control.GolfAction;
import net.astah.golf.control.TableCellListener;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.golf.widget.swing.SwingFrame;
import net.astah.jmodel.ModelParameters;
import net.astah.jomt.jcontrol.ApplyStereotypeFromPropViewCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jutil.ProfileUtilities;
import net.astah.jomt.jutil.TableUtil;
import net.astah.jomt.jview.PropertyNameComboBox;
import net.astah.jomt.jview.StereotypeHolder;
import net.astah.jomt.jview.StereotypeSelectionDialog;
import net.astah.jomt.jview.proptab.ModelTab;
import net.astah.jomt.jview.proptab.MyCellRenderer;
import net.astah.jomt.jview.proptab.k;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StereotypesTab
extends ModelTab
implements StereotypeHolder {
    private static final Logger a = LoggerFactory.getLogger(StereotypesTab.class);
    private static final long serialVersionUID = -5925289092635689481L;
    protected DefaultTableModel tableModel;
    protected JTable table;
    protected List<Stereotype> stereotypeList = new ArrayList<Stereotype>();
    protected PropertyNameComboBox<Stereotype> stereotypeCombo;
    protected JPanel buttonPanel = null;
    private TableCellListener editingCellListener;
    private static final JFrame b = (JFrame)((SwingFrame)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();

    public StereotypesTab() {
    }

    public StereotypesTab(Stereotype stereotype) {
        super(stereotype);
    }

    @Override
    protected void initPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn(StereotypesTab.getTitle("projectview.table.header.name.label"));
        this.table = new AdjustedRowHeightTable(this.tableModel);
        this.table.setShowGrid(false);
        this.table.setDefaultRenderer(this.table.getColumnClass(0), new StereotypeCellRenderer(null));
        this.editingCellListener = new TableCellListener(this.table);
        this.table.addPropertyChangeListener(this.editingCellListener);
        this.stereotypeCombo = new PropertyNameComboBox();
        this.stereotypeCombo.setEditable(false);
        this.stereotypeCombo.setMaximumRowCount(20);
        int n2 = TableUtil.getColumnIndex(this.table, StereotypesTab.getTitle("projectview.table.header.name.label"));
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
        tableColumn.setCellEditor(new DefaultCellEditor(this.stereotypeCombo));
        this.stereotypeCombo.setRenderer(new MyCellRenderer<Stereotype>(this.stereotypeCombo));
        this.stereotypeCombo.addItemListener(new k(this));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JButton jButton = new JButton(StereotypesTab.getTitle("projectview.button.add.label"));
        JButton jButton2 = new JButton(StereotypesTab.getTitle("projectview.button.delete.label"));
        JButton jButton3 = new JButton(StereotypesTab.getTitle("projectview.button.up.label"));
        JButton jButton4 = new JButton(StereotypesTab.getTitle("projectview.button.down.label"));
        this.setMinimumSize(jButton);
        this.setMinimumSize(jButton2);
        this.setMinimumSize(jButton3);
        this.setMinimumSize(jButton4);
        jButton.addActionListener(new GolfAction("CreateStereotypeFromPropView"){
            private static final long serialVersionUID = -6454980984246503585L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StereotypesTab.this.model instanceof Element) {
                    Element element = (Element)StereotypesTab.this.model;
                    StereotypeSelectionDialog stereotypeSelectionDialog = new StereotypeSelectionDialog((Frame)b, element);
                    stereotypeSelectionDialog.setVisible(true);
                    if (stereotypeSelectionDialog.getResult() != 0) {
                        return;
                    }
                    ApplyStereotypeFromPropViewCommand applyStereotypeFromPropViewCommand = new ApplyStereotypeFromPropViewCommand();
                    applyStereotypeFromPropViewCommand.setModel(element);
                    applyStereotypeFromPropViewCommand.setStereotype(stereotypeSelectionDialog.getSelected());
                    applyStereotypeFromPropViewCommand.start();
                } else {
                    super.actionPerformed(actionEvent);
                }
            }
        });
        jButton2.addActionListener(new GolfAction("UnapplyStereotypeFromPropView"));
        jButton3.addActionListener(new GolfAction("UpStereotypeFromPropView"));
        jButton4.addActionListener(new GolfAction("DownStereotypeFromPropView"));
        this.buttonPanel = new JPanel(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 0));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        this.buttonPanel.add(jPanel2);
        jPanel.add("Center", jScrollPane);
        jPanel.add("South", this.buttonPanel);
        jScrollPane.addMouseListener(new ModelTab.b(this.table));
        this.add(jPanel);
    }

    @Override
    public List<ModelParameters> getModelParameters() {
        ArrayList<ModelParameters> arrayList = new ArrayList<ModelParameters>();
        return arrayList;
    }

    @Override
    public String getTabName() {
        return StereotypesTab.getTitle("projectview.tab.stereotype.label");
    }

    @Override
    protected void update() {
        int n2;
        a.trace("update : StereotypesTab");
        this.init();
        this.enableActionListener(false);
        this.updateStereotypeCombo();
        EList<Stereotype> eList = ProfileUtilities.getStereotypes((Element)this.model, ((Element)this.model).getAppliedStereotypes());
        this.stereotypeList.clear();
        int n3 = 0;
        for (n2 = 0; n2 < eList.size(); ++n2) {
            Stereotype stereotype = (Stereotype)eList.get(n2);
            if (!this.isValidStereotype(n2, stereotype)) continue;
            ++n3;
            this.stereotypeList.add(stereotype);
        }
        this.tableModel.setNumRows(n3);
        n2 = TableUtil.getColumnIndex(this.table, StereotypesTab.getTitle("projectview.table.header.name.label"));
        for (int i2 = 0; i2 < this.stereotypeList.size(); ++i2) {
            Stereotype stereotype = this.stereotypeList.get(i2);
            this.table.setValueAt(stereotype, i2, n2);
        }
        this.table.removeEditor();
        this.table.clearSelection();
        this.table.repaint();
        this.enableActionListener(true);
    }

    protected boolean isValidStereotype(int n2, Object object) {
        return true;
    }

    protected void updateStereotypeCombo() {
        this.stereotypeCombo.removeAllItems();
        Element element = (Element)this.model;
        EList<Stereotype> eList = element.getApplicableStereotypes();
        for (Stereotype stereotype : eList) {
            this.stereotypeCombo.addItem(stereotype);
        }
    }

    protected boolean isValidStereotype(String string) {
        return true;
    }

    @Override
    public Iterator<Stereotype> getSelectedStereotypes() {
        int[] nArray = this.table.getSelectedRows();
        ArrayList<Stereotype> arrayList = new ArrayList<Stereotype>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            Stereotype stereotype = this.stereotypeList.get(n2);
            arrayList.add(stereotype);
        }
        return arrayList.iterator();
    }

    @Override
    public void selectStereotype(Stereotype stereotype) {
        for (int i2 = 0; i2 < this.stereotypeList.size(); ++i2) {
            Stereotype stereotype2 = this.stereotypeList.get(i2);
            if (stereotype2 != stereotype) continue;
            this.table.clearSelection();
            this.table.getSelectionModel().addSelectionInterval(i2, i2);
            return;
        }
    }

    private List<Stereotype> a() {
        ArrayList<Stereotype> arrayList = new ArrayList<Stereotype>();
        for (int i2 = 0; i2 < this.table.getRowCount(); ++i2) {
            Stereotype stereotype = (Stereotype)this.table.getValueAt(i2, 0);
            if (stereotype == null) {
                return null;
            }
            arrayList.add(stereotype);
        }
        return arrayList;
    }

    static /* synthetic */ List access$100(StereotypesTab stereotypesTab) {
        return stereotypesTab.a();
    }

    static /* synthetic */ TableCellListener access$200(StereotypesTab stereotypesTab) {
        return stereotypesTab.editingCellListener;
    }

    private final class StereotypeCellRenderer
    extends DefaultTableCellRenderer {
        private StereotypeCellRenderer() {
        }

        @Override
        protected void setValue(Object object) {
            if (object instanceof Stereotype) {
                Stereotype stereotype = (Stereotype)object;
                String string = stereotype == null ? "" : stereotype.getName();
                this.setText(string);
            }
        }

        /* synthetic */ StereotypeCellRenderer(k k2) {
            this();
        }
    }
}

