/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.proptab;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTabbedPane;
import net.astah.golf.control.BaseCommandSetting;
import net.astah.golf.control.GolfAction;
import net.astah.golf.draw.GCanvasSelectionEvent;
import net.astah.golf.draw.GNode;
import net.astah.jmodel.ModelParameters;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.proptab.ModelTab;
import net.astah.jomt.jviewElement.SwingJomtTextFieldNode;
import net.astah.uml2.uml.Stereotypes;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.TemplateParameter;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class ModelTabGroup
extends JTabbedPane {
    private static final long serialVersionUID = -355474290120810710L;
    protected EObject model;
    protected List<ModelTab> modelTabs = new ArrayList<ModelTab>();
    private ModelTab currentModelTab;

    public ModelTabGroup() {
        super.setTabLayoutPolicy(0);
    }

    public ModelTabGroup(Element element) {
        this.setModel(element, null);
        super.setTabLayoutPolicy(0);
    }

    public void setModel(EObject eObject, EventObject eventObject) {
        this.model = this.getBaseModel(eObject, eventObject);
        this.setTabModels();
    }

    protected void setTabModels() {
        for (int i2 = 0; i2 < this.modelTabs.size(); ++i2) {
            ModelTab modelTab = this.modelTabs.get(i2);
            modelTab.setModel(this.model);
        }
    }

    public boolean hasModelElement(Element element) {
        return this.model.equals(element);
    }

    public EObject getModelElement() {
        return this.model;
    }

    public List<ModelParameters> getModelParameters() {
        ArrayList<ModelParameters> arrayList = new ArrayList<ModelParameters>();
        for (int i2 = 0; i2 < this.modelTabs.size(); ++i2) {
            ModelTab modelTab = this.modelTabs.get(i2);
            arrayList.addAll(modelTab.getModelParameters());
        }
        return arrayList;
    }

    public List<ModelParameters> getCurrentModelParameters() {
        return this.currentModelTab.getModelParameters();
    }

    public ModelTab getCurrentModelTab() {
        return this.currentModelTab;
    }

    public void addModelTab(ModelTab modelTab) {
        this.modelTabs.add(modelTab);
        this.addTab(modelTab.getTabName(), modelTab);
    }

    public void remove() {
        for (int i2 = 0; i2 < this.modelTabs.size(); ++i2) {
            ModelTab modelTab = this.modelTabs.get(i2);
            modelTab.remove();
        }
        this.modelTabs.clear();
        this.currentModelTab = null;
        this.model = null;
    }

    @Override
    public void setSelectedIndex(int n2) {
        GolfAction golfAction = new GolfAction(BaseCommandSetting.getModelUpdateCommandName());
        golfAction.actionPerformed(new ActionEvent(this, 0, null));
        if (this.currentModelTab != null) {
            this.currentModelTab.setSelected(false);
        }
        super.setSelectedIndex(n2);
        this.currentModelTab = (ModelTab)this.getComponentAt(n2);
        if (this.currentModelTab != null) {
            this.currentModelTab.init(true);
            this.currentModelTab.updatePanel();
            this.currentModelTab.setSelected(true);
        }
    }

    public void showPreferredTab(EObject eObject) {
    }

    public void showPreferredTab(EObject eObject, EventObject eventObject) {
        this.showPreferredTab(eObject);
    }

    protected EObject getBaseModel(EObject eObject, EventObject eventObject) {
        Element element = this.getStereotypeExtendedElement(eObject, eventObject);
        if (element != null) {
            return element;
        }
        if (eObject instanceof TemplateParameter) {
            return ((TemplateParameter)eObject).getSignature().getTemplate();
        }
        if (eObject instanceof Constraint) {
            if (eObject instanceof InteractionConstraint) {
                eObject = ModelTabGroup.a((InteractionConstraint)eObject);
            } else {
                EList<Element> eList = ((Constraint)eObject).getConstrainedElements();
                if (eList.size() == 1) {
                    eObject = (Element)eList.get(0);
                }
            }
        }
        return eObject;
    }

    Element getStereotypeExtendedElement(EObject eObject, EventObject eventObject) {
        if (!(eventObject instanceof GCanvasSelectionEvent)) {
            return null;
        }
        GCanvasSelectionEvent gCanvasSelectionEvent = (GCanvasSelectionEvent)eventObject;
        List<GNode> list = gCanvasSelectionEvent.getNewSelectionNodes();
        for (GNode gNode : list) {
            Element element;
            SwingJomtTextFieldNode swingJomtTextFieldNode;
            UserObject userObject;
            GNode gNode2 = gNode.getParent();
            if (!(gNode2 instanceof SwingJomtTextFieldNode) || (userObject = (UserObject)(swingJomtTextFieldNode = (SwingJomtTextFieldNode)gNode2).getModel()).getModel() != eObject || !swingJomtTextFieldNode.isStereotypeNode() || this.a(element = (Element)((UserObject)swingJomtTextFieldNode.getParent().getModel()).getModel(), eObject)) continue;
            return element;
        }
        return null;
    }

    private boolean a(Element element, EObject eObject) {
        return !Stereotypes.getStereotypeApplications(element).contains(eObject);
    }

    boolean isStereotype(EObject eObject, EventObject eventObject) {
        return this.getStereotypeExtendedElement(eObject, eventObject) != null;
    }

    private static EObject a(InteractionConstraint interactionConstraint) {
        Element element;
        Element element2 = interactionConstraint.getOwner();
        if (element2 != null && element2 instanceof InteractionOperand && (element = ((InteractionOperand)element2).getOwner()) != null && element instanceof CombinedFragment) {
            return element;
        }
        return interactionConstraint;
    }

    public void updateCurrentModelTab() {
        if (this.currentModelTab != null) {
            this.currentModelTab.updatePanel();
        }
    }

    public void updateAllModelTab() {
        this.updateAllModelTab(null);
    }

    public void updateAllModelTab(EventObject eventObject) {
        for (int i2 = 0; i2 < this.modelTabs.size(); ++i2) {
            ModelTab modelTab = this.modelTabs.get(i2);
            modelTab.updatePanel(eventObject);
        }
    }

    public boolean checkInputData() {
        if (this.model == null) {
            return true;
        }
        if (this.currentModelTab != null && !this.currentModelTab.checkInputData()) {
            this.currentModelTab.update();
            return false;
        }
        return true;
    }

    public void setSelected(boolean bl) {
        if (this.currentModelTab != null) {
            this.currentModelTab.setSelected(bl);
        }
    }

    protected static String getResource(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }
}

