/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.proptab;

import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import net.astah.golf.control.GolfAction;
import net.astah.golf.control.TableCellListener;
import net.astah.golf.draw.GCheckBox;
import net.astah.golf.model.Adaptable;
import net.astah.golf.model.IExObserver;
import net.astah.golf.model.ModelPropertyEditor;
import net.astah.golf.model.Observables;
import net.astah.golf.util.Debug;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.swing.IStructuredViewerAdapter;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.ModelParameters;
import net.astah.jomt.jcontrol.ClassifierFactory;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.EditableTextComponentMouseAdapther;
import net.astah.jomt.jview.JomtComboBox;
import net.astah.jomt.jview.JomtGridBagLayout;
import net.astah.jomt.jview.JomtTextArea;
import net.astah.jomt.jview.JomtTextField;
import net.astah.jomt.jview.proptab.MyCellRenderer;
import net.astah.jomt.jview.proptab.d;
import net.astah.jomt.jview.proptab.m;
import net.astah.jomt.jview.proptab.n;
import net.astah.uml.util.AttributeTypeExpression;
import net.astah.uml2.uml.Classifiers;
import net.astah.uml2.uml.MultiplicityElements;
import net.astah.uml2.uml.TemplateableElements;
import net.astah.uml2.uml.TypeExpression;
import net.astah.uml2.uml.util.NamespaceUtil;
import net.astah.uml2.uml.util.TypeUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.VisibilityKind;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public abstract class ModelTab
extends JPanel {
    private static final long serialVersionUID = 2354269215262075612L;
    protected static final int VARIABLE = 0;
    protected static final int METHOD = 1;
    protected static final int TEMPLATE_PARAMTER_VARIABLE = 2;
    protected static final String UNSPECIFIED = "<<Unspecified>>";
    protected EObject model;
    protected a mto;
    private boolean isInitialized = false;
    private boolean isSelected = false;
    private IItemPropertySource itemPropertySource;
    private int tID = -1;
    private int currentTID = -1;
    protected boolean needCreateNewClass = false;
    private ModelTab currentModelTab;
    private static final int a = 10;
    protected m targetTypeChecker = new d();
    private n typeUtil = new n();
    protected Object previousSelectedType;
    private static final String b = PropertyManager.getProjectViewResourceBundle().getString("projectview.choose.type.label");

    public ModelTab() {
        this.mto = new a();
        this.setLayout(new BorderLayout());
    }

    public ModelTab(EObject eObject) {
        this();
        this.setModel(eObject);
    }

    public void setModel(EObject eObject) {
        this.model = eObject;
        if (eObject != null) {
            IJomtEntityStore iJomtEntityStore = ModelTab.getEntityStore();
            if (iJomtEntityStore instanceof Adaptable) {
                Adaptable adaptable = (Adaptable)((Object)iJomtEntityStore);
                this.itemPropertySource = (IItemPropertySource)adaptable.adapt(eObject, IItemPropertySource.class);
                EObject eObject2 = eObject.eContainer();
                if (eObject2 != null) {
                    adaptable.adapt(eObject2, IItemPropertySource.class);
                }
            }
            if (this.isSelected) {
                Observables.addObserver(eObject, this.mto);
            }
            this.updatePanelEditors();
        } else if (this.currentModelTab != null) {
            this.currentModelTab.update();
        }
    }

    public EObject getModel() {
        return this.model;
    }

    protected IItemPropertyDescriptor getPropertyDescriptor(String string) {
        return this.itemPropertySource.getPropertyDescriptor(this.model, string);
    }

    public void init() {
        if (this.isInitialized) {
            return;
        }
        this.initPanel();
        this.setMinimumSize(new Dimension(0, 0));
        this.isInitialized = true;
    }

    public void init(boolean bl) {
        this.init();
    }

    protected abstract void initPanel();

    public void setSelected(boolean bl) {
        this.isSelected = bl;
        if (this.model != null) {
            if (bl) {
                Observables.addObserver(this.model, this.mto);
            } else {
                Observables.deleteObserver(this.model, this.mto);
            }
        }
    }

    public boolean hasModel(Element element) {
        return this.model.equals(element);
    }

    public abstract List<ModelParameters> getModelParameters();

    public abstract String getTabName();

    public void update(Notifier notifier, Object object) {
        if (this.model == null) {
            return;
        }
        if (object instanceof Long) {
            int n2 = ((Long)object).intValue();
            if (n2 == this.tID) {
                return;
            }
            this.tID = n2;
        }
        if (!this.isInitialized) {
            return;
        }
        if (!this.isSelected) {
            return;
        }
        this.update();
        this.updatePanelEditors();
    }

    public void updatePanel() {
        this.updatePanel(null);
    }

    public void updatePanel(EventObject eventObject) {
        if (this.model == null) {
            return;
        }
        if (!this.isInitialized) {
            return;
        }
        this.update(eventObject);
        this.updatePanelEditors();
    }

    protected void updatePanelEditors() {
        this.setAllEditors(this.getComponents(), !this.isReadOnly());
    }

    protected void setAllEditors(Component[] componentArray, boolean bl) {
        if (componentArray == null) {
            return;
        }
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Component component = componentArray[i2];
            if (this.isIgnoreToSetEnabled(bl, component)) continue;
            component.setEnabled(bl);
            if (!(component instanceof Container)) continue;
            this.setAllEditors(((Container)component).getComponents(), bl);
        }
    }

    protected boolean isIgnoreToSetEnabled(boolean bl, Component component) {
        return component instanceof JLabel || !bl && component instanceof JScrollBar;
    }

    protected abstract void update();

    protected void update(EventObject eventObject) {
        if (this instanceof IStructuredViewerAdapter) {
            ((IStructuredViewerAdapter)((Object)this)).update(this.model);
        } else {
            this.update();
        }
    }

    public void remove() {
        if (this.model != null) {
            Observables.deleteObserver(this.model, this.mto);
            this.model = null;
        }
        this.mto = null;
        this.currentModelTab = null;
    }

    public void validatePanel() {
        if (!this.isInitialized) {
            return;
        }
        this.update();
    }

    protected static int getColumnIndex(DefaultTableModel defaultTableModel, String string) {
        for (int i2 = 0; i2 < defaultTableModel.getColumnCount(); ++i2) {
            if (!string.equals(defaultTableModel.getColumnName(i2))) continue;
            return i2;
        }
        return -1;
    }

    public boolean checkInputData() {
        return true;
    }

    public void updateTypeList(JComboBox jComboBox, int n2) {
        if (this.typeUtil.a()) {
            jComboBox.setRenderer(null);
            jComboBox.removeAllItems();
            jComboBox.setRenderer(null);
            this.setDefaultTypes(jComboBox, n2);
            jComboBox.doLayout();
            this.typeUtil.b();
        }
    }

    private boolean a(JComboBox jComboBox, Classifier classifier) {
        int n2 = jComboBox.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = jComboBox.getItemAt(i2);
            if (!(e2 instanceof TypeExpression)) continue;
        }
        return false;
    }

    protected void setDefaultTypes(JComboBox jComboBox, int n2) {
        if (this.targetTypeChecker.a()) {
            this.a(jComboBox);
        }
        if (n2 == 2) {
            this.setAllTypeExpressions(jComboBox, false);
            return;
        }
        if (n2 != 0) {
            // empty if block
        }
        this.setAllTypeExpressions(jComboBox, true);
    }

    private void a(JComboBox jComboBox) {
    }

    protected void setDefaultDirectionKind(JComboBox jComboBox) {
        ParameterDirectionKind[] parameterDirectionKindArray = ParameterDirectionKind.values();
        jComboBox.addItem(ParameterDirectionKind.IN_LITERAL);
        jComboBox.addItem(ParameterDirectionKind.OUT_LITERAL);
        jComboBox.addItem(ParameterDirectionKind.INOUT_LITERAL);
    }

    protected void setAllTypeExpressions(JComboBox<TypeExpression> jComboBox, boolean bl, boolean bl2) {
        IJomtEntityStore iJomtEntityStore = ModelTab.getEntityStore();
        ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
        arrayList.addAll(this.getOwnerTemplateParameters());
        arrayList.addAll(this.getAllSortedClassifiers(iJomtEntityStore));
        for (Classifier classifier : arrayList) {
            if (this.targetTypeChecker.b()) {
                if (!this.targetTypeChecker.b(classifier)) continue;
                jComboBox.addItem(new TypeExpression(classifier, null));
                continue;
            }
            if (!this.targetTypeChecker.a(classifier)) continue;
            jComboBox.addItem(new TypeExpression(classifier, null));
        }
        if (bl2) {
            jComboBox.setRenderer(new MyCellRenderer<TypeExpression>(jComboBox));
        }
    }

    protected void setAllTypeExpressions(JComboBox jComboBox, boolean bl) {
        this.setAllTypeExpressions(jComboBox, bl, true);
    }

    protected List<Classifier> getAllSortedClassifiers(IJomtEntityStore iJomtEntityStore) {
        return iJomtEntityStore.getSortedAllClassifierEntities();
    }

    protected List<Classifier> getOwnerTemplateParameters() {
        return TemplateableElements.getOwningTemplateParameters(this.model);
    }

    public void setAllTypes(JComboBox<Object> jComboBox) {
        for (Classifier classifier : this.getAllTypes()) {
            if (this.isNotTypeClassifier(classifier)) continue;
            jComboBox.addItem(classifier);
        }
        jComboBox.setRenderer(new MyCellRenderer<Object>(jComboBox));
    }

    public boolean isNotTypeClassifier(Classifier classifier) {
        return false;
    }

    protected List<Classifier> getAllTypes() {
        IJomtEntityStore iJomtEntityStore = ModelTab.getEntityStore();
        return this.getAllSortedClassifiers(iJomtEntityStore);
    }

    protected static IJomtEntityStore getEntityStore() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        return iJomtEntityStore;
    }

    protected static String getFullPathString(Namespace namespace) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Namespace namespace2 = namespace.getNamespace(); namespace2 != null && namespace2 != EntityAccessor.getProjectModel(); namespace2 = namespace2.getNamespace()) {
            stringBuilder.insert(0, namespace2.getName() + "::");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        return stringBuilder.toString();
    }

    protected void setDefaultVisibility(JComboBox<VisibilityKind> jComboBox) {
        VisibilityKind[] visibilityKindArray;
        for (VisibilityKind visibilityKind : visibilityKindArray = VisibilityKind.values()) {
            jComboBox.addItem(visibilityKind);
        }
    }

    protected void enableActionListener(boolean bl) {
        JomtComboBox.getLocalListener().setEnabled(bl);
        GCheckBox.getLocalListener().setEnabled(bl);
        JomtTextField.getActionListener().setEnabled(bl);
        JomtTextField.getFocusActionListener().setEnabled(bl);
        JomtTextArea.getFocusActionListener().setEnabled(bl);
    }

    protected static String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setInitialized(boolean bl) {
        this.isInitialized = bl;
    }

    protected void addRow(JPanel jPanel, JomtGridBagLayout jomtGridBagLayout, String string, Component component) {
        JLabel jLabel = new JLabel(ModelTab.getTitle(string));
        this.setMinimumSize(component);
        jomtGridBagLayout.addRow(jPanel, jLabel, component);
        if (component != null && string != null) {
            component.setName(string);
        }
    }

    protected void addLabelRowAndComponentRow(JPanel jPanel, JomtGridBagLayout jomtGridBagLayout, String string, Component component) {
        JLabel jLabel = new JLabel(ModelTab.getTitle(string));
        this.setMinimumSize(component);
        jomtGridBagLayout.addRow(jPanel, jLabel);
        jomtGridBagLayout.addRow(jPanel, component);
        if (component != null && string != null) {
            component.setName(string);
        }
    }

    protected JomtTextArea addDefinitionArea(JPanel jPanel) {
        JomtTextArea jomtTextArea = new JomtTextArea();
        this.setLineWrapForDefinitionArea(jomtTextArea);
        jPanel.add("Center", jomtTextArea);
        JScrollPane jScrollPane = new JScrollPane(jomtTextArea);
        jPanel.add("Center", jScrollPane);
        return jomtTextArea;
    }

    protected void setTextToDefinitionArea(JomtTextArea jomtTextArea, String string) {
        this.setLineWrapForDefinitionArea(jomtTextArea);
        this.b(jomtTextArea);
        jomtTextArea.setText(string);
        this.a(jomtTextArea);
    }

    protected void setLineWrapForDefinitionArea(JomtTextArea jomtTextArea) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.allow_line_wrap_in_base_definition");
        if (bl) {
            jomtTextArea.setLineWrap(true);
            jomtTextArea.setWrapStyleWord(true);
        } else {
            jomtTextArea.setLineWrap(false);
            jomtTextArea.setWrapStyleWord(false);
        }
    }

    private void a(JomtTextArea jomtTextArea) {
        if (this.currentTID == this.tID) {
            jomtTextArea.setCaretPosition(0);
        } else {
            this.currentTID = this.tID;
        }
        DefaultCaret defaultCaret = (DefaultCaret)jomtTextArea.getCaret();
        defaultCaret.setUpdatePolicy(2);
    }

    protected void callAction(String string) {
        GolfAction golfAction = new GolfAction(string);
        ActionEvent actionEvent = new ActionEvent(this, 0, string);
        golfAction.actionPerformed(actionEvent);
    }

    protected TypeExpression getTypeExpressionFromInput(String string) {
        return this.getTypeExpressionFromInput(string, true);
    }

    protected TypeExpression getTypeExpressionFromInput(String string, boolean bl) {
        Classifier classifier = this.getClassifierFromInput(string, bl);
        if (classifier != null) {
            String[] stringArray = NamespaceUtil.splitClassAndNamespace(string);
            return this.generateTypeExpression(stringArray[0], classifier);
        }
        return null;
    }

    protected TypeExpression generateTypeExpression(String string, Classifier classifier) {
        return Classifiers.generateTypeExpression(string, classifier);
    }

    protected Classifier getClassifierFromInput(String string, boolean bl) {
        return this.getClassifierFromInput(string, -1, bl);
    }

    protected Classifier getClassifierFromInput(String string, int n2) {
        return this.getClassifierFromInput(string, n2, true);
    }

    protected Classifier getClassifierFromInput(String string, int n2, boolean bl) {
        return this.getClassifierFromInput(string, -1, false, bl);
    }

    protected Classifier getClassifierFromInput(String string, int n2, boolean bl, boolean bl2) {
        String[] stringArray = NamespaceUtil.splitClassAndNamespace(string);
        String string2 = TypeExpression.getTypeName(stringArray[0]);
        if (Strings.isNullOrEmpty(string2)) {
            return null;
        }
        Classifier classifier = null;
        if (stringArray[1] != null && !stringArray[1].equals("")) {
            String string3 = string2 + " - " + stringArray[1];
            Classifier classifier2 = EntityAccessor.getClassifierByFullName(string3);
            if (classifier2 != null && classifier2.getOwningTemplateParameter() != null) {
                classifier2 = null;
            }
            if (classifier2 == null) {
                if (bl2) {
                    this.needCreateNewClass = this.needCreateNewClass(string2, n2, stringArray[1]);
                }
            } else {
                classifier = classifier2;
                this.previousSelectedType = classifier;
            }
        } else {
            Object object = null;
            object = bl ? TypeUtil.getExistedType(string2, this.model, true) : (bl2 || this.previousSelectedType == null ? this.getExistedType(string2) : this.previousSelectedType);
            if (object == null) {
                if (UNSPECIFIED.equals(string)) {
                    this.needCreateNewClass = false;
                } else if (bl2) {
                    this.needCreateNewClass = this.needCreateNewClass(string2, n2, stringArray[1]);
                }
            } else if (object instanceof String) {
                if (!object.equals("cancel") && object.equals(b)) {
                    this.needCreateNewClass = true;
                }
            } else if (object instanceof Classifier) {
                classifier = (Classifier)object;
            }
        }
        return classifier;
    }

    protected Object getExistedType(String string) {
        return TypeUtil.getExistedType(string, this.model);
    }

    protected boolean needCreateNewClass(String string, int n2, String string2) {
        return ClassifierFactory.doCreateNewClass(string);
    }

    List<String> getModelsByName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        Iterator<Classifier> iterator = iJomtEntityStore.getClassifierEntities(string);
        while (iterator.hasNext()) {
            Classifier classifier = iterator.next();
            arrayList.add(iJomtEntityStore.getPackageName(classifier));
        }
        return arrayList;
    }

    public void setCurrentModelTab(ModelTab modelTab) {
        this.currentModelTab = modelTab;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected void setMinimumSize(Component component) {
        if (component != null && component.getPreferredSize() != null) {
            component.setMinimumSize(new Dimension(10, component.getPreferredSize().height));
        }
    }

    protected boolean isProfessional() {
        return PropertyManager.getTarget().equals("P");
    }

    protected boolean isCommunity() {
        return PropertyManager.getTarget().equals("J");
    }

    protected boolean isSysML() {
        return PropertyManager.getTarget().equals("Y");
    }

    protected boolean isGsn() {
        return PropertyManager.getTarget().equals("G");
    }

    protected boolean isReadOnly() {
        return false;
    }

    protected void setTargetTypeChecker(m m2) {
        this.targetTypeChecker = m2;
    }

    public n getTypeUtil() {
        return this.typeUtil;
    }

    protected TypeExpression getRelatedTypeExp(JomtComboBox jomtComboBox, Classifier classifier) {
        for (int i2 = 0; i2 < jomtComboBox.getItemCount(); ++i2) {
            Object e2 = jomtComboBox.getItemAt(i2);
            if (!(e2 instanceof TypeExpression)) continue;
        }
        return null;
    }

    protected void addMouseLisenterForTable(JTable jTable) {
        EditableTextComponentMouseAdapther editableTextComponentMouseAdapther = new EditableTextComponentMouseAdapther();
        for (int i2 = 0; i2 < jTable.getColumnCount(); ++i2) {
            DefaultCellEditor defaultCellEditor;
            Component component;
            if (!(jTable.getCellEditor(0, i2) instanceof DefaultCellEditor) || !((component = (defaultCellEditor = (DefaultCellEditor)jTable.getCellEditor(0, i2)).getComponent()) instanceof JTextComponent) || !((JTextComponent)component).isEditable()) continue;
            component.addMouseListener(editableTextComponentMouseAdapther);
        }
    }

    private void b(JomtTextArea jomtTextArea) {
        if (this.currentTID != this.tID) {
            DefaultCaret defaultCaret = (DefaultCaret)jomtTextArea.getCaret();
            defaultCaret.setUpdatePolicy(1);
        }
    }

    protected <E> void setInitialValue(ModelPropertyEditor<E> modelPropertyEditor, E e2) {
        if (modelPropertyEditor != null) {
            modelPropertyEditor.setInitialValue(e2);
        }
    }

    protected void addParam(ModelParameters modelParameters, String string, ModelPropertyEditor<?> modelPropertyEditor) {
        this.addParam(modelParameters, string, modelPropertyEditor, false, false);
    }

    protected void addParam(ModelParameters modelParameters, String string, ModelPropertyEditor<?> modelPropertyEditor, boolean bl) {
        this.addParam(modelParameters, string, modelPropertyEditor, bl, false);
    }

    protected void addParam(ModelParameters modelParameters, String string, ModelPropertyEditor<?> modelPropertyEditor, boolean bl, boolean bl2) {
        if (modelPropertyEditor != null && modelPropertyEditor.isDirty()) {
            boolean bl3;
            Object obj = modelPropertyEditor.getValue();
            boolean bl4 = bl ? !UNSPECIFIED.equals(obj) && !"".equals(obj) : (bl3 = !UNSPECIFIED.equals(obj));
            if (!bl3) {
                obj = null;
            }
            if (!bl2) {
                modelParameters.put(string, obj);
            } else {
                modelParameters.put(string, obj != null ? Collections.singleton(obj) : Collections.emptyList());
            }
        }
    }

    protected void addListParam(ModelParameters modelParameters, String string, ModelPropertyEditor<?> modelPropertyEditor) {
        if (modelPropertyEditor != null && modelPropertyEditor.isDirty()) {
            BasicEList basicEList = new BasicEList();
            Object obj = modelPropertyEditor.getValue();
            if (!UNSPECIFIED.equals(obj)) {
                basicEList.add(obj);
            }
            modelParameters.put(string, basicEList);
        }
    }

    protected void addMultiplicityParam(ModelParameters modelParameters, ModelPropertyEditor<String> modelPropertyEditor) {
        if (modelPropertyEditor != null && modelPropertyEditor.isDirty()) {
            String string = modelPropertyEditor.getValue();
            modelParameters.put("UMLuml::MultiplicityElement::lowerValue", MultiplicityElements.createLowerValueSpecification(string));
            modelParameters.put("UMLuml::MultiplicityElement::upperValue", MultiplicityElements.createUpperValueSpecification(string));
        }
    }

    protected void addTypeParam(ModelParameters modelParameters, ModelPropertyEditor<Object> modelPropertyEditor) {
        if (!modelPropertyEditor.isDirty()) {
            return;
        }
        Object object = modelPropertyEditor.getValue();
        if (object instanceof String) {
            if (this.needCreateNewClass) {
                modelParameters.put("UMLuml::TypedElement::type", object);
                this.needCreateNewClass = false;
            } else {
                this.setOldReturnType(modelPropertyEditor);
            }
        } else if (object instanceof TypeExpression) {
            TypeExpression typeExpression = (TypeExpression)object;
            modelParameters.put("UMLuml::TypedElement::type", typeExpression.getType());
        } else if (object instanceof Type) {
            Type type = (Type)object;
            modelParameters.put("UMLuml::TypedElement::type", type);
        } else {
            Debug.impossible();
        }
    }

    protected void setOldReturnType(ModelPropertyEditor<Object> modelPropertyEditor) {
        TypedElement typedElement = (TypedElement)this.model;
        Type type = typedElement.getType();
        if (type != null) {
            AttributeTypeExpression attributeTypeExpression = null;
            attributeTypeExpression = new AttributeTypeExpression(type, null);
            modelPropertyEditor.setInitialValue(attributeTypeExpression);
        }
    }

    protected boolean isTablePreconditionVaiolation(List<?> list, JTable jTable, TableCellListener tableCellListener) {
        if (list.isEmpty()) {
            return true;
        }
        if (jTable.isEditing()) {
            TableCellEditor tableCellEditor = jTable.getCellEditor();
            tableCellEditor.stopCellEditing();
            return true;
        }
        return this.a(tableCellListener, jTable);
    }

    private boolean a(JTable jTable) {
        return jTable.getEditingRow() == -1;
    }

    private boolean a(TableCellListener tableCellListener, JTable jTable) {
        return tableCellListener.getRow() >= jTable.getRowCount();
    }

    public class b
    extends MouseAdapter {
        JTable a;

        public b(JTable jTable) {
            this.a = jTable;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.a != null) {
                if (this.a.getCellEditor() != null) {
                    this.a.getCellEditor().stopCellEditing();
                }
                this.a.clearSelection();
                this.a.repaint();
            }
            super.mousePressed(mouseEvent);
        }
    }

    protected class a
    implements IExObserver {
        @Override
        public void update(Notifier notifier, Object object) {
            ModelTab.this.update(notifier, object);
        }
    }
}

