/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.proptab;

import com.change_vision.jude.api.inf.ui.IPluginUserObject;
import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.astah.golf.control.BaseCommandSetting;
import net.astah.golf.control.GolfAction;
import net.astah.golf.model.EntityStoreEvent;
import net.astah.golf.model.EntityStoreListener;
import net.astah.golf.model.IEntityEditUnit;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.ResourceBundleList;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.ModelPaneManager;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelPane
extends JPanel
implements ChangeListener,
EntityStoreListener {
    private static final long serialVersionUID = 8644966727998150578L;
    private CardLayout cards = null;
    protected ModelTabGroup currentModelTabGrp;
    protected IEntityStore doc = null;
    private static JPanel a;
    protected static ModelTabGroup classTabGrp;
    private Class<? extends ModelTabGroup> modelTabClass;
    private EObject selectedModel = null;
    private Map<String, ModelTabGroup> modelTabGroupMap = new HashMap<String, ModelTabGroup>();
    private ModelPaneManager paneManager = null;
    private static final Logger b;

    public ModelPane(Project project) {
        this.cards = new CardLayout();
        this.setLayout(this.cards);
        this.doc = ModelGlobal.prjManager.getCurrentProject().doc;
        this.doc.addEntityStoreListener(this);
        a = new JPanel();
        JLabel jLabel = new JLabel(this.a("projectview.item.no_selection.label"));
        a.add("Center", jLabel);
        this.add("default", a);
        this.currentModelTabGrp = null;
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList != null) {
            try {
                String string = resourceBundleList.getString("jude.property_view_manager");
                Class<?> clazz = Class.forName(string);
                this.paneManager = (ModelPaneManager)clazz.newInstance();
            }
            catch (Exception exception) {
                b.error("error has occurred.", exception);
            }
        }
    }

    @Override
    public void entityStoreChanged(EntityStoreEvent entityStoreEvent) {
        IEntityEditUnit[] iEntityEditUnitArray = entityStoreEvent.getEntityEditUnit();
        for (int i2 = 0; i2 < iEntityEditUnitArray.length; ++i2) {
            this.update(iEntityEditUnitArray[i2]);
        }
    }

    protected void update(IEntityEditUnit iEntityEditUnit) {
        if (iEntityEditUnit.getOperation() == 2) {
            Notifier notifier = iEntityEditUnit.getEntity();
            if (this.currentModelTabGrp == null) {
                return;
            }
            EObject eObject = this.currentModelTabGrp.getModelElement();
            if (notifier == eObject && !this.a(eObject)) {
                this.a();
                this.currentModelTabGrp = null;
            }
        }
    }

    private boolean a(EObject eObject) {
        this.doc = ModelGlobal.prjManager.getCurrentProject().doc;
        List<EObject> list = this.doc.getAllEntities();
        return list.contains(eObject);
    }

    public void selectTab() {
        this.selectTab(this.selectedModel);
    }

    public void selectTab(EObject eObject) {
        this.selectTab(eObject, null);
    }

    public void selectTab(EObject eObject, EventObject eventObject) {
        Serializable serializable;
        if (eObject == null) {
            return;
        }
        if (this.selectedModel != null) {
            serializable = new GolfAction(BaseCommandSetting.getModelUpdateCommandName());
            ((GolfAction)serializable).actionPerformed(new ActionEvent(this, 0, null));
        }
        this.selectedModel = eObject;
        if (this.getWidth() == 0 && this.getHeight() == 0) {
            return;
        }
        if (!this.checkInputData()) {
            return;
        }
        serializable = this.getModelTabGroup(eObject, eventObject);
        if (serializable == null) {
            if (eObject instanceof IPluginUserObject) {
                this.a();
                this.currentModelTabGrp = null;
            }
            return;
        }
        ModelTabGroup modelTabGroup = this.currentModelTabGrp;
        if (modelTabGroup != null) {
            modelTabGroup.setSelected(false);
        }
        this.currentModelTabGrp = serializable;
        ((ModelTabGroup)serializable).setSelected(true);
        if (this.cards != null && serializable.getClass() != null) {
            this.cards.show(this, serializable.getClass().getName());
        }
    }

    protected Class<? extends ModelTabGroup> getTabClass(EObject eObject, EventObject eventObject) {
        if (this.modelTabClass != null) {
            return this.modelTabClass;
        }
        return this.paneManager.getTabClass(eObject, eventObject);
    }

    public void setModelTabClass(Class<? extends ModelTabGroup> clazz) {
        this.modelTabClass = clazz;
    }

    public ModelTabGroup getModelTabGroup(EObject eObject, EventObject eventObject) {
        Object object;
        Class<? extends ModelTabGroup> clazz = this.getTabClass(eObject, eventObject);
        Element element = null;
        if (this.currentModelTabGrp != null) {
            element = this.currentModelTabGrp.getStereotypeExtendedElement(eObject, eventObject);
        }
        if (element != null) {
            clazz = this.paneManager.getTabClass(element, eventObject);
        } else if (eObject instanceof TemplateParameter) {
            object = ((TemplateParameter)eObject).getSignature().getTemplate();
            clazz = this.paneManager.getTabClass((EObject)object, eventObject);
        } else if (eObject instanceof ParameterableElement && ((ParameterableElement)eObject).getTemplateParameter() != null) {
            object = ((ParameterableElement)eObject).getTemplateParameter().getSignature().getTemplate();
            clazz = this.paneManager.getTabClass((EObject)object, eventObject);
            eObject = ((ParameterableElement)eObject).getTemplateParameter();
        }
        if (clazz == null) {
            return null;
        }
        object = this.getModelTabPane(clazz);
        if (object != null) {
            ((ModelTabGroup)object).setModel(eObject, eventObject);
            ((ModelTabGroup)object).updateAllModelTab(eventObject);
            ((ModelTabGroup)object).showPreferredTab(eObject, eventObject);
        }
        return object;
    }

    protected ModelTabGroup getModelTabPane(Class<? extends ModelTabGroup> clazz) {
        ModelTabGroup modelTabGroup = this.modelTabGroupMap.get(clazz.getName());
        if (modelTabGroup == null) {
            try {
                modelTabGroup = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                b.error("error has occurred.", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                b.error("error has occurred.", illegalAccessException);
            }
            if (modelTabGroup != null) {
                this.add(clazz.getName(), modelTabGroup);
                this.modelTabGroupMap.put(clazz.getName(), modelTabGroup);
            }
        }
        b.trace("current tab: {}", modelTabGroup);
        return modelTabGroup;
    }

    private void a() {
        this.selectedModel = null;
        this.cards.show(this, "default");
    }

    public void remove() {
        if (this.modelTabGroupMap != null) {
            Collection<ModelTabGroup> collection = this.modelTabGroupMap.values();
            for (ModelTabGroup modelTabGroup : collection) {
                modelTabGroup.remove();
            }
        }
        this.cards = null;
        this.doc.removeEntityStoreListener(this);
        this.doc = null;
        this.currentModelTabGrp = null;
        this.modelTabGroupMap.clear();
        this.removeAll();
    }

    public ModelTabGroup getCurrentModelTabGroup() {
        return this.currentModelTabGrp;
    }

    public boolean checkInputData() {
        return this.currentModelTabGrp == null || this.currentModelTabGrp.checkInputData();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    private String a(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    static {
        b = LoggerFactory.getLogger(ModelPane.class);
    }
}

