/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.proptab;

import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.control.BaseCommandSetting;
import net.astah.golf.control.CellEditorActionListener;
import net.astah.golf.control.GolfAction;
import net.astah.golf.model.Observables;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.jmodel.ModelParameters;
import net.astah.jomt.jutil.TableUtil;
import net.astah.jomt.jview.proptab.ModelTab;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.UMLPackage;

public class ModelDependencyTab
extends ModelTab {
    private static final long serialVersionUID = 2010400720623902407L;
    protected JTable table = null;
    protected DefaultTableModel tableModel = null;
    private List<Notifier> observableModels = new ArrayList<Notifier>();
    private List<Dependency> depends = new ArrayList<Dependency>();
    private CellEditorActionListener editorListener = new CellEditorActionListener(BaseCommandSetting.getModelUpdateCommandName());

    public ModelDependencyTab() {
    }

    public ModelDependencyTab(Element element) {
        super(element);
    }

    @Override
    protected void initPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tableModel = new DefaultTableModel(){
            private static final long serialVersionUID = 4230689153670004744L;

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return this.getColumnName(n3).equals(ModelTab.getTitle("projectview.table.header.name.label"));
            }

            @Override
            public void setValueAt(Object object, int n2, int n3) {
                if (object instanceof Element) {
                    String string = LabelProviders.getName((Element)object);
                    super.setValueAt(string == null ? "" : string, n2, n3);
                } else {
                    super.setValueAt(object, n2, n3);
                }
            }
        };
        this.tableModel.addColumn(ModelDependencyTab.getTitle("projectview.table.header.name.label"));
        this.tableModel.addColumn(ModelDependencyTab.getTitle("projectview.table.header.to_end_class.label"));
        this.tableModel.addColumn(ModelDependencyTab.getTitle("projectview.table.header.depend_type.label"));
        this.tableModel.addColumn(ModelDependencyTab.getTitle("projectview.table.header.depend_class_type.label"));
        this.table = new AdjustedRowHeightTable(this.tableModel);
        this.table.setShowGrid(false);
        int n2 = TableUtil.getColumnIndex(this.table, ModelDependencyTab.getTitle("projectview.table.header.name.label"));
        this.table.getCellEditor(0, n2).addCellEditorListener(this.editorListener);
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(ModelDependencyTab.getTitle("projectview.button.delete.label"));
        jButton.addActionListener(new GolfAction("DeleteDependencyFromPropView"));
        jPanel2.add(jButton);
        this.addMouseLisenterForTable(this.table);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel.add("Center", jScrollPane);
        jPanel.add("South", jPanel2);
        this.add(jPanel);
    }

    @Override
    public void remove() {
        super.remove();
        for (Notifier notifier : this.observableModels) {
            Observables.deleteObserver(notifier, this.mto);
        }
    }

    @Override
    public void update() {
        Notifier notifier2;
        this.init();
        this.enableActionListener(false);
        if (this.model == null) {
            return;
        }
        for (Notifier notifier2 : this.observableModels) {
            Observables.deleteObserver(notifier2, this.mto);
        }
        this.observableModels.clear();
        this.depends.clear();
        ArrayList arrayList = new ArrayList();
        notifier2 = (Classifier)this.model;
        EList<Relationship> eList = notifier2.getRelationships(UMLPackage.Literals.DEPENDENCY);
        for (Relationship relationship : eList) {
            arrayList.add((Dependency)relationship);
        }
        this.tableModel.setNumRows(eList.size());
        this.a(arrayList);
        this.table.removeEditor();
        this.table.clearSelection();
        this.repaint();
        this.enableActionListener(true);
    }

    private void a(List<Dependency> list) {
        int n2 = TableUtil.getColumnIndex(this.table, ModelDependencyTab.getTitle("projectview.table.header.name.label"));
        int n3 = TableUtil.getColumnIndex(this.table, ModelDependencyTab.getTitle("projectview.table.header.to_end_class.label"));
        int n4 = TableUtil.getColumnIndex(this.table, ModelDependencyTab.getTitle("projectview.table.header.depend_type.label"));
        int n5 = TableUtil.getColumnIndex(this.table, ModelDependencyTab.getTitle("projectview.table.header.depend_class_type.label"));
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Dependency dependency = list.get(i2);
            Element element = null;
            Element element2 = null;
            Element element3 = null;
            String string = null;
            if (!dependency.getClients().isEmpty()) {
                element = (Element)dependency.getClients().get(0);
            }
            if (!dependency.getSuppliers().isEmpty()) {
                element2 = (Element)dependency.getSuppliers().get(0);
            }
            if (element == null || element2 == null) continue;
            if (element.equals(this.model)) {
                string = "Client";
                element3 = element2;
            } else if (element2.equals(this.model)) {
                string = "Supplier";
                element3 = element;
            }
            this.tableModel.setValueAt(dependency, i2, n2);
            this.tableModel.setValueAt(element3, i2, n3);
            this.tableModel.setValueAt(string, i2, n4);
            this.tableModel.setValueAt(LabelProviders.getTypeText(dependency), i2, n5);
            this.observableModels.add(dependency);
            this.observableModels.add(element);
            Observables.addObserver(dependency, this.mto);
            Observables.addObserver(element3, this.mto);
            this.depends.add(dependency);
        }
    }

    @Override
    public List<ModelParameters> getModelParameters() {
        ArrayList<ModelParameters> arrayList = new ArrayList<ModelParameters>();
        int n2 = this.table.getEditingRow();
        int n3 = this.table.getEditingColumn();
        for (int i2 = 0; i2 < this.depends.size(); ++i2) {
            Object object;
            Dependency dependency = this.depends.get(i2);
            ModelParameters modelParameters = new ModelParameters(dependency, 1, Dependency.class);
            int n4 = TableUtil.getColumnIndex(this.table, ModelDependencyTab.getTitle("projectview.table.header.name.label"));
            Object object2 = null;
            if (i2 == n2 && n4 == n3) {
                object = (DefaultCellEditor)this.table.getCellEditor(i2, n4);
                ((DefaultCellEditor)object).stopCellEditing();
            }
            if ((object2 = this.table.getValueAt(i2, n4)) == null) {
                return null;
            }
            object = object2.toString();
            modelParameters.put("UMLuml::NamedElement::name", Strings.emptyToNull((String)object));
            arrayList.add(modelParameters);
        }
        return arrayList;
    }

    @Override
    public String getTabName() {
        return ModelDependencyTab.getTitle("projectview.tab.dependency.label");
    }

    public List<Dependency> getSelectedDependencies() {
        int[] nArray = this.table.getSelectedRows();
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(this.depends.get(nArray[i2]));
        }
        return arrayList;
    }
}

