/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.proptab;

import com.google.common.collect.Iterables;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.control.GolfAction;
import net.astah.golf.draw.GCheckBox;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.ModelParameters;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.SequenceMessageEndPresentation;
import net.astah.jmodel.SequenceMessagePresentation;
import net.astah.jomt.jview.GCustomizeComboBox;
import net.astah.jomt.jview.JomtComboBox;
import net.astah.jomt.jview.JomtGridBagLayout;
import net.astah.jomt.jview.JomtTextField;
import net.astah.jomt.jview.TypeCreator;
import net.astah.jomt.jview.proptab.ModelTab;
import net.astah.jomt.jview.proptab.MyCellRenderer;
import net.astah.jomt.jview.proptab.g;
import net.astah.uml2.uml.Classifiers;
import net.astah.uml2.uml.Messages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageKind;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateableElement;

public class MessageBaseTab
extends ModelTab
implements TypeCreator {
    private static final long serialVersionUID = 1818460795610731837L;
    private JomtTextField operationName = null;
    private JomtTextField argumentName = null;
    private JLabel sourceName = null;
    private JLabel targetName = null;
    protected JomtComboBox<Object> operation = null;
    private GCheckBox asynchronous = null;
    protected JButton createButton = null;
    protected JButton propertyButton = null;
    private static final String a = "-";
    protected JomtGridBagLayout layout = new JomtGridBagLayout();

    @Override
    protected void initPanel() {
        this.enableActionListener(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(this.layout);
        this.operationName = new JomtTextField(10);
        this.operationName.setBackground(Color.white);
        this.addRow(jPanel2, this.layout, "projectview.item.name.label", this.operationName);
        this.argumentName = new JomtTextField();
        this.argumentName.setBackground(Color.white);
        this.addRow(jPanel2, this.layout, "projectview.item.argument.label", this.argumentName);
        this.operation = new GCustomizeComboBox();
        this.operation.setMaximumRowCount(20);
        this.operation.addItem("<<Unspecified>>");
        this.operation.setRenderer(new MyCellRenderer<Object>(this.operation));
        this.operation.addPopupMenuListener(new g(this));
        this.operation.setBackground(Color.white);
        this.addRow(jPanel2, this.layout, "projectview.item.operation.label", this.operation);
        this.propertyButton = new JButton(MessageBaseTab.getTitle("projectview.button.property.label"));
        this.propertyButton.setToolTipText(MessageBaseTab.getTitle("projectview.button.property_operation.tooltip"));
        this.propertyButton.addActionListener(new GolfAction("OpenMethodPropertyView"));
        this.setMinimumSize(this.propertyButton);
        this.createButton = new JButton(MessageBaseTab.getTitle("projectview.button.new.label"));
        this.createButton.setToolTipText(MessageBaseTab.getTitle("projectview.button.new_method.tooltip"));
        this.createButton.addActionListener(new GolfAction("OpenNewMethodPropertyView"));
        this.setMinimumSize(this.createButton);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 0));
        jPanel3.add(this.propertyButton);
        jPanel3.add(this.createButton);
        JLabel jLabel = new JLabel("");
        this.layout.setLayout(jLabel, 1, false);
        jPanel2.add(jLabel);
        this.layout.setLayout(jPanel3, 2, true);
        jPanel2.add(jPanel3);
        this.sourceName = new JLabel("");
        this.addRow(jPanel2, this.layout, "projectview.item.message_source.label", this.sourceName);
        this.targetName = new JLabel("");
        this.addRow(jPanel2, this.layout, "projectview.item.message_target.label", this.targetName);
        this.initExtensionFields(jPanel2);
        this.asynchronous = new GCheckBox(MessageBaseTab.getTitle("projectview.item.asynchronous.label"));
        this.layout.setLayout(this.asynchronous, 3, true);
        jPanel2.add(this.asynchronous);
        jPanel.add("North", jPanel2);
        this.add(jPanel);
        this.enableActionListener(true);
    }

    protected void initExtensionFields(JPanel jPanel) {
    }

    @Override
    public void update() {
        this.init();
        this.enableActionListener(false);
        Message message = (Message)this.getModel();
        this.updateOperationList();
        Operation operation = Messages.getOperation(message);
        this.selectOperation(operation);
        this.setInitialValue(this.argumentName, Messages.getArgumentsString(message));
        this.sourceName.setText(this.a());
        this.targetName.setText(this.b());
        if (message.getMessageSort() == MessageSort.REPLY_LITERAL) {
            this.asynchronous.setEnabled(false);
        } else {
            this.asynchronous.setEnabled(true);
        }
        this.asynchronous.setSelected(message.getMessageSort() == MessageSort.ASYNCH_CALL_LITERAL);
        this.enableActionListener(true);
    }

    private String a() {
        Message message = (Message)this.getModel();
        if (message.getMessageKind() == MessageKind.FOUND_LITERAL) {
            return a;
        }
        Property property = Messages.getSenderBaseProperty(message);
        if (property == null) {
            for (SequenceMessagePresentation sequenceMessagePresentation : Iterables.filter(Presentations.getPresentations(message), SequenceMessagePresentation.class)) {
                SequenceMessageEndPresentation sequenceMessageEndPresentation = (SequenceMessageEndPresentation)sequenceMessagePresentation.getSourcePresentation();
                if (sequenceMessageEndPresentation == null) continue;
                LabelPresentation labelPresentation = sequenceMessageEndPresentation.getFather();
                return this.a(labelPresentation);
            }
        }
        return LabelProviders.getName(property);
    }

    private String a(Presentation presentation) {
        if (presentation instanceof FramePresentation) {
            return LabelProviders.getTypeText(presentation);
        }
        if (presentation instanceof InteractionUsePresentation) {
            return LabelProviders.getName(presentation.getModel());
        }
        return a;
    }

    private String b() {
        Message message = (Message)this.getModel();
        if (message.getMessageKind() == MessageKind.LOST_LITERAL) {
            return a;
        }
        Property property = Messages.getReceiverBaseProperty(message);
        if (property == null) {
            for (SequenceMessagePresentation sequenceMessagePresentation : Iterables.filter(Presentations.getPresentations(message), SequenceMessagePresentation.class)) {
                SequenceMessageEndPresentation sequenceMessageEndPresentation = (SequenceMessageEndPresentation)sequenceMessagePresentation.getTargetPresentation();
                if (sequenceMessageEndPresentation == null) continue;
                LabelPresentation labelPresentation = sequenceMessageEndPresentation.getFather();
                return this.a(labelPresentation);
            }
        }
        return LabelProviders.getName(property);
    }

    @Override
    public List<ModelParameters> getModelParameters() {
        ArrayList<ModelParameters> arrayList = new ArrayList<ModelParameters>();
        arrayList.add(this.getMessageParameters());
        return arrayList;
    }

    public ModelParameters getMessageParameters() {
        Object object;
        Message message = (Message)this.getModel();
        ModelParameters modelParameters = new ModelParameters(this.model, 1, Message.class);
        if (this.operationName.getText().isEmpty()) {
            this.argumentName.setText("");
        }
        this.addParam(modelParameters, "UMLuml::Message::argument", this.argumentName);
        MessageSort messageSort = message.getMessageSort();
        if (this.asynchronous.isSelected()) {
            if (messageSort == MessageSort.SYNCH_CALL_LITERAL) {
                modelParameters.put("UMLuml::Message::messageSort", MessageSort.ASYNCH_CALL_LITERAL);
            }
        } else if (messageSort == MessageSort.ASYNCH_CALL_LITERAL) {
            modelParameters.put("UMLuml::Message::messageSort", MessageSort.SYNCH_CALL_LITERAL);
        }
        if (!"<<Unspecified>>".equals(object = this.operation.getSelectedItem()) && object instanceof Operation) {
            this.operationName.setText(((Operation)object).getName());
        }
        this.addParam(modelParameters, "UMLuml::NamedElement::name", this.operationName);
        this.addParam(modelParameters, "UMLuml::Message::signature", this.operation);
        return modelParameters;
    }

    @Override
    public String getTabName() {
        return MessageBaseTab.getTitle("projectview.tab.base.label");
    }

    public Operation getSelectedOperation() {
        Object object = this.operation.getSelectedItem();
        if (object instanceof Operation) {
            return (Operation)object;
        }
        return null;
    }

    public void updateOperationList() {
        Message message = (Message)this.model;
        this.operation.setEnabled(message.getMessageKind() != MessageKind.LOST_LITERAL);
        this.operation.removeAllItems();
        this.operation.addItem("<<Unspecified>>");
        Classifier classifier = Messages.getReceiverBaseClassifier(message);
        if (classifier != null) {
            ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
            arrayList.addAll(Classifiers.getAncestors(classifier));
            arrayList.add(classifier);
            for (Classifier classifier2 : arrayList) {
                EList<Operation> eList = classifier2.getOperations();
                for (Operation operation : eList) {
                    this.operation.addItem(operation);
                }
            }
            Operation operation = Messages.getOperation(message);
            if (operation != null) {
                this.operation.setSelectedItem(operation);
            }
            this.operation.doLayout();
        }
    }

    public void selectOperation(Operation operation) {
        if (operation != null) {
            this.operation.setSelectedItem(operation);
        } else {
            this.operation.setSelectedItem("<<Unspecified>>");
        }
        this.updateMessageName();
    }

    public void updateMessageName() {
        MessageSort messageSort;
        TemplateableElement templateableElement;
        Message message = (Message)this.getModel();
        Object object = this.operation.getSelectedItem();
        if (object instanceof Operation) {
            templateableElement = (Operation)object;
            this.operationName.setText(LabelProviders.getName(templateableElement));
            this.operationName.setEditable(false);
            this.operationName.setBackground(Color.LIGHT_GRAY);
            this.createButton.setEnabled(false);
            this.propertyButton.setEnabled(true);
        } else {
            this.operationName.setText(LabelProviders.getName(message));
            this.operationName.setEditable(true);
            this.operationName.setBackground(Color.WHITE);
            this.propertyButton.setEnabled(false);
            this.createButton.setEnabled(true);
        }
        templateableElement = Messages.getReceiverBaseClassifier((Message)this.getModel());
        if (templateableElement == null || templateableElement instanceof Actor) {
            this.createButton.setEnabled(false);
        }
        if ((messageSort = message.getMessageSort()) == MessageSort.CREATE_MESSAGE_LITERAL || messageSort == MessageSort.DELETE_MESSAGE_LITERAL) {
            this.asynchronous.setVisible(false);
        } else {
            this.asynchronous.setVisible(true);
        }
    }

    public String getOperationName() {
        return this.operationName.getText();
    }

    @Override
    protected void updatePanelEditors() {
        super.updatePanelEditors();
        if (this.propertyButton != null && this.getModel() != null) {
            Object object = this.operation.getSelectedItem();
            if (object instanceof Operation) {
                this.createButton.setEnabled(false);
            } else {
                this.propertyButton.setEnabled(false);
                this.createButton.setEnabled(true);
            }
            Message message = (Message)this.getModel();
            Classifier classifier = Messages.getReceiverBaseClassifier(message);
            if (classifier == null || classifier instanceof Actor) {
                this.createButton.setEnabled(false);
            }
        }
        if (((Message)this.getModel()).getMessageKind() == MessageKind.LOST_LITERAL) {
            this.operation.setEnabled(false);
        }
    }

    @Override
    public List<?> getStereotypes() {
        return null;
    }

    @Override
    public Map<?, ?> getTaggedValues() {
        return null;
    }
}

