/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.proptab;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.astah.dd.di.Diagram;
import net.astah.golf.draw.GCheckBox;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.swing.IStructuredViewerAdapter;
import net.astah.jmodel.ActivityParameterNodePresentation;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.ModelParameters;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jview.JomtGridBagLayout;
import net.astah.jomt.jview.JomtTextArea;
import net.astah.jomt.jview.JomtTextField;
import net.astah.jomt.jview.NamespaceNameFactory;
import net.astah.jomt.jview.proptab.ModelTab;
import net.astah.model.extension.Extensions;
import org.eclipse.emf.ecore.EObject;

public class DiagramBaseTab
extends ModelTab {
    private static final long serialVersionUID = 7579080787364549959L;
    protected JPanel namePanel;
    protected JomtTextField nameField;
    protected JomtGridBagLayout layout = null;
    protected JLabel path = null;
    protected GCheckBox frameVisible = null;
    protected JomtTextArea def = null;

    public DiagramBaseTab() {
    }

    public DiagramBaseTab(Diagram diagram) {
        super(diagram);
    }

    @Override
    protected void initPanel() {
        this.namePanel = new JPanel();
        this.layout = new JomtGridBagLayout();
        this.namePanel.setLayout(this.layout);
        this.path = new JLabel();
        this.addRow(this.namePanel, this.layout, "projectview.item.namespace.label", this.path);
        this.initNameField();
        this.initExtensionFields(this.namePanel);
        this.addRow(this.namePanel, this.layout, "projectview.item.definition.label", null);
        this.add("North", this.namePanel);
        this.def = this.addDefinitionArea(this);
    }

    protected void initExtensionFields(JPanel jPanel) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("jude.frame.support");
        if (!bl) {
            return;
        }
        this.initFrameVisible();
    }

    protected void initNameField() {
        this.nameField = new JomtTextField(10);
        this.addRow(this.namePanel, this.layout, "projectview.item.name.label", this.nameField);
    }

    protected void initFrameVisible() {
        this.frameVisible = new GCheckBox(DiagramBaseTab.getTitle("projectview.item.frame_visibility.label"));
        this.setMinimumSize(this.frameVisible);
        this.layout.setLayout(this.frameVisible, 3, true);
        this.namePanel.add(this.frameVisible);
    }

    @Override
    public String getTabName() {
        return DiagramBaseTab.getTitle("projectview.tab.base.label");
    }

    @Override
    public void update() {
        if (this instanceof IStructuredViewerAdapter) {
            ((IStructuredViewerAdapter)((Object)this)).update(this.model);
        } else {
            this.init();
            this.enableActionListener(false);
            UMLDiagram uMLDiagram = (UMLDiagram)this.model;
            String string = NamespaceNameFactory.getNamespace(this.model);
            this.path.setText(string);
            this.path.setToolTipText(string);
            this.path.setMinimumSize(new Dimension(100, 10));
            this.nameField.setText(uMLDiagram.getName());
            FramePresentation framePresentation = this.getFramePresentation(uMLDiagram);
            if (framePresentation != null && this.frameVisible != null) {
                this.frameVisible.setSelected(framePresentation.isVisibility());
                if (uMLDiagram instanceof UMLActivityDiagram) {
                    this.frameVisible.setEnabled(!this.a());
                }
            }
            this.setTextToDefinitionArea(this.def, Extensions.getDefinition(uMLDiagram));
            this.updateExtensionFields();
            this.enableActionListener(true);
        }
    }

    protected void updateExtensionFields() {
    }

    protected FramePresentation getFramePresentation(UMLDiagram uMLDiagram) {
        if (uMLDiagram == null || uMLDiagram.getPresentations() == null) {
            return null;
        }
        for (Presentation presentation : uMLDiagram.getPresentations()) {
            if (!(presentation instanceof FramePresentation)) continue;
            return (FramePresentation)presentation;
        }
        return null;
    }

    @Override
    protected boolean isIgnoreToSetEnabled(boolean bl, Component component) {
        if (component == this.frameVisible && this.a()) {
            return true;
        }
        return super.isIgnoreToSetEnabled(bl, component);
    }

    private boolean a() {
        for (Presentation presentation : Presentations.getPresentations(this.model)) {
            if (!(presentation instanceof ActivityParameterNodePresentation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ModelParameters> getModelParameters() {
        ArrayList<ModelParameters> arrayList = new ArrayList<ModelParameters>();
        arrayList.add(this.getDiagramParameters());
        return arrayList;
    }

    protected ModelParameters getDiagramParameters() {
        ModelParameters modelParameters = new ModelParameters(this.model, 1, UMLDiagram.class);
        this.addParam(modelParameters, "name", this.nameField);
        if (this.frameVisible != null) {
            modelParameters.put("frameVisibility", this.frameVisible.isSelected());
        }
        return modelParameters;
    }

    @Override
    public void setModel(EObject eObject) {
        super.setModel(eObject);
    }
}

