/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.proptab;

import com.google.common.base.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.ModelParameters;
import net.astah.jomt.jview.JomtComboBox;
import net.astah.jomt.jview.JomtGridBagLayout;
import net.astah.jomt.jview.JomtTextArea;
import net.astah.jomt.jview.JomtTextField;
import net.astah.jomt.jview.NamespaceNameFactory;
import net.astah.jomt.jview.proptab.ModelTab;
import net.astah.model.extension.Extensions;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.VisibilityKind;

public class ClassifierBaseTab
extends ModelTab {
    private static final long serialVersionUID = -2878627996438782538L;
    protected JLabel path = null;
    protected JomtTextField name = null;
    protected JomtComboBox<Boolean> abst = null;
    protected JomtComboBox<Object> visi = null;
    protected JomtComboBox<Boolean> isFinal = null;
    protected JomtTextArea def = null;
    protected JomtTextField alias = null;
    protected boolean isAliasSupported = RuntimeGlobal.sysProp.getBooleanWithDefault("uml.model_element.alias.support");

    @Override
    protected void initPanel() {
        VisibilityKind[] visibilityKindArray;
        this.enableActionListener(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JomtGridBagLayout jomtGridBagLayout = new JomtGridBagLayout();
        jPanel2.setLayout(jomtGridBagLayout);
        this.path = new JLabel();
        this.addRow(jPanel2, jomtGridBagLayout, "projectview.item.namespace.label", this.path);
        this.name = new JomtTextField(10);
        this.addRow(jPanel2, jomtGridBagLayout, "projectview.item.name.label", this.name);
        this.addAliasField(jPanel2, jomtGridBagLayout);
        this.visi = new JomtComboBox();
        for (VisibilityKind visibilityKind : visibilityKindArray = VisibilityKind.values()) {
            this.visi.addItem(visibilityKind);
        }
        this.visi.setBackground(Color.white);
        this.addRow(jPanel2, jomtGridBagLayout, "projectview.item.visibility.label", this.visi);
        this.abst = new JomtComboBox();
        this.abst.addItem(Boolean.TRUE);
        this.abst.addItem(Boolean.FALSE);
        this.abst.setBackground(Color.white);
        this.addRow(jPanel2, jomtGridBagLayout, "projectview.item.abstract.label", this.abst);
        this.isFinal = new JomtComboBox();
        this.isFinal.addItem(Boolean.TRUE);
        this.isFinal.addItem(Boolean.FALSE);
        this.isFinal.setBackground(Color.white);
        this.addRow(jPanel2, jomtGridBagLayout, "projectview.item.final.label", this.isFinal);
        this.addRow(jPanel2, jomtGridBagLayout, "projectview.item.definition.label", null);
        jPanel.add("North", jPanel2);
        this.def = this.addDefinitionArea(jPanel);
        this.add(jPanel);
        this.enableActionListener(true);
    }

    protected void addAliasField(JPanel jPanel, JomtGridBagLayout jomtGridBagLayout) {
        if (this.isAliasSupported) {
            this.alias = new JomtTextField();
            this.addRow(jPanel, jomtGridBagLayout, "projectview.item.alias.label", this.alias);
        }
    }

    @Override
    public void update() {
        this.init();
        this.enableActionListener(false);
        Classifier classifier = (Classifier)this.model;
        String string = NamespaceNameFactory.getNamespace(classifier);
        this.path.setText(string);
        this.path.setToolTipText(string);
        this.path.setMinimumSize(new Dimension(100, 10));
        this.setInitialValue(this.name, classifier.getName());
        this.updateAlias();
        this.setInitialValue(this.visi, classifier.getVisibility());
        this.setInitialValue(this.isFinal, classifier.isFinalSpecialization());
        this.setInitialValue(this.abst, classifier.isAbstract());
        this.setTextToDefinitionArea(this.def, Extensions.getDefinition(this.model));
        this.enableActionListener(true);
    }

    protected void updateAlias() {
    }

    @Override
    public String getTabName() {
        return ClassifierBaseTab.getTitle("projectview.tab.base.label");
    }

    @Override
    public List<ModelParameters> getModelParameters() {
        ArrayList<ModelParameters> arrayList = new ArrayList<ModelParameters>();
        arrayList.add(this.getClassifierParameters());
        return arrayList;
    }

    protected ModelParameters getClassifierParameters() {
        ModelParameters modelParameters = new ModelParameters(this.model, 1, Classifier.class);
        this.addParam(modelParameters, "UMLuml::NamedElement::name", this.name);
        this.addAliasParameters(modelParameters);
        this.addParam(modelParameters, "UMLuml::NamedElement::visibility", this.visi);
        this.addParam(modelParameters, "UMLuml::Classifier::isAbstract", this.abst);
        this.addParam(modelParameters, "UMLuml::Classifier::isFinalSpecialization", this.isFinal);
        modelParameters.put("definition", Strings.emptyToNull(this.def.getText()));
        return modelParameters;
    }

    protected void addAliasParameters(ModelParameters modelParameters) {
        if (this.isAliasSupported) {
            this.addParam(modelParameters, "a5", this.alias);
        }
    }
}

