/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryLabelProvider;
import net.astah.emf.edit.provider.swing.ContentProviderTableModel;
import net.astah.emf.edit.provider.swing.JTableBuilder;
import net.astah.emf.validation.util.ConstraintStatusSet;
import net.astah.golf.control.GolfAction;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.golf.view.swing.TableColumnProvider;
import net.astah.golf.widget.CPopupMenu;
import net.astah.golf.widget.CTable;
import net.astah.golf.widget.swing.Selections;
import net.astah.golf.widget.swing.SwingTable;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.JumpElementPopupManager;
import net.astah.provider.i;
import net.astah.provider.j;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class ValidationPanel
extends JPanel
implements MouseListener,
IValidationListener {
    private static final long serialVersionUID = 1341500025622829950L;
    protected EditingDomain domain;
    protected JButton validateButton;
    protected JTable table;
    protected CTable cTable;
    protected ContentProviderTableModel tableModel;
    protected final ConstraintStatusSet statuses = new ConstraintStatusSet();
    private JumpElementPopupManager popupManager = new JumpElementPopupManager();

    public ValidationPanel() {
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.domain = ModelGlobal.prjManager.getCurrentProject().doc.getDomain();
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory(this.domain);
        this.table = ((JTableBuilder)((JTableBuilder)((JTableBuilder)((JTableBuilder)((JTableBuilder)JTableBuilder.builder(this.domain).contentProvider(new i())).addColumn(TableColumnProvider.label(ValidationPanel.a("validationview.table.header.element.label"), new AdapterFactoryLabelProvider(adapterFactory)).setValueMapper(IConstraintStatus.class, IConstraintStatus::getTarget).setSortOrder(SortOrder.ASCENDING).setSortPriority(1).setPreferredWidth(150))).addColumn(TableColumnProvider.label(ValidationPanel.a("validationview.table.header.constraint.label")).setValueMapper(IConstraintStatus.class, iConstraintStatus -> iConstraintStatus.getConstraint().getDescriptor().getId()).setSortOrder(SortOrder.ASCENDING).setSortPriority(2).setPreferredWidth(150))).addColumn(TableColumnProvider.label(ValidationPanel.a("validationview.table.header.severity.label"), new j.a()).setValueMapper(IStatus.class, IStatus::getSeverity).setSortOrder(SortOrder.ASCENDING).setSortPriority(0).setPreferredWidth(100))).addColumn(TableColumnProvider.label(ValidationPanel.a("validationview.table.header.message.label")).setValueMapper(IStatus.class, IStatus::getMessage).setSortOrder(SortOrder.UNSORTED).setSortPriority(3).setPreferredWidth(500))).build();
        this.cTable = new SwingTable(this.table);
        this.tableModel = (ContentProviderTableModel)this.table.getModel();
        this.tableModel.setInput(this.statuses);
        this.table.setDragEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setAutoResizeMode(3);
        this.cTable.addSelectionChangedListener(selectionChangedEvent -> {
            Object object = Selections.getFirstElement(selectionChangedEvent.getSelection());
            if (object instanceof IConstraintStatus) {
                EObject eObject = ((IConstraintStatus)object).getTarget();
                JomtGlobal.viewManager.updatePropertyView(eObject);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.addMouseListener(this);
        this.add("North", this.a());
        this.add("Center", jScrollPane);
        ModelValidationService.getInstance().addValidationListener(this);
    }

    private JPanel a() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.validateButton = new JButton(ValidationPanel.a("managementview.menu.tool.validate.label"));
        this.validateButton.setToolTipText(ValidationPanel.a("managementview.menu.tool.validate.tooltip"));
        this.validateButton.addActionListener(new GolfAction("Validate"));
        jPanel.add(this.validateButton);
        return jPanel;
    }

    public void update() {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n2;
        if (mouseEvent.getClickCount() > 1) {
            return;
        }
        if (InputEventSupport.isRightMouseButton(mouseEvent) && !InputEventSupport.isMacExchangedButton(mouseEvent) && (n2 = this.table.rowAtPoint(mouseEvent.getPoint())) >= 0) {
            this.table.setRowSelectionInterval(n2, n2);
            this.a(mouseEvent);
        }
    }

    private void a(MouseEvent mouseEvent) {
        for (Object e2 : Selections.iterable(this.cTable.getSelection())) {
            EObject eObject;
            if (!(e2 instanceof IConstraintStatus) || (eObject = ((IConstraintStatus)e2).getTarget()) == null) continue;
            CPopupMenu cPopupMenu = this.popupManager.getPopupMenu(eObject);
            cPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ModelValidationService.getInstance().removeValidationListener(this);
    }

    private static String a(String string) {
        return PropertyManager.getManagementWindowResourceBundle().getString(string);
    }

    @Override
    public void validationOccurred(ValidationEvent validationEvent) {
        SwingInvoker.runLaterInEDT(() -> {
            if (this.statuses.mergeValidationResults(validationEvent) || this.removeStaleEntries()) {
                this.tableModel.refresh();
            }
        });
    }

    protected boolean removeStaleEntries() {
        return this.domain != null && this.statuses.removeIf(iConstraintStatus -> !EObjects.isAttachedTo(this.domain, iConstraintStatus.getTarget()));
    }
}

