/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.astah.emf.common.transaction.Transactions;
import net.astah.jomt.jview.MessageManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.transaction.util.ValidateEditSupport;
import org.eclipse.emf.validation.model.IConstraintStatus;

public class ValidationAlertListener
extends TransactionalEditingDomainListenerImpl {
    public static ValidationAlertListener INSTANCE = new ValidationAlertListener();
    private final Adapter a = new a();

    protected ValidationAlertListener() {
    }

    @Override
    public void transactionStarted(TransactionalEditingDomainEvent transactionalEditingDomainEvent) {
        TransactionalEditingDomain transactionalEditingDomain;
        TransactionChangeRecorder transactionChangeRecorder;
        Transaction transaction = transactionalEditingDomainEvent.getTransaction();
        if (!transaction.isReadOnly() && (transactionChangeRecorder = ((InternalTransactionalEditingDomain)(transactionalEditingDomain = transaction.getEditingDomain())).getChangeRecorder()).getValidateEditSupport() == null) {
            transactionChangeRecorder.setValidateEditSupport(new ValidateEditSupport.Default());
            EList<Adapter> eList = transactionalEditingDomain.getResourceSet().eAdapters();
            if (EcoreUtil.getAdapter(eList, a.class) == null) {
                eList.add(this.a);
            }
        }
    }

    @Override
    public void transactionClosed(TransactionalEditingDomainEvent transactionalEditingDomainEvent) {
        IStatus iStatus;
        Transaction transaction = transactionalEditingDomainEvent.getTransaction();
        if (transaction.getParent() == null && !this.suppressAlert(transaction) && (iStatus = transaction.getStatus()).getSeverity() >= 4) {
            List<IConstraintStatus> list = ValidationAlertListener.collectConstraintStatuses(iStatus);
            if (!list.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (IConstraintStatus iConstraintStatus : list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(System.lineSeparator());
                    }
                    stringBuilder.append(iConstraintStatus.getMessage());
                }
                MessageManager.displayAlertMessageDialog("", stringBuilder.toString());
            } else if (Objects.equals(EMFTransactionPlugin.getPluginId(), iStatus.getPlugin()) && iStatus.getCode() == 30) {
                MessageManager.displayAlertMessageDialog("", iStatus.getMessage());
            }
        }
    }

    protected boolean suppressAlert(Transaction transaction) {
        Object obj = transaction.getOptions().get(Transactions.OPTION_SUPPRESS_ALERT);
        return obj instanceof Boolean && (Boolean)obj != false;
    }

    public static List<IConstraintStatus> collectConstraintStatuses(IStatus iStatus) {
        return ValidationAlertListener.a(iStatus, new ArrayList<IConstraintStatus>());
    }

    private static List<IConstraintStatus> a(IStatus iStatus, List<IConstraintStatus> list) {
        if (iStatus.isMultiStatus()) {
            for (IStatus iStatus2 : iStatus.getChildren()) {
                ValidationAlertListener.a(iStatus2, list);
            }
        } else if (iStatus instanceof IConstraintStatus) {
            list.add((IConstraintStatus)iStatus);
        }
        return list;
    }

    static class a
    extends AdapterImpl {
        a() {
        }

        @Override
        public boolean isAdapterForType(Object object) {
            return object == a.class;
        }

        @Override
        public void notifyChanged(Notification notification) {
            ResourceSet resourceSet;
            TransactionalEditingDomain transactionalEditingDomain;
            if (notification.getNotifier() instanceof ResourceSet && notification.getFeatureID(ResourceSet.class) == 0 && (transactionalEditingDomain = TransactionUtil.getEditingDomain(resourceSet = (ResourceSet)notification.getNotifier())) != null) {
                switch (notification.getEventType()) {
                    case 3: {
                        this.a(transactionalEditingDomain, (Resource)notification.getNewValue());
                        break;
                    }
                    case 5: {
                        for (Object e2 : (List)notification.getNewValue()) {
                            this.a(transactionalEditingDomain, (Resource)e2);
                        }
                        break;
                    }
                }
            }
        }

        @Override
        public void setTarget(Notifier notifier) {
            ResourceSet resourceSet;
            TransactionalEditingDomain transactionalEditingDomain;
            if (notifier instanceof ResourceSet && (transactionalEditingDomain = TransactionUtil.getEditingDomain(resourceSet = (ResourceSet)notifier)) != null) {
                EList<Resource> eList = resourceSet.getResources();
                for (Resource resource : eList) {
                    this.a(transactionalEditingDomain, resource);
                }
            }
        }

        protected void a(EditingDomain editingDomain, Resource resource) {
            if (!resource.isTrackingModification() && editingDomain.isReadOnly(resource)) {
                resource.setTrackingModification(true);
            }
        }
    }
}

