/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import com.google.common.base.Strings;
import java.util.Map;
import net.astah.dd.di.Diagram;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.StructuredSelection;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLClassDiagram;
import net.astah.jmodel.UMLCommunicationDiagram;
import net.astah.jmodel.UMLCompositeStructureDiagram;
import net.astah.jmodel.UMLSequenceDiagram;
import net.astah.jmodel.UMLStateChartDiagram;
import net.astah.jmodel.UMLUseCaseDiagram;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.CJomtTree;
import net.astah.jomt.jview.JomtTreeNode;
import net.astah.jomt.jview.ManagementView;
import net.astah.jomt.jview.ProjectView;
import net.astah.jomt.jview.W;
import net.astah.jomt.jview.o;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.uml2.uml.Properties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import proguard.annotation.Keep;
import proguard.annotation.KeepImplementations;

@Keep
@KeepImplementations
public class TreeUtil
implements o {
    public static final String STRUCTURE_VIEW = "structure view";
    public static final String HIERARCHY_VIEW = "hierarchy_view";

    public JomtTreeNode createTreeNode(Map map, EObject eObject) {
        UserObject userObject = new UserObject(eObject);
        JomtTreeNode jomtTreeNode = this.createNewNode(userObject);
        if (eObject instanceof Diagram) {
            this.setDiagramNodeType(jomtTreeNode, ((Diagram)eObject).getClass());
            return jomtTreeNode;
        }
        W w2 = new W(this, jomtTreeNode);
        JomtTreeNode jomtTreeNode2 = (JomtTreeNode)w2.doSwitch(eObject);
        return jomtTreeNode2;
    }

    protected JomtTreeNode createNewNode(UserObject userObject) {
        return new JomtTreeNode(userObject);
    }

    public void setDiagramNodeType(JomtTreeNode jomtTreeNode, Class<? extends Diagram> clazz) {
        if (UMLUseCaseDiagram.class.isAssignableFrom(clazz)) {
            jomtTreeNode.setModelType("usecase diagram");
        } else if (UMLClassDiagram.class.isAssignableFrom(clazz)) {
            jomtTreeNode.setModelType("class diagram");
        } else if (UMLStateChartDiagram.class.isAssignableFrom(clazz)) {
            jomtTreeNode.setModelType("statechart diagram");
        } else if (UMLActivityDiagram.class.isAssignableFrom(clazz)) {
            jomtTreeNode.setModelType("activity diagram");
        } else if (UMLSequenceDiagram.class.isAssignableFrom(clazz)) {
            jomtTreeNode.setModelType("sequence diagram");
        } else if (UMLCommunicationDiagram.class.isAssignableFrom(clazz)) {
            jomtTreeNode.setModelType("collaboration diagram");
        } else if (UMLCompositeStructureDiagram.class.isAssignableFrom(clazz)) {
            jomtTreeNode.setModelType("compositestructure diagram");
        } else if (MMDiagram.class.isAssignableFrom(clazz)) {
            jomtTreeNode.setModelType("mindmap");
        }
    }

    public boolean canBeShownOnTree(EObject eObject) {
        return eObject != EntityAccessor.getProjectModel();
    }

    public Element getAssociationEndTreeParent(Property property) {
        Property property2 = Properties.getOppositeProperty(property);
        return property2.getType();
    }

    public boolean isShowAssociatinEndBySysProp(Property property) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.show_role_icons_on_the_tree");
        if (!bl) {
            return false;
        }
        boolean bl2 = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.only_show_navigatable_associationend_on_the_tree");
        return !bl2 || property.isNavigable();
    }

    @Override
    public String getClassifierName(Classifier classifier) {
        return this.getClassifierNameForTree(classifier);
    }

    public String getClassifierNameForTree(Classifier classifier) {
        return classifier.getName();
    }

    public String getPropText(Property property) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Strings.nullToEmpty(property.getName()));
        stringBuilder.append(":");
        stringBuilder.append(this.getPropTypeText(property));
        return stringBuilder.toString();
    }

    public Object getPropTypeText(Property property) {
        String string = "";
        if (property.getType() != null) {
            string = property.getType().getName();
        }
        return string;
    }

    public String getPropText(UserObject userObject, Property property) {
        return this.getPropText(property);
    }

    public static boolean isHide() {
        ManagementView managementView = JomtGlobal.viewManager.getManagementView();
        double d2 = managementView.getBaseSplitPane().getDividerLocation();
        return d2 < 10.0;
    }

    public static void showTreeNodeInHierarchyView(Object object, boolean bl) {
        TreeUtil.a(HIERARCHY_VIEW, object, bl);
    }

    public static void showTreeNodeInStructureView(Object object, boolean bl) {
        TreeUtil.a(STRUCTURE_VIEW, object, bl);
    }

    private static void a(String string, Object object, boolean bl) {
        ProjectView projectView = JomtGlobal.viewManager.getProjectView();
        if (projectView != null && object != null) {
            CJomtTree cJomtTree = null;
            if (string.equals(STRUCTURE_VIEW)) {
                projectView.setSelectedUIViewTab(projectView.getStructureView());
                cJomtTree = projectView.getStructureTree();
            } else if (string.equals(HIERARCHY_VIEW)) {
                projectView.setSelectedUIViewTab(projectView.getHierarchyView());
                cJomtTree = projectView.getHierarchyTree();
            }
            if (TreeUtil.isHide() && bl) {
                ManagementView managementView = JomtGlobal.viewManager.getManagementView();
                managementView.getBaseSplitPane().setDividerLocation(0.32);
            }
            if (cJomtTree != null) {
                cJomtTree.setSelection(new StructuredSelection(object));
                cJomtTree.showInTree(object);
            }
        }
    }
}

