/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.JomtTreeNode;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.ProjectTreeModel;
import net.astah.jomt.jviewElement.JomtViewElement;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeChooserDialog
extends KeyDialog
implements ActionListener {
    public static final String NAME_OF_OK_BUTTON = "tree_chooser_dialog.ok_button";
    public static final String NAME_OF_CANCEL_BUTTON = "tree_chooser_dialog.cancel_button";
    private static final long serialVersionUID = -6818933205395498533L;
    protected EObject selectedModel;
    protected JTree tree;
    protected TreeModel model;
    protected static TreePath historyPath;
    private static final Logger a;

    public TreeChooserDialog(Frame frame) {
        super(frame, true);
    }

    public TreeChooserDialog(Frame frame, JTree jTree, TreeModel treeModel, String string) {
        super(frame, true);
        this.tree = jTree;
        this.model = treeModel;
        this.initDialog();
        this.setTitle(string);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected void initDialog() {
        JPanel jPanel = this.createBasePanel();
        JPanel jPanel2 = this.b();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
    }

    protected JPanel createBasePanel() {
        JScrollPane jScrollPane = this.createPrjTreePanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JScrollPane createPrjTreePanel() {
        this.tree.setModel(this.model);
        this.tree.setAutoscrolls(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setBackground(((SwingColor)JomtViewElement.getBackgroundColor()).getComponent());
        this.tree.getSelectionModel().setSelectionMode(this.getTreeSelection());
        if (historyPath != null) {
            this.updateSelection(historyPath);
        }
        return new JScrollPane(this.tree);
    }

    protected int getTreeSelection() {
        return 1;
    }

    public static JomtTreeNode getRootNode() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        JomtTreeNode jomtTreeNode = TreeChooserDialog.a();
        jomtTreeNode.setModelType("package");
        jomtTreeNode.setUserObject(new UserObject(EntityAccessor.getProjectModel(iJomtEntityStore)));
        ProjectTreeModel.updateProjectName(iJomtEntityStore.getName());
        return jomtTreeNode;
    }

    private static JomtTreeNode a() {
        String string = PropertyManager.getJudeResourceBundle().getString("jude.project_view_tree_node");
        JomtTreeNode jomtTreeNode = null;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            if (constructor != null) {
                jomtTreeNode = (JomtTreeNode)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            a.error("error has occurred.", exception);
        }
        return jomtTreeNode;
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(this.a("projectview.button.ok.label"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(this);
        jButton.setName(NAME_OF_OK_BUTTON);
        JButton jButton2 = new JButton(this.a("projectview.button.cancel.label"));
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        jButton2.setName(NAME_OF_CANCEL_BUTTON);
        if (PropertyManager.isMacOS()) {
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        return jPanel;
    }

    private String a(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            if (!this.doClickOk()) {
                return;
            }
        } else if (actionEvent.getActionCommand().equals("CANCEL")) {
            // empty if block
        }
        this.dispose();
    }

    protected boolean doClickOk() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            this.dispose();
            return false;
        }
        this.selectedModel = (EObject)treePath.getLastPathComponent();
        historyPath = treePath;
        return true;
    }

    public EObject getSelectedModel() {
        return this.selectedModel;
    }

    public static TreePath getHistoryPath() {
        return historyPath;
    }

    public static void clearHistory() {
        historyPath = null;
    }

    public void setSelectPath(TreePath treePath) {
        this.updateSelection(treePath);
    }

    public void updateSelection(TreePath treePath) {
        this.tree.setSelectionPath(null);
        this.tree.setSelectionPath(treePath);
        this.tree.collapsePath(treePath);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.dispose();
        }
    }

    static {
        a = LoggerFactory.getLogger(TreeChooserDialog.class);
    }
}

