/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class SwingCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = 3465017316645540684L;
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;

    public SwingCellEditor(final JTextField jTextField) {
        this.editorComponent = jTextField;
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(){
            private static final long serialVersionUID = 1088073671416321064L;

            @Override
            public void setValue(Object object) {
                jTextField.setText(object != null ? object.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return jTextField.getText();
            }
        };
        jTextField.addActionListener(this.delegate);
    }

    public SwingCellEditor(final JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        this.delegate = new EditorDelegate(){
            private static final long serialVersionUID = 2153855042307793948L;

            @Override
            public void setValue(Object object) {
                boolean bl = false;
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                } else if (object instanceof String) {
                    bl = object.equals("true");
                }
                jCheckBox.setSelected(bl);
            }

            @Override
            public Object getCellEditorValue() {
                return jCheckBox.isSelected();
            }
        };
        jCheckBox.addActionListener(this.delegate);
    }

    public SwingCellEditor(final JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.delegate = new EditorDelegate(){
            private static final long serialVersionUID = -2648339951705722523L;

            @Override
            public void setValue(Object object) {
                jComboBox.setSelectedItem(object);
            }

            @Override
            public Object getCellEditorValue() {
                return jComboBox.getSelectedItem();
            }

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    return mouseEvent.getID() != 506;
                }
                if (eventObject instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)eventObject;
                    return jComboBox.selectWithKeyChar(keyEvent.getKeyChar());
                }
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                if (jComboBox.isEditable()) {
                    jComboBox.actionPerformed(new ActionEvent(SwingCellEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }
        };
        jComboBox.addActionListener(this.delegate);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int n2) {
        this.clickCountToStart = n2;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return this.delegate.isCellEditable(eventObject);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n2, false);
        this.delegate.setValue(string);
        return this.editorComponent;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        private static final long serialVersionUID = -8526912547743732157L;
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= SwingCellEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            SwingCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            SwingCellEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            SwingCellEditor.this.stopCellEditing();
        }
    }
}

