/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.util.Vector;
import net.astah.golf.util.RuntimeGlobal;

public class StringMatcher {
    protected String fPattern;
    protected int fLength;
    protected boolean fIgnoreWildCards;
    protected boolean fIgnoreCase;
    protected boolean fHasLeadingStar;
    protected boolean fHasTrailingStar;
    protected String[] fSegments;
    protected int fBound = 0;
    protected static final char fSingleWildCard = '\u0000';

    public StringMatcher(String string, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.fIgnoreCase = bl;
        this.fIgnoreWildCards = bl2;
        this.fPattern = string;
        this.fLength = string.length();
        if (this.fIgnoreWildCards) {
            this.a();
        } else {
            this.b();
        }
    }

    public Position find(String string, int n2, int n3) {
        int n4;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n5 = string.length();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > n5) {
            n3 = n5;
        }
        if (n3 < 0 || n2 >= n3) {
            return null;
        }
        if (this.fLength == 0) {
            return new Position(n2, n2);
        }
        if (this.fIgnoreWildCards) {
            int n6 = this.posIn(string, n2, n3);
            if (n6 < 0) {
                return null;
            }
            return new Position(n6, n6 + this.fLength);
        }
        int n7 = this.fSegments.length;
        if (n7 == 0) {
            return new Position(n2, n3);
        }
        int n8 = n2;
        int n9 = -1;
        for (n4 = 0; n4 < n7 && n8 < n3; ++n4) {
            String string2 = this.fSegments[n4];
            int n10 = this.regExpPosIn(string, n8, n3, string2);
            if (n10 < 0) {
                return null;
            }
            if (n4 == 0) {
                n9 = n10;
            }
            n8 = n10 + string2.length();
        }
        if (n4 < n7) {
            return null;
        }
        return new Position(n9, n8);
    }

    public boolean match(String string) {
        if (string == null) {
            return false;
        }
        return this.match(string, 0, string.length());
    }

    public boolean match(String string, int n2, int n3) {
        int n4;
        if (null == string) {
            throw new IllegalArgumentException();
        }
        if (n2 > n3) {
            return false;
        }
        if (this.fIgnoreWildCards) {
            return n3 - n2 == this.fLength && this.fPattern.regionMatches(this.fIgnoreCase, 0, string, n2, this.fLength);
        }
        int n5 = this.fSegments.length;
        if (n5 == 0 && (this.fHasLeadingStar || this.fHasTrailingStar)) {
            return true;
        }
        if (n2 == n3) {
            return this.fLength == 0;
        }
        if (this.fLength == 0) {
            return n2 == n3;
        }
        int n6 = string.length();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > n6) {
            n3 = n6;
        }
        int n7 = n2;
        int n8 = n3 - this.fBound;
        if (n8 < 0) {
            return false;
        }
        int n9 = 0;
        String string2 = this.fSegments[n9];
        int n10 = string2.length();
        if (!this.fHasLeadingStar) {
            if (!this.regExpRegionMatches(string, n2, string2, 0, n10)) {
                return false;
            }
            ++n9;
            n7 += n10;
        }
        if (this.fSegments.length == 1 && !this.fHasLeadingStar && !this.fHasTrailingStar) {
            return n7 == n3;
        }
        while (n9 < n5) {
            string2 = this.fSegments[n9];
            int n11 = string2.indexOf(0);
            if (n11 < 0 ? (n4 = this.textPosIn(string, n7, n3, string2)) < 0 : (n4 = this.regExpPosIn(string, n7, n3, string2)) < 0) {
                return false;
            }
            n7 = n4 + string2.length();
            ++n9;
        }
        if (!this.fHasTrailingStar && n7 != n3) {
            n4 = string2.length();
            return this.regExpRegionMatches(string, n3 - n4, string2, 0, n4);
        }
        return n9 == n5;
    }

    private void a() {
        this.fSegments = new String[1];
        this.fSegments[0] = this.fPattern;
        this.fBound = this.fLength;
    }

    private void b() {
        if (this.fPattern.startsWith("*")) {
            this.fHasLeadingStar = true;
        }
        if (this.fPattern.endsWith("*") && this.fLength > 1 && this.fPattern.charAt(this.fLength - 2) != '\\') {
            this.fHasTrailingStar = true;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        block5: while (n2 < this.fLength) {
            char c2 = this.fPattern.charAt(n2++);
            switch (c2) {
                case '\\': {
                    char c3;
                    if (n2 >= this.fLength) {
                        stringBuffer.append(c2);
                        break;
                    }
                    if ((c3 = this.fPattern.charAt(n2++)) == '*' || c3 == '?' || c3 == '\\') {
                        stringBuffer.append(c3);
                        break;
                    }
                    stringBuffer.append(c2);
                    stringBuffer.append(c3);
                    break;
                }
                case '*': {
                    if (stringBuffer.length() <= 0) continue block5;
                    vector.addElement(stringBuffer.toString());
                    this.fBound += stringBuffer.length();
                    stringBuffer.setLength(0);
                    break;
                }
                case '?': {
                    stringBuffer.append('\u0000');
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
            this.fBound += stringBuffer.length();
        }
        this.fSegments = new String[vector.size()];
        vector.copyInto(this.fSegments);
    }

    protected int posIn(String string, int n2, int n3) {
        int n4 = n3 - this.fLength;
        if (!this.fIgnoreCase) {
            int n5 = string.indexOf(this.fPattern, n2);
            if (n5 == -1 || n5 > n4) {
                return -1;
            }
            return n5;
        }
        for (int i2 = n2; i2 <= n4; ++i2) {
            if (!string.regionMatches(true, i2, this.fPattern, 0, this.fLength)) continue;
            return i2;
        }
        return -1;
    }

    protected int regExpPosIn(String string, int n2, int n3, String string2) {
        int n4 = string2.length();
        int n5 = n3 - n4;
        for (int i2 = n2; i2 <= n5; ++i2) {
            if (!this.regExpRegionMatches(string, i2, string2, 0, n4)) continue;
            return i2;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String string, int n2, String string2, int n3, int n4) {
        while (n4-- > 0) {
            char c2 = string.charAt(n2++);
            char c3 = string2.charAt(n3++);
            if (!this.fIgnoreWildCards && c3 == '\u0000' || c3 == c2 || this.fIgnoreCase && (Character.toUpperCase(c2) == Character.toUpperCase(c3) || Character.toLowerCase(c2) == Character.toLowerCase(c3))) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String string, int n2, int n3, String string2) {
        int n4 = string2.length();
        int n5 = n3 - n4;
        if (!this.fIgnoreCase) {
            int n6 = string.indexOf(string2, n2);
            if (n6 == -1 || n6 > n5) {
                return -1;
            }
            return n6;
        }
        for (int i2 = n2; i2 <= n5; ++i2) {
            if (!string.regionMatches(true, i2, string2, 0, n4)) continue;
            return i2;
        }
        return -1;
    }

    public static boolean compare(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        if (!string2.equals(string4) && StringMatcher.a(string2)) {
            StringMatcher stringMatcher = new StringMatcher(StringMatcher.b(string2), false, false);
            return stringMatcher.match(string);
        }
        StringMatcher stringMatcher = new StringMatcher(string4 + '*', true, false);
        return stringMatcher.match(string3);
    }

    public static boolean compareInDiagram(String string, String string2) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("ui.search_toolbar.distinguish_upper_lower");
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        if (bl) {
            if (!string2.equals(string4) && StringMatcher.a(string2)) {
                StringMatcher stringMatcher = new StringMatcher('*' + StringMatcher.b(string2), false, false);
                return stringMatcher.match(string);
            }
            StringMatcher stringMatcher = new StringMatcher('*' + string2 + '*', false, false);
            return stringMatcher.match(string);
        }
        StringMatcher stringMatcher = new StringMatcher('*' + string4 + '*', true, false);
        return stringMatcher.match(string3);
    }

    private static boolean a(String string) {
        String string2;
        String string3;
        return string != null && string.length() > 0 && !(string3 = string.substring(0, 1)).equals(string2 = string3.toLowerCase());
    }

    private static String b(String string) {
        String string2 = "";
        int n2 = string.length();
        if (n2 > 1) {
            String string3;
            boolean bl = true;
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                string3 = string.substring(i2, i2 + 1);
                String string4 = string3.toLowerCase();
                if (i2 != 0 && bl && !string3.equals(string4)) {
                    string2 = string2 + "*";
                }
                string2 = "*".equals(string3) || "?".equals(string3) ? string2 + string3 : string2 + string3;
                bl = !string3.equals(string4);
            }
            String string5 = string.substring(n2 - 1, n2);
            string3 = string5.toLowerCase();
            if (bl && !string5.equals(string3)) {
                string2 = string2 + "*";
            }
            string2 = string2 + string5 + "*";
        } else {
            string2 = string2 + string + "*";
        }
        return string2;
    }

    public static class Position {
        int a;
        int b;

        public Position(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }

        public int getStart() {
            return this.a;
        }

        public int getEnd() {
            return this.b;
        }
    }
}

