/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.PropertyTableModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Property;

public class PropertyChooseDialog
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = 8133737033732043009L;
    private JButton okButton;
    private JButton cancelButton;
    private JButton selAllButton;
    private JButton unselAllButton;
    private PropertyTableModel tableModel = new PropertyTableModel();
    private List<Property> result = new ArrayList<Property>();
    private int resultState = 3;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CLOSE = 3;

    public PropertyChooseDialog(JFrame jFrame, String string) {
        super((Frame)jFrame, true);
        this.setTitle(string);
    }

    public PropertyTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableData(Object[][] objectArray) {
        this.tableModel.setData(objectArray);
    }

    public void showDialog() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTable jTable = new JTable();
        jTable.setModel(this.tableModel);
        jTable.getColumn(PropertyTableModel.NAME_HEADER).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 4601863532307837564L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
                this.setText(this.a(object));
                return this;
            }

            private String a(Object object) {
                String string = null;
                if (object instanceof EObject) {
                    string = LabelProviders.getName((EObject)object);
                }
                return string == null ? "" : string;
            }
        });
        JPanel jPanel2 = new JPanel();
        this.okButton = new JButton(PropertyChooseDialog.a("projectview.button.ok.label"));
        this.cancelButton = new JButton(PropertyChooseDialog.a("projectview.button.cancel.label"));
        this.selAllButton = new JButton(PropertyChooseDialog.a("projectview.button.select_all.label"));
        this.unselAllButton = new JButton(PropertyChooseDialog.a("projectview.button.deselect_all.label"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.selAllButton.addActionListener(this);
        this.unselAllButton.addActionListener(this);
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("CANCEL");
        this.selAllButton.setActionCommand("SELECT ALL");
        this.unselAllButton.setActionCommand("UNSELECT ALL");
        if (PropertyManager.isMacOS()) {
            jPanel2.add(this.unselAllButton);
            jPanel2.add(this.selAllButton);
            jPanel2.add(this.cancelButton);
            jPanel2.add(this.okButton);
        } else {
            jPanel2.add(this.selAllButton);
            jPanel2.add(this.unselAllButton);
            jPanel2.add(this.okButton);
            jPanel2.add(this.cancelButton);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.add("Center", jScrollPane);
        jPanel.add("South", jPanel2);
        Container container = this.getContentPane();
        container.add(jPanel);
        jTable.removeEditor();
        jTable.clearSelection();
        jTable.repaint();
        this.pack();
        this.a(this);
        this.setVisible(true);
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.c();
            this.setVisible(false);
            this.resultState = 1;
        } else if (actionEvent.getActionCommand().equals("CANCEL")) {
            this.setVisible(false);
            this.resultState = 2;
        } else if (actionEvent.getActionCommand().equals("SELECT ALL")) {
            this.a();
        } else if (actionEvent.getActionCommand().equals("UNSELECT ALL")) {
            this.b();
        }
    }

    private void a() {
        int n2 = this.tableModel.getColumnIndex(PropertyTableModel.SHOW_HEADER);
        for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
            this.tableModel.setValueAt(Boolean.TRUE, i2, n2);
        }
    }

    private void b() {
        int n2 = this.tableModel.getColumnIndex(PropertyTableModel.SHOW_HEADER);
        for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
            this.tableModel.setValueAt(Boolean.FALSE, i2, n2);
        }
    }

    private void c() {
        int n2 = this.tableModel.getColumnIndex(PropertyTableModel.SHOW_HEADER);
        int n3 = this.tableModel.getColumnIndex(PropertyTableModel.NAME_HEADER);
        for (int i2 = 0; i2 < this.tableModel.getRowCount(); ++i2) {
            if (!((Boolean)this.tableModel.getValueAt(i2, n2)).booleanValue()) continue;
            this.result.add((Property)this.tableModel.getValueAt(i2, n3));
        }
    }

    public int getResultState() {
        return this.resultState;
    }

    public List<Property> getSelectedResult() {
        return this.result;
    }

    public void setPropertyTableColumn(String[] stringArray) {
        this.tableModel.setColumns(stringArray);
    }

    private static String a(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    private void a(Window window) {
        Rectangle rectangle = window.getGraphicsConfiguration().getBounds();
        window.setLocation(rectangle.x + rectangle.width / 2 - window.getSize().width / 2, rectangle.y + rectangle.height / 2 - window.getSize().height / 2);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.setVisible(false);
            this.resultState = 2;
        }
    }
}

