/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import net.astah.dd.di.Diagram;
import net.astah.golf.model.EntityStoreEvent;
import net.astah.golf.model.EntityStoreListener;
import net.astah.golf.model.IEntityEditUnit;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.widget.swing.NavigableTreeModel;
import net.astah.jmodel.Project;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.ObjectFactory;
import net.astah.jomt.jview.JomtTreeNode;
import net.astah.jomt.jview.TreeUtil;
import org.eclipse.emf.ecore.EObject;

public abstract class ProjectTreeModel
extends DefaultTreeModel
implements PropertyChangeListener,
EntityStoreListener,
NavigableTreeModel {
    private static final long serialVersionUID = -9208613811972222621L;
    protected Map<EObject, Object> table = new HashMap<EObject, Object>();

    public ProjectTreeModel(TreeNode treeNode) {
        super(treeNode);
        UserObject userObject;
        if (treeNode instanceof JomtTreeNode && (userObject = (UserObject)((JomtTreeNode)treeNode).getUserObject()) != null && userObject.getModel() != null) {
            this.table.put(userObject.getModel(), treeNode);
        }
    }

    public void initTreeModel(IEntityStore iEntityStore) {
    }

    @Override
    public void entityStoreChanged(EntityStoreEvent entityStoreEvent) {
        if (entityStoreEvent.getEditType() == 2) {
            this.updateProjectPackageName(entityStoreEvent);
        }
        IEntityEditUnit[] iEntityEditUnitArray = entityStoreEvent.getEntityEditUnit();
        this.update(iEntityEditUnitArray);
    }

    protected abstract void update(IEntityEditUnit[] var1);

    protected JomtTreeNode createTreeNode(EObject eObject) {
        return this.getTreeUtil().createTreeNode(this.table, eObject);
    }

    protected void setDiagramNodeType(JomtTreeNode jomtTreeNode, Class<? extends Diagram> clazz) {
        this.getTreeUtil().setDiagramNodeType(jomtTreeNode, clazz);
    }

    protected TreeUtil getTreeUtil() {
        return (TreeUtil)ObjectFactory.getSpecialClassFromProperties("jude.TreeUtil");
    }

    protected void updateProjectPackageName(EntityStoreEvent entityStoreEvent) {
        IEntityStore iEntityStore = (IEntityStore)entityStoreEvent.getSource();
        this.updateProjectPackageName(iEntityStore.getName());
    }

    protected void updateProjectPackageName(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root;
        ProjectTreeModel.updateProjectName(string);
        this.nodeChanged(defaultMutableTreeNode);
    }

    public static void updateProjectName(String string) {
        String string2 = string.toLowerCase();
        String string3 = "";
        string3 = PropertyManager.getTarget().equals("T") ? Project.FILE_EXTENTION_JUTH : (string2.endsWith(Project.FILE_EXTENTION) ? Project.FILE_EXTENTION : (string2.endsWith(Project.FILE_EXTENTION_JUTH) ? Project.FILE_EXTENTION_JUTH : Project.FILE_EXTENTION_ASTA));
        if (string2.endsWith(string3)) {
            File file = new File(string);
            String string4 = file.getName();
            String string5 = string4.toLowerCase();
            string = string4.substring(0, string5.lastIndexOf(string3));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("documentName")) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.updateProjectPackageName(string);
        }
    }

    public void clear() {
        this.table.clear();
        this.removeChildren((DefaultMutableTreeNode)this.root);
        ((DefaultMutableTreeNode)this.root).setUserObject(null);
        this.root = null;
    }

    public void removeChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n2 = defaultMutableTreeNode.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i2);
            this.removeChildren(defaultMutableTreeNode2);
            defaultMutableTreeNode2.setUserObject(null);
        }
        defaultMutableTreeNode.removeAllChildren();
    }

    public JomtTreeNode getTreeNode(EObject eObject) {
        Object object = this.table.get(eObject);
        if (object instanceof JomtTreeNode) {
            return (JomtTreeNode)object;
        }
        return null;
    }

    public JomtTreeNode getDiagramNode(UMLDiagram uMLDiagram) {
        return (JomtTreeNode)this.table.get(uMLDiagram);
    }

    @Override
    @Deprecated
    public Object getParent(Object object) {
        if (object instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)object;
            return treeNode.getParent();
        }
        return null;
    }

    @Override
    @Deprecated
    public Object[] getPathToRoot(Object object) {
        if (object instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)object;
            return this.getPathToRoot(treeNode);
        }
        return null;
    }
}

