/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import net.astah.jmodel.ClassifierPresentationUtil;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.MMTopicPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.TextPresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UserObject;
import net.astah.jmodel.alias.AliasAccessor;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.ObjectFactory;
import net.astah.jomt.jview.IconResource;
import net.astah.jomt.jview.TreeUtil;
import net.astah.model.extension.Hyperlink;
import net.astah.model.extension.Hyperlinks;
import net.astah.uml2.uml.TemplateBindings;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.UseCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 6780671471595921743L;
    private boolean isIDVisible = true;
    protected JPanel panel;
    private JLabel lock = new JLabel();
    protected JLabel hyperlink = new JLabel();
    protected JLabel usecaselevel = new JLabel();
    private String[] otherLockedmodels = new String[0];
    private String[] selfLockedmodels = new String[0];
    private TreeNode dropTargetNode = null;
    private boolean isTargetNode;
    private static final Logger a = LoggerFactory.getLogger(ProjectTreeCellRenderer.class);

    public ProjectTreeCellRenderer() {
        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
        this.panel = new JPanel(flowLayout);
        this.panel.setOpaque(false);
        this.setOpaque(false);
        this.hyperlink.setOpaque(false);
        this.hyperlink.setForeground(Color.GRAY);
        this.lock.setOpaque(false);
        this.lock.setForeground(Color.GRAY);
        this.usecaselevel.setOpaque(false);
        this.usecaselevel.setForeground(Color.GRAY);
        this.panel.add(this);
        this.panel.add(this.hyperlink);
        this.panel.add(this.lock);
        this.panel.add(this.usecaselevel);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        Object object2;
        this.isTargetNode = object.equals(this.dropTargetNode);
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n2, bl4);
        this.lock.setIcon(null);
        this.lock.setText("");
        this.hyperlink.setIcon(null);
        this.usecaselevel.setIcon(null);
        this.setEnabled(jTree.isEnabled());
        this.setText(string);
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) != null && object2 instanceof UserObject) {
            EModelElement eModelElement;
            EObject eObject = ((UserObject)object2).getModel();
            if (eObject == null) {
                eModelElement = ((UserObject)object2).getPresentation();
                if (eModelElement instanceof MMTopicPresentation) {
                    this.b(eModelElement);
                } else if (eModelElement instanceof TextPresentation) {
                    this.b(eModelElement);
                } else {
                    eObject = eModelElement.getModel();
                }
            }
            if (eObject != null) {
                if (this.needHyperlinkIcon((UserObject)object2)) {
                    this.b(eObject);
                }
                if (!(eObject instanceof UseCase) && eObject instanceof Classifier) {
                    this.setTextForClassifier((Classifier)eObject);
                }
            }
            if (eObject instanceof Property) {
                eModelElement = (Property)eObject;
                if (eModelElement.getType() != null) {
                    this.setText(this.getTreeUtil().getPropText((UserObject)object2, (Property)eModelElement));
                }
            } else if (eObject instanceof ProfileApplication) {
                eModelElement = ((ProfileApplication)eObject).getAppliedProfile();
                String string2 = eModelElement.getName();
                String string3 = String.format("<Profile Application> %s", string2);
                this.setText(string3);
            }
            if (eObject == null || eObject instanceof UMLDiagram || eObject instanceof Classifier || this.isAssociationEndTarget(eObject)) {
                // empty if block
            }
            if (eObject instanceof Package) {
                if (this.b((Package)((Object)eObject))) {
                    this.lock.setIcon(IconResource.getLockBlueIcon());
                    this.lock.setEnabled(jTree.isEnabled());
                } else if (this.a((Package)((Object)eObject))) {
                    this.lock.setIcon(IconResource.getLockRedIcon());
                    this.lock.setEnabled(jTree.isEnabled());
                }
            }
        }
        this.a(this.a(object, bl2, bl3, string));
        this.selected = bl;
        this.panel.doLayout();
        return this.panel;
    }

    private Icon a(Object object, boolean bl, boolean bl2, String string) {
        Icon icon = IconResource.getClassIcon();
        icon = bl2 ? this.getLeafIcon() : (bl ? this.getOpenIcon() : this.getClosedIcon());
        if (string != null) {
            if (string.equals("..")) {
                icon = this.getClosedIcon();
            }
            if (string.equals("Relation")) {
                icon = IconResource.getRelIcon();
            }
        }
        if (object instanceof DefaultMutableTreeNode) {
            EObject eObject;
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 != null && object2 instanceof UserObject && (eObject = ((UserObject)object2).getModel()) == null) {
                Presentation presentation = ((UserObject)object2).getPresentation();
                if (presentation instanceof MMTopicPresentation) {
                    icon = IconResource.getMMTopicIcon();
                } else if (presentation instanceof TextPresentation) {
                    icon = IconResource.getTextIcon();
                } else if (presentation instanceof FramePresentation) {
                    icon = IconResource.getFrameIcon();
                } else {
                    eObject = presentation.getModel();
                    icon = IconResource.getIcon(eObject);
                }
                icon = IconResource.getIcon(eObject);
            }
            if (((DefaultMutableTreeNode)object).isRoot()) {
                icon = IconResource.getPrjPkgIcon();
            }
        }
        return icon;
    }

    protected boolean needHyperlinkIcon(UserObject userObject) {
        return true;
    }

    protected boolean isAssociationEndTarget(EObject eObject) {
        return false;
    }

    protected TreeUtil getTreeUtil() {
        return (TreeUtil)ObjectFactory.getSpecialClassFromProperties("jude.TreeUtil");
    }

    void setTextForClassifier(Classifier classifier) {
        StringBuilder stringBuilder;
        block5: {
            block4: {
                stringBuilder = new StringBuilder();
                stringBuilder.append(this.getTreeUtil().getClassifierNameForTree(classifier));
                String string = classifier.getName();
                if (string == null || string.equals("")) break block4;
                TemplateSignature templateSignature = classifier.getOwnedTemplateSignature();
                if (templateSignature == null) break block5;
                EList<TemplateParameter> eList = templateSignature.getOwnedParameters();
                if (!eList.isEmpty()) {
                    stringBuilder.append("<");
                }
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    ClassifierTemplateParameter classifierTemplateParameter = (ClassifierTemplateParameter)iterator.next();
                    String[] stringArray = ClassifierPresentationUtil.getTemplateParameterInfo(classifierTemplateParameter);
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (stringArray[i2] == null) continue;
                        stringBuilder2.append(stringArray[i2]);
                    }
                    String string2 = stringBuilder2.toString();
                    stringBuilder.append(string2);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(",");
                }
                if (eList.isEmpty()) break block5;
                stringBuilder.append(">");
                break block5;
            }
            Iterator iterator = classifier.getTemplateBindings().iterator();
            while (iterator.hasNext()) {
                TemplateBinding templateBinding = (TemplateBinding)iterator.next();
                TemplateSignature templateSignature = templateBinding.getSignature();
                if (templateSignature == null) continue;
                stringBuilder.append(TemplateBindings.getTemplateBindingInfo(templateBinding, false));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
        }
        this.setText(stringBuilder.toString());
    }

    private void a(EObject eObject) {
        String string = AliasAccessor.getPhysicalName(eObject);
        String string2 = "".equals(string) ? "(" + eObject.toString() + ")" : string;
        this.setText(string2);
    }

    private String a(Element element) {
        String string = "";
        if (element instanceof Package) {
            // empty if block
        }
        return string;
    }

    private synchronized void a(Icon icon) {
        this.setIcon(icon);
    }

    private void b(EObject eObject) {
        List<Hyperlink> list = Hyperlinks.getHyperlinks(eObject);
        if (!list.isEmpty()) {
            Icon icon = IconResource.getHyperlinkIcon();
            this.hyperlink.setIcon(icon);
        }
    }

    private boolean a(Package package_) {
        throw new UnsupportedOperationException("\u672a\u5b9f\u88c5\u3067\u3059");
    }

    private boolean b(Package package_) {
        throw new UnsupportedOperationException("\u672a\u5b9f\u88c5\u3067\u3059");
    }

    private boolean a(String string, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.equals(stringArray[i2])) continue;
            return true;
        }
        return false;
    }

    public boolean isIDVisible() {
        return this.isIDVisible;
    }

    public void setIDVisible(boolean bl) {
        this.isIDVisible = bl;
    }

    public void setOtherLockedmodels(String[] stringArray) {
        this.otherLockedmodels = stringArray;
    }

    public void setSelfLockedmodels(String[] stringArray) {
        this.selfLockedmodels = stringArray;
    }

    protected static String getResourceString(String string) {
        return PropertyManager.getProjectViewResourceBundle().getString(string);
    }

    public void setDropTargetNode(TreeNode treeNode) {
        this.dropTargetNode = treeNode;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isTargetNode) {
            graphics.setColor(this.getBackgroundSelectionColor());
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
    }
}

