/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.WidgetPackage;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.ProjectPropertyUtil;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.ProjectPropertyPanel;
import net.astah.jomt.jview.SystemPropertyPanel;
import net.astah.model.extension.ExtensionFactory;
import net.astah.model.extension.Preferences;
import net.astah.notation.NotationPackage;
import net.astah.notation.provider.StylePreferencesHelper;
import net.astah.project.Project;
import net.astah.project.operations.ProjectOperations;
import org.eclipse.emf.ecore.EClass;

public class ProjectPropertyDialog
extends KeyDialog
implements ActionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 7155134689947493289L;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private static ProjectPropertyDialog a;
    private int resultState = 2;
    private String optionKey = "";
    private Map<String, SystemPropertyPanel> bodyPanels = new HashMap<String, SystemPropertyPanel>();
    private JLabel categoryLabel;
    private SystemPropertyPanel currentBodyPanel;
    private JPanel propertyPanel;
    private JTree categoryTree;
    private JScrollPane scrollPane;

    protected ProjectPropertyDialog(Frame frame, String string) {
        super(frame, true);
        this.optionKey = string;
        JTree jTree = this.a();
        this.propertyPanel = this.b();
        double d2 = SwingIconRegistry.getDefaultScale();
        int n2 = (int)Math.floor(400.0 * d2);
        int n3 = (int)Math.floor(350.0 * d2);
        this.propertyPanel.setPreferredSize(new Dimension(n2, n3));
        JPanel jPanel = this.c();
        Container container = this.getContentPane();
        container.add((Component)new JScrollPane(jTree), "West");
        container.add((Component)this.propertyPanel, "Center");
        container.add((Component)jPanel, "South");
        this.setTitle(PropertyManager.getProjectViewResourceBundle().getString("ui.dialog.project_property.title"));
        this.pack();
        this.setLocationRelativeTo(frame);
        jTree.setSelectionRow(0);
    }

    private JTree a() {
        String string = RuntimeGlobal.sysProp.getDefaultValue(this.optionKey);
        String[] stringArray = GolfUtilities.tokenize(string);
        Object[] objectArray = new a[stringArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = new a(stringArray[i2], ProjectPropertyDialog.a(stringArray[i2]));
        }
        this.categoryTree = new JTree(objectArray);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        this.categoryTree.setCellRenderer(defaultTreeCellRenderer);
        this.categoryTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.categoryTree.getSelectionModel().setSelectionMode(1);
        this.categoryTree.getSelectionModel().addTreeSelectionListener(this);
        return this.categoryTree;
    }

    private static String a(String string) {
        return RuntimeGlobal.sysProp.getLabel(string);
    }

    private JPanel b() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(jPanel.getBackground(), 5));
        this.categoryLabel = new JLabel("");
        this.categoryLabel.setBackground(new Color(200, 200, 255));
        this.categoryLabel.setOpaque(true);
        this.currentBodyPanel = this.b("");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.apply.label"));
        jButton.setActionCommand("APPLY");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.restore_defaults.label"));
        jButton2.setActionCommand("DEFAULT");
        jButton2.addActionListener(this);
        jPanel2.add(jButton2);
        jPanel.add((Component)this.categoryLabel, "North");
        this.scrollPane = new JScrollPane(this.currentBodyPanel);
        jPanel.add((Component)this.scrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        jPanel.doLayout();
        return jPanel;
    }

    private SystemPropertyPanel b(String string) {
        ProjectPropertyPanel projectPropertyPanel = new ProjectPropertyPanel();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!string.equals("")) {
            String string2 = RuntimeGlobal.sysProp.getDefaultValue(string);
            String[] stringArray = GolfUtilities.tokenize(string2);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                arrayList.add(stringArray[i2]);
            }
        }
        ((SystemPropertyPanel)projectPropertyPanel).setKeys(arrayList);
        this.bodyPanels.put(string, projectPropertyPanel);
        return projectPropertyPanel;
    }

    private JPanel c() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.ok.label"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.cancel.label"));
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JSeparator(), "North");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    private void c(String string) {
        this.d(string);
        this.e(string);
        this.propertyPanel.doLayout();
        this.currentBodyPanel.doLayout();
        this.propertyPanel.repaint();
    }

    private void d(String string) {
        this.categoryLabel.setText(ProjectPropertyDialog.a(string));
    }

    private void e(String string) {
        SystemPropertyPanel systemPropertyPanel = this.bodyPanels.get(string);
        if (systemPropertyPanel == null) {
            systemPropertyPanel = this.b(string);
            systemPropertyPanel.updatePanel();
        }
        this.propertyPanel.remove(this.scrollPane);
        this.scrollPane = new JScrollPane(systemPropertyPanel);
        this.propertyPanel.add((Component)this.scrollPane, "Center");
        this.currentBodyPanel = systemPropertyPanel;
    }

    public static ProjectPropertyDialog getInstance(Frame frame) {
        return ProjectPropertyDialog.getInstance(frame, "ui.project_properties.group");
    }

    public static ProjectPropertyDialog getInstance(Frame frame, String string) {
        a = new ProjectPropertyDialog(frame, string);
        a.resetPanels();
        return a;
    }

    public void resetPanels() {
        if (this.bodyPanels == null || this.bodyPanels.isEmpty()) {
            return;
        }
        for (SystemPropertyPanel systemPropertyPanel : this.bodyPanels.values()) {
            systemPropertyPanel.reset();
        }
    }

    public int getResultState() {
        return this.resultState;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.resultState = 1;
            this.e();
            this.setVisible(false);
        } else if (string.equals("CANCEL")) {
            this.resultState = 2;
            this.setVisible(false);
        } else if (string.equals("APPLY")) {
            this.d();
        } else if (string.equals("DEFAULT")) {
            this.f();
        }
    }

    private void d() {
        Map<String, Object> map = this.currentBodyPanel.getModifiedPropertyValues();
        this.a(map);
        this.currentBodyPanel.updatePanel();
        this.doLayout();
        this.currentBodyPanel.doLayout();
        this.propertyPanel.doLayout();
        this.repaint();
    }

    private void e() {
        for (SystemPropertyPanel systemPropertyPanel : this.bodyPanels.values()) {
            Map<String, Object> map = systemPropertyPanel.getModifiedPropertyValues();
            this.a(map);
        }
        RuntimeGlobal.sysProp.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Map<String, Object> map) {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            iJomtEntityStore.beginTransaction();
            Project project = ProjectOperations.getProject(iJomtEntityStore);
            Preferences preferences = project.getPreferences();
            if (preferences == null) {
                preferences = ExtensionFactory.eINSTANCE.createPreferences();
                project.setPreferences(preferences);
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string = entry.getKey();
                Object object = entry.getValue();
                if (object instanceof Color) {
                    Color color = (Color)object;
                    preferences.putValue(string, WidgetPackage.Literals.CCOLOR, new SwingColor(color));
                    continue;
                }
                RuntimeGlobal.sysProp.firePropertyChange(string, ProjectPropertyUtil.getTextValue(string), object.toString());
                preferences.putStringValue(string, object.toString());
            }
            StylePreferencesHelper.INSTANCE.applyStylePreferences(project, preferences);
            iJomtEntityStore.commitTransaction();
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
            iJomtEntityStore.abortTransaction();
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
            iJomtEntityStore.abortTransaction();
        }
    }

    protected EClass getKeyEClass(String string) {
        if ("uml.color.note".equals(string)) {
            return NotationPackage.Literals.GRAPHICAL_SHAPE;
        }
        if ("other.color.common".equals(string)) {
            return NotationPackage.Literals.SHAPE;
        }
        return null;
    }

    private void f() {
        this.currentBodyPanel.restoreDefaults();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        String string = ((a)defaultMutableTreeNode.getUserObject()).a;
        this.c(string);
    }

    public void updateLookAndFeel() {
        SwingUtilities.updateComponentTreeUI(this.getContentPane());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.resultState = 2;
            this.setVisible(false);
        }
    }

    private class a {
        public String a;
        public String b;

        public a(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        public String toString() {
            return this.b;
        }
    }
}

