/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.ref.SoftReference;
import java.util.Collection;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.astah.dd.di.Diagram;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jomt.jcontrol.tools.PrintableInfo;
import net.astah.jomt.jcontrol.tools.PrintableMulti;
import net.astah.jomt.jcontrol.tools.PrintableMultiDiagram;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PrintConfigDialog;
import net.astah.jomt.jview.PrintUtilities;
import net.astah.jomt.jview.w;
import net.astah.jomt.jview.x;
import net.astah.jomt.jview.y;
import net.astah.jomt.jview.z;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintPreviewDialog
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = -5645503104768116519L;
    private Frame owner;
    private PrintableInfo printable;
    private Book book;
    private JScrollPane viewPanel;
    private static int a = 1;
    private static float b = 0.5f;
    private PrinterJob printerJob;
    private PaperPanel[] paperPanels;
    private DocPrintJob job;
    private Doc doc;
    private PrintRequestAttributeSet printAttributes;
    private boolean isCongfiged = false;
    private boolean isPreviewMulti = false;
    private static final Logger c = LoggerFactory.getLogger(PrintPreviewDialog.class);

    public PrintPreviewDialog(Frame frame, PrintableInfo printableInfo, Book book) {
        super(frame, true);
        this.printable = printableInfo;
        this.book = book;
        this.owner = frame;
        this.printerJob = this.printable.getPrinterJob();
        if (this.printable instanceof PrintableMultiDiagram) {
            this.isPreviewMulti = true;
        }
        Container container = this.getContentPane();
        this.setTitle(this.getTitle("basic.print_preview.dialog.label"));
        JPanel jPanel = this.b();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "North");
        this.viewPanel = new JScrollPane();
        this.viewPanel.setPreferredSize(new Dimension(800, 600));
        this.viewPanel.getVerticalScrollBar().setUnitIncrement(40);
        this.viewPanel.getHorizontalScrollBar().setUnitIncrement(40);
        this.a(true);
        this.getContentPane().add((Component)this.viewPanel, "Center");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void a(boolean bl) {
        c.trace("iniShowPanel: in");
        if (this.book == null || this.book.getNumberOfPages() == 0) {
            return;
        }
        if (a < 1) {
            a = 1;
        }
        int n2 = this.book.getNumberOfPages();
        JPanel jPanel = new JPanel(new GridLayout(0, a, 10, 10));
        if (bl) {
            Dimension dimension = this.a();
            this.a(n2, dimension);
        }
        for (int i2 = 0; i2 < this.paperPanels.length; ++i2) {
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.paperPanels[i2], "Center");
            JLabel jLabel = new JLabel("Page " + (i2 + 1) + " of " + n2);
            jLabel.setHorizontalAlignment(0);
            jPanel2.add((Component)jLabel, "South");
            jPanel.add(jPanel2);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel);
        this.viewPanel.setViewportView(jPanel3);
        this.viewPanel.setViewport(this.viewPanel.getViewport());
        this.repaint();
        c.trace("iniShowPanel: out");
    }

    private void a(int n2, Dimension dimension) {
        this.paperPanels = new PaperPanel[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            PaperPanel paperPanel = new PaperPanel(this.book, i2);
            paperPanel.setMaximumSize(dimension);
            paperPanel.setMinimumSize(dimension);
            paperPanel.setPreferredSize(dimension);
            this.paperPanels[i2] = paperPanel;
        }
    }

    private Dimension a() {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.book.getNumberOfPages(); ++i2) {
            d2 = Math.max(d2, this.book.getPageFormat(i2).getHeight());
            d3 = Math.max(d3, this.book.getPageFormat(i2).getWidth());
        }
        return new Dimension((int)(d3 *= (double)b), (int)(d2 *= (double)b));
    }

    private JPanel b() {
        c.trace("createButtonPanel: in");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.g());
        jPanel.add(this.i());
        jPanel.add(new JLabel(this.getTitle("basic.print_preview.column.label")));
        jPanel.add(this.h());
        if (PropertyManager.isMacOS()) {
            jPanel.add(this.f());
            jPanel.add(this.e());
        } else {
            jPanel.add(this.e());
            jPanel.add(this.f());
        }
        c.trace("createButtonPanel: out");
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("CONFIG")) {
            Book book;
            int n2;
            if (this.isPreviewMulti) {
                PrintConfigDialog.setPrintDgm(false);
            } else {
                PrintConfigDialog.setPrintDgm(true);
            }
            PrintConfigDialog printConfigDialog = PrintConfigDialog.getInstance(this.owner);
            printConfigDialog.setVisible(true);
            if (printConfigDialog.getResultState() == 1) {
                if (!this.isPreviewMulti && !printConfigDialog.getModified()) {
                    return;
                }
            } else {
                return;
            }
            this.isCongfiged = true;
            if (this.isPreviewMulti && (n2 = MessageManager.displayYesNoDialog("app", "print_preview_multi_config.message")) == 0) {
                printConfigDialog.updatePrintBySelected((Collection<Diagram>)((PrintableMulti)this.printable).getPrintElements());
            }
            if ((book = this.printable.getBook(true)) != null) {
                this.book = book;
                this.a(true);
            }
        } else if (string.equals("PAGE")) {
            PageFormat pageFormat;
            PageFormat pageFormat2 = this.book.getPageFormat(0);
            if (pageFormat2 != (pageFormat = this.printerJob.pageDialog(pageFormat2))) {
                this.printable.setPageFormat(pageFormat);
                this.book = this.printable.getBook(true);
                this.a(true);
            }
        } else if (string.equals("CLOSE")) {
            this.dispose();
        } else if (string.equals("PRINT")) {
            int n3 = PrintUtilities.getPrintOption();
            if (n3 == 0) {
                this.d();
            } else {
                this.c();
            }
        }
    }

    private void c() {
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        PrintService[] printServiceArray = this.lookupPrintServices(sERVICE_FORMATTED);
        if (0 >= printServiceArray.length) {
            MessageManager.displayErrorMessage("app", "printer_not_available.message");
            return;
        }
        this.printAttributes = this.printable.loadPrintAttributes();
        if (this.printAttributes == null) {
            return;
        }
        int n2 = this.book.getNumberOfPages();
        this.printAttributes.add(new PageRanges(1, n2));
        PrintService printService = ServiceUI.printDialog(null, 100, 100, printServiceArray, PrintServiceLookup.lookupDefaultPrintService(), null, this.printAttributes);
        if (printService == null) {
            return;
        }
        this.printable.setPageFormat(this.printAttributes);
        this.printerJob.setPageable(this.book);
        this.doc = new SimpleDoc(this.book, sERVICE_FORMATTED, null);
        this.job = printService.createPrintJob();
        SwingInvoker.runInEDT(new w(this));
    }

    protected PrintService[] lookupPrintServices(DocFlavor docFlavor) {
        return PrintServiceLookup.lookupPrintServices(docFlavor, null);
    }

    private void d() {
        c.trace("print: in");
        this.printerJob.setPageable(this.book);
        if (this.printerJob.printDialog()) {
            SwingInvoker.runInEDT(new x(this));
        }
        c.trace("print: out");
    }

    private JButton e() {
        JButton jButton = new JButton(this.getTitle("basic.print_preview.diagram_config.label"));
        jButton.setActionCommand("CONFIG");
        jButton.addActionListener(this);
        if (this.isPreviewMulti) {
            jButton.setText(this.getTitle("basic.print_preview.project_config.label"));
        }
        return jButton;
    }

    private JButton f() {
        JButton jButton = new JButton(this.getTitle("basic.print_preview.close.label"));
        jButton.setActionCommand("CLOSE");
        jButton.addActionListener(this);
        return jButton;
    }

    private JButton g() {
        JButton jButton = new JButton(this.getTitle("basic.print_preview.print.label"));
        jButton.setActionCommand("PRINT");
        jButton.addActionListener(this);
        return jButton;
    }

    private JComboBox<String> h() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("1 ");
        jComboBox.addItem("2 ");
        jComboBox.addItem("3 ");
        jComboBox.addItem("4 ");
        jComboBox.addItem("5 ");
        jComboBox.addItem("6 ");
        jComboBox.addItem("7 ");
        jComboBox.addItem("8 ");
        jComboBox.setSelectedItem(String.valueOf(a) + " ");
        jComboBox.addItemListener(new y(this));
        Dimension dimension = jComboBox.getPreferredSize();
        dimension.width += 10;
        jComboBox.setPreferredSize(dimension);
        return jComboBox;
    }

    private JComboBox<a> i() {
        JComboBox<a> jComboBox = new JComboBox<a>();
        a a2 = new a(50);
        jComboBox.addItem(new a(10));
        jComboBox.addItem(new a(25));
        jComboBox.addItem(a2);
        jComboBox.addItem(new a(75));
        jComboBox.addItem(new a(100));
        jComboBox.addItem(new a(150));
        jComboBox.addItem(new a(200));
        jComboBox.addItem(new a(500));
        Dimension dimension = jComboBox.getPreferredSize();
        dimension.width += 10;
        jComboBox.setPreferredSize(dimension);
        for (int i2 = 0; i2 < jComboBox.getItemCount(); ++i2) {
            a a3 = (a)jComboBox.getItemAt(i2);
            if (a3.a() != b) continue;
            jComboBox.setSelectedItem(a3);
            break;
        }
        jComboBox.addItemListener(new z(this));
        return jComboBox;
    }

    protected String getTitle(String string) {
        String string2 = RuntimeGlobal.sysProp.getDefaultValue(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public boolean getConfiged() {
        return this.isCongfiged;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.dispose();
        }
    }

    static /* synthetic */ Doc access$000(PrintPreviewDialog printPreviewDialog) {
        return printPreviewDialog.doc;
    }

    static /* synthetic */ PrintRequestAttributeSet access$100(PrintPreviewDialog printPreviewDialog) {
        return printPreviewDialog.printAttributes;
    }

    static /* synthetic */ DocPrintJob access$200(PrintPreviewDialog printPreviewDialog) {
        return printPreviewDialog.job;
    }

    static /* synthetic */ PrinterJob access$300(PrintPreviewDialog printPreviewDialog) {
        return printPreviewDialog.printerJob;
    }

    static /* synthetic */ int access$402(int n2) {
        a = n2;
        return a;
    }

    static /* synthetic */ void access$500(PrintPreviewDialog printPreviewDialog, boolean bl) {
        printPreviewDialog.a(bl);
    }

    static /* synthetic */ float access$602(float f2) {
        b = f2;
        return b;
    }

    class PaperPanel
    extends JLabel {
        private static final long serialVersionUID = 7732876472142312211L;
        private int currentPaper = 0;
        private Book book;
        private SoftReference<Image> imageReference;

        public PaperPanel(Book book, int n2) {
            this.book = book;
            this.currentPaper = n2;
            this.setOpaque(false);
        }

        @Override
        public void paint(Graphics graphics) {
            Image image;
            c.trace("paint: in");
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.imageReference == null || this.imageReference.get() == null) {
                this.setupImage();
            }
            if ((image = this.imageReference.get()) != null) {
                graphics2D.drawImage(image, 0, 0, this);
            }
            c.trace("paint: out");
        }

        public void setupImage() {
            c.trace("setupImage: in");
            Image image = this.createImage(this.getSize().width, this.getSize().height);
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            graphics2D.setClip(0, 0, this.getSize().width, this.getSize().height);
            graphics2D.scale(b, b);
            PageFormat pageFormat = this.book.getPageFormat(this.currentPaper);
            this.b(graphics2D, pageFormat);
            this.a(graphics2D, pageFormat);
            graphics2D.dispose();
            this.imageReference = new SoftReference<Image>(image);
            c.trace("setupImage: out");
        }

        private void a(Graphics2D graphics2D, PageFormat pageFormat) {
            c.trace("paintPrintingImage: in");
            Printable printable = this.book.getPrintable(this.currentPaper);
            try {
                PrintUtilities.setMultiPageIndex(0);
                printable.print(graphics2D, pageFormat, this.currentPaper);
            }
            catch (PrinterException printerException) {
                c.error("error has occurred.", printerException);
            }
            c.trace("paintPrintingImage: out");
        }

        private void b(Graphics2D graphics2D, PageFormat pageFormat) {
            c.trace("paintBackground: in");
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, pageFormat.getWidth(), pageFormat.getHeight());
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(double_);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(double_);
            c.trace("paintBackground: out");
        }

        public void clearCacheImage() {
            this.imageReference = null;
        }
    }

    class a {
        private int b;

        public a(int n2) {
            this.b = n2;
        }

        public float a() {
            return (float)this.b / 100.0f;
        }

        public String toString() {
            return this.b + "%";
        }
    }
}

