/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import net.astah.dd.di.Diagram;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.PrintConfigPanel;
import net.astah.jomt.jview.TableEditor;
import net.astah.model.extension.Extensions;
import net.astah.model.extension.Preferences;
import net.astah.project.operations.ProjectOperations;
import org.eclipse.emf.ecore.EObject;

public class PrintConfigDialog
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = -4904995240943287121L;
    private static PrintConfigDialog a;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private int resultState = 2;
    protected JTabbedPane basePanel = this.newBasePanel();
    private boolean isModified = false;
    private static boolean b;

    public static void setPrintDgm(boolean bl) {
        b = bl;
    }

    public static PrintConfigDialog getInstance(Frame frame) {
        a = new PrintConfigDialog(frame);
        PrintConfigPanel printConfigPanel = null;
        for (int i2 = 0; i2 < PrintConfigDialog.a.basePanel.getComponentCount(); ++i2) {
            PrintConfigPanel printConfigPanel2 = (PrintConfigPanel)PrintConfigDialog.a.basePanel.getComponent(i2);
            printConfigPanel2.setPrintDgm(b);
            printConfigPanel2.updatePanel();
            if (i2 != 0) continue;
            printConfigPanel = printConfigPanel2;
        }
        Component component = printConfigPanel.getComponent("basic.print.project");
        if (component != null) {
            printConfigPanel.setEnabledByPrj((JCheckBox)component);
        }
        a.setModified(false);
        return a;
    }

    protected PrintConfigDialog(Frame frame) throws HeadlessException {
        super(frame, true);
        Container container = this.getContentPane();
        container.add((Component)this.basePanel, "Center");
        container.add(this.a(), "South");
        double d2 = SwingIconRegistry.getDefaultScale();
        if (PropertyManager.isMacOS()) {
            this.setSize((int)Math.ceil(700.0 * d2), (int)Math.ceil(350.0 * d2));
        } else {
            this.setSize((int)Math.ceil(600.0 * d2), (int)Math.ceil(280.0 * d2));
        }
        this.setTitle(RuntimeGlobal.sysProp.getDefaultValue("basic.print.print_config.title"));
        this.setLocationRelativeTo(frame);
    }

    protected JTabbedPane newBasePanel() {
        return this.createBasePanel("basic.print");
    }

    private Component a() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.ok.label"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.cancel.label"));
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JSeparator(), "North");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected JTabbedPane createBasePanel(String string) {
        this.basePanel = new JTabbedPane();
        String[] stringArray = RuntimeGlobal.sysProp.getSubKeys(string);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Editor editor;
                PrintConfigPanel printConfigPanel = new PrintConfigPanel(b);
                String string2 = RuntimeGlobal.sysProp.getDefaultString(stringArray[i2] + ".label");
                String[] stringArray2 = RuntimeGlobal.sysProp.getSubKeys(stringArray[i2]);
                if (stringArray2 == null || b && ((editor = JomtGlobal.viewManager.getCurrentEditor()) instanceof DiagramEditor && stringArray[i2].equals("basic.print.table") || editor instanceof TableEditor && stringArray[i2].equals("basic.print.diagram"))) continue;
                printConfigPanel.setKeys(Arrays.asList(stringArray2));
                this.basePanel.addTab(string2, printConfigPanel);
            }
        }
        return this.basePanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.resultState = 1;
            this.apply();
            this.setVisible(false);
        } else if (string.equals("CANCEL")) {
            this.resultState = 2;
            this.setVisible(false);
        }
    }

    protected void apply() {
        for (int i2 = 0; i2 < PrintConfigDialog.a.basePanel.getComponentCount(); ++i2) {
            PrintConfigPanel printConfigPanel = (PrintConfigPanel)PrintConfigDialog.a.basePanel.getComponent(i2);
            Map<String, Object> map = printConfigPanel.getPropertyValues();
            this.apply(map);
            RuntimeGlobal.sysProp.store();
            printConfigPanel.updatePanel();
            this.doLayout();
            printConfigPanel.doLayout();
            this.repaint();
        }
    }

    protected void apply(Map<String, Object> map) {
        EObject eObject = null;
        if (b) {
            Editor editor = JomtGlobal.viewManager.getCurrentEditor();
            if (editor instanceof DiagramEditor) {
                eObject = ((DiagramEditor)editor).getDiagram();
            }
            if (editor instanceof TableEditor) {
                eObject = ((TableEditor)editor).getModel();
            }
        }
        for (String string : map.keySet()) {
            EObject eObject2;
            Object object = map.get(string);
            if (b && eObject instanceof Diagram) {
                eObject2 = Extensions.getPreferences(eObject, true);
                if (eObject2.getStringValue(string) != null && eObject2.getStringValue(string).equals(object.toString())) continue;
                this.isModified = true;
                eObject2.putStringValue(string, object.toString());
                continue;
            }
            eObject2 = ProjectOperations.getProject(ModelGlobal.prjManager.getCurrentProject().doc);
            Preferences preferences = eObject2.getPreferences();
            if (preferences.getStringValue(string) == null || !preferences.getStringValue(string).equals(object.toString())) {
                this.isModified = true;
                preferences.putStringValue(string, object.toString());
            }
            RuntimeGlobal.sysProp.setValue(string, object);
        }
    }

    public void updatePrintBySelected(Collection<Diagram> collection) {
        for (Diagram diagram : collection) {
            if (diagram == null || !(diagram instanceof IStyleMapOwner)) continue;
            IStyleMapOwner iStyleMapOwner = (IStyleMapOwner)((Object)diagram);
            for (Component component : PrintConfigDialog.a.basePanel.getComponents()) {
                Map<String, Object> map = ((PrintConfigPanel)component).getPropertyValues();
                for (String string : map.keySet()) {
                    Object object = map.get(string);
                    if (iStyleMapOwner.getStyleMapFromKey(string) != null && iStyleMapOwner.getStyleMapFromKey(string).equals(object.toString())) continue;
                    iStyleMapOwner.addStyleMap(string, object.toString());
                }
            }
        }
    }

    @Deprecated
    public void updatePrintBySelected(List<? extends IStyleMapOwner> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            UMLDiagram uMLDiagram = null;
            if (!(list.get(i2) instanceof UMLDiagram)) {
                throw new UnsupportedOperationException("\u672a\u5bfe\u5fdc");
            }
            uMLDiagram = (UMLDiagram)list.get(i2);
            for (int i3 = 0; i3 < PrintConfigDialog.a.basePanel.getComponentCount(); ++i3) {
                PrintConfigPanel printConfigPanel = (PrintConfigPanel)PrintConfigDialog.a.basePanel.getComponent(i3);
                Map<String, Object> map = printConfigPanel.getPropertyValues();
                for (String string : map.keySet()) {
                    Object object = map.get(string);
                    if (uMLDiagram == null || uMLDiagram.getStyleMapFromKey(string) != null && uMLDiagram.getStyleMapFromKey(string).equals(object.toString())) continue;
                    uMLDiagram.addStyleMap(string, object.toString());
                }
            }
        }
    }

    public int getResultState() {
        return this.resultState;
    }

    public boolean getModified() {
        return this.isModified;
    }

    protected void setModified(boolean bl) {
        this.isModified = bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.resultState = 2;
            this.setVisible(false);
        }
    }

    static {
        b = false;
    }
}

