/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.ClassifierPresentationUtil;
import net.astah.jomt.jview.SortableTable;
import net.astah.jomt.jview.v;
import net.astah.swing.SortableTableModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;

public class OperationVisibilityTable
extends SortableTable {
    private static final long serialVersionUID = -8710778013653138668L;
    protected static final String PARAMETER_HEADER = OperationVisibilityTable.getTitle("projectview.table.header.parameters.label");
    protected static final String RVALUE_HEADER = OperationVisibilityTable.getTitle("projectview.table.header.return_value.label");
    protected static final String VISIBILITY_HEADER = OperationVisibilityTable.getTitle("projectview.table.header.visibility.label");
    private ClassifierPresentation presentation = null;
    private Classifier model = null;

    public OperationVisibilityTable(ClassifierPresentation classifierPresentation) {
        this.presentation = classifierPresentation;
        this.model = this.getClassifierModel(classifierPresentation);
        this.setLayout(new BorderLayout());
        this.a();
        this.scroller = new JScrollPane(this.table);
        this.add(this.scroller);
    }

    protected Classifier getClassifierModel(ClassifierPresentation classifierPresentation) {
        return (Classifier)new v(this).doSwitch(classifierPresentation.getModel());
    }

    private void a() {
        this.columnNames = new String[5];
        this.columnNames[0] = "C";
        this.columnNames[1] = this.NAME_HEADER;
        this.columnNames[2] = PARAMETER_HEADER;
        this.columnNames[3] = RVALUE_HEADER;
        this.columnNames[4] = VISIBILITY_HEADER;
        Object[][] objectArray = this.a(this.columnNames.length);
        this.tableModel = new SortableTableModel(objectArray, this.columnNames);
        this.table = new AdjustedRowHeightTable(this.tableModel);
        this.table.setShowGrid(true);
        this.table.getColumnModel().setColumnMargin(0);
        this.table.getColumn("C").setMaxWidth(30);
        this.table.getColumn(this.NAME_HEADER).setPreferredWidth(100);
        this.table.getColumn(this.NAME_HEADER).setCellRenderer(new OperationNameCellRenderer(null));
        this.table.getColumn(PARAMETER_HEADER).setPreferredWidth(250);
        this.table.getColumn(RVALUE_HEADER).setPreferredWidth(70);
        this.table.getColumn(VISIBILITY_HEADER).setPreferredWidth(60);
        this.table.setRowSelectionAllowed(true);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(this);
    }

    private Object[][] a(int n2) {
        EList<Operation> eList = this.model.getOperations();
        if (eList == null || eList.size() == 0) {
            return null;
        }
        Object[][] objectArray = new Object[eList.size()][n2];
        int n3 = 0;
        for (Operation operation : eList) {
            objectArray[n3][0] = !this.presentation.isFeatureVisible(operation) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            List<Object> list = ClassifierPresentationUtil.getOperationInfo(operation);
            String string = ClassifierPresentationUtil.getParameterString(list, false);
            objectArray[n3][1] = operation;
            objectArray[n3][2] = string;
            objectArray[n3][3] = list.get(2);
            objectArray[n3][4] = operation.getVisibility();
            ++n3;
        }
        return objectArray;
    }

    private class OperationNameCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3425821369449565134L;

        private OperationNameCellRenderer() {
        }

        @Override
        protected void setValue(Object object) {
            if (object instanceof Operation) {
                this.setText(((Operation)Operation.class.cast(object)).getName());
                return;
            }
            super.setValue(object);
        }

        /* synthetic */ OperationNameCellRenderer(v v2) {
            this();
        }
    }
}

