/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.AttributeVisibilityTable;
import net.astah.jomt.jview.JudeItemSelectable;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.OperationVisibilityTable;

public class MultiFeatureVisibilityChooser
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = -5267850672598248774L;
    protected boolean approve = false;
    protected JButton selectAttributeAllBtn = null;
    protected JButton selectOperationAllBtn = null;
    protected JButton okBtn = null;
    protected JButton cancelBtn = null;
    protected JPanel attributeScroller = null;
    protected JPanel operationScroller = null;
    protected JSplitPane baseSplitPane = null;
    private JPanel basePanel = new JPanel(new BorderLayout());
    protected ClassifierPresentation presentation = null;

    public MultiFeatureVisibilityChooser(JFrame jFrame, ClassifierPresentation classifierPresentation) {
        super((Frame)jFrame, true);
        this.presentation = classifierPresentation;
        this.initTable();
    }

    protected void initTable() {
        this.attributeScroller = new AttributeVisibilityTable(this.presentation);
        this.operationScroller = new OperationVisibilityTable(this.presentation);
        this.createFeatureTable(this.attributeScroller, this.operationScroller);
    }

    public List<Object> getAttributeCheckedItems() {
        if (this.attributeScroller instanceof JudeItemSelectable) {
            return ((JudeItemSelectable)((Object)this.attributeScroller)).getCheckedItems();
        }
        return null;
    }

    public List<Object> getOperationCheckedItems() {
        if (this.operationScroller instanceof JudeItemSelectable) {
            return ((JudeItemSelectable)((Object)this.operationScroller)).getCheckedItems();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okBtn) {
            this.approve = true;
            this.setVisible(false);
            this.dispose();
        } else if (object == this.cancelBtn) {
            this.approve = false;
            this.setVisible(false);
            this.dispose();
        } else if (object == this.selectAttributeAllBtn) {
            if (this.selectAttributeAllBtn.getText().equals(this.getTitle("projectview.button.select_all.label"))) {
                this.selectAttributeAll();
                this.selectAttributeAllBtn.setText(this.getTitle("projectview.button.deselect_all.label"));
            } else {
                this.deselectAttributeAll();
                this.selectAttributeAllBtn.setText(this.getTitle("projectview.button.select_all.label"));
            }
        } else if (object == this.selectOperationAllBtn) {
            if (this.selectOperationAllBtn.getText().equals(this.getTitle("projectview.button.select_all.label"))) {
                this.selectOperationAll();
                this.selectOperationAllBtn.setText(this.getTitle("projectview.button.deselect_all.label"));
            } else {
                this.deselectOperationAll();
                this.selectOperationAllBtn.setText(this.getTitle("projectview.button.select_all.label"));
            }
        }
    }

    protected void deselectAttributeAll() {
        if (this.attributeScroller instanceof JudeItemSelectable) {
            ((JudeItemSelectable)((Object)this.attributeScroller)).deselectAll();
        }
    }

    protected void selectAttributeAll() {
        if (this.attributeScroller instanceof JudeItemSelectable) {
            ((JudeItemSelectable)((Object)this.attributeScroller)).selectAll();
        }
    }

    protected void deselectOperationAll() {
        if (this.operationScroller instanceof JudeItemSelectable) {
            ((JudeItemSelectable)((Object)this.operationScroller)).deselectAll();
        }
    }

    protected void selectOperationAll() {
        if (this.operationScroller instanceof JudeItemSelectable) {
            ((JudeItemSelectable)((Object)this.operationScroller)).selectAll();
        }
    }

    public boolean isApprove() {
        return this.approve;
    }

    protected String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    protected void createAttributeSelectAllButton() {
        this.selectAttributeAllBtn = new JButton(this.getTitle("projectview.button.select_all.label"));
        this.selectAttributeAllBtn.addActionListener(this);
    }

    protected void createOperationSelectAllButton() {
        this.selectOperationAllBtn = new JButton(this.getTitle("projectview.button.select_all.label"));
        this.selectOperationAllBtn.addActionListener(this);
    }

    protected String getTopPanelName() {
        return this.getTitle("projectview.tab.attribute.label");
    }

    protected String getBottomPanelName() {
        return this.getTitle("projectview.tab.operation.label");
    }

    protected void createFeatureTable(JPanel jPanel, JPanel jPanel2) {
        this.createAttributeSelectAllButton();
        this.createOperationSelectAllButton();
        JPanel jPanel3 = this.a(jPanel, " " + this.getTopPanelName(), this.selectAttributeAllBtn);
        JPanel jPanel4 = this.a(jPanel2, " " + this.getBottomPanelName(), this.selectOperationAllBtn);
        this.baseSplitPane = new JSplitPane();
        this.baseSplitPane.setOrientation(0);
        this.baseSplitPane.setDividerSize(5);
        this.baseSplitPane.setDividerLocation(170);
        this.baseSplitPane.setTopComponent(jPanel3);
        this.baseSplitPane.setBottomComponent(jPanel4);
        JPanel jPanel5 = this.createButtonPanel();
        this.basePanel.add("Center", this.baseSplitPane);
        this.basePanel.add("South", jPanel5);
        this.getContentPane().add(this.basePanel);
        this.setSize(500, 400);
    }

    private JPanel a(JPanel jPanel, String string, JButton jButton) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jPanel3.add("West", jLabel);
        jPanel3.add("East", jButton);
        jPanel2.add("North", jPanel3);
        jPanel2.add("Center", jPanel);
        return jPanel2;
    }

    protected JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        this.okBtn = new JButton(this.getTitle("projectview.button.ok.label"));
        this.cancelBtn = new JButton(this.getTitle("projectview.button.cancel.label"));
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            jPanel.add(this.cancelBtn);
            jPanel.add(this.okBtn);
        } else {
            jPanel.add(this.okBtn);
            jPanel.add(this.cancelBtn);
        }
        return jPanel;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.approve = false;
            this.setVisible(false);
            this.dispose();
        }
    }
}

