/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.JudeItemSelectable;
import net.astah.jomt.jview.KeyDialog;

public abstract class MultiChooser
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = 8335253293358419285L;
    protected boolean approve = false;
    protected JButton selectAllBtn = null;
    protected JButton okBtn = null;
    protected JButton cancelBtn = null;
    protected JPanel scroller = null;
    protected boolean needDescription = false;
    protected boolean needShowERElements = true;

    public MultiChooser(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.initPanel();
    }

    public MultiChooser(JFrame jFrame, boolean bl) {
        this(jFrame, bl, true);
    }

    public MultiChooser(JFrame jFrame, boolean bl, boolean bl2) {
        super((Frame)jFrame, true);
        this.needDescription = bl;
        this.needShowERElements = bl2;
        this.initPanel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okBtn) {
            this.approve = true;
            this.setVisible(false);
            this.dispose();
        } else if (object == this.cancelBtn) {
            this.approve = false;
            this.setVisible(false);
            this.dispose();
        } else if (object == this.selectAllBtn) {
            if (this.selectAllBtn.getText().equals(this.getTitle("projectview.button.select_all.label"))) {
                this.selectAll();
                this.selectAllBtn.setText(this.getTitle("projectview.button.deselect_all.label"));
            } else {
                this.deselectAll();
                this.selectAllBtn.setText(this.getTitle("projectview.button.select_all.label"));
            }
        }
    }

    protected void deselectAll() {
        if (this.scroller instanceof JudeItemSelectable) {
            ((JudeItemSelectable)((Object)this.scroller)).deselectAll();
        }
    }

    protected void selectAll() {
        if (this.scroller instanceof JudeItemSelectable) {
            ((JudeItemSelectable)((Object)this.scroller)).selectAll();
        }
    }

    public boolean isApprove() {
        return this.approve;
    }

    protected String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    protected JPanel createButtonPanel() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.setHgap(5);
        JPanel jPanel = new JPanel(gridLayout);
        jPanel.add(this.addExtendButtons());
        jPanel.add(this.addOKandCancelButtons());
        return jPanel;
    }

    protected JPanel addExtendButtons() {
        JPanel jPanel = new JPanel(new GridLayout());
        this.selectAllBtn = new JButton(this.getTitle("projectview.button.select_all.label"));
        this.selectAllBtn.addActionListener(this);
        jPanel.add(this.selectAllBtn);
        return jPanel;
    }

    protected JPanel addOKandCancelButtons() {
        JPanel jPanel = new JPanel(new GridLayout());
        this.okBtn = new JButton(this.getTitle("projectview.button.ok.label"));
        this.cancelBtn = new JButton(this.getTitle("projectview.button.cancel.label"));
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            jPanel.add(this.cancelBtn);
            jPanel.add(this.okBtn);
        } else {
            jPanel.add(this.okBtn);
            jPanel.add(this.cancelBtn);
        }
        return jPanel;
    }

    public List getCheckedItems() {
        if (this.scroller instanceof JudeItemSelectable) {
            return ((JudeItemSelectable)((Object)this.scroller)).getCheckedItems();
        }
        return null;
    }

    public List getUnCheckedItems() {
        if (this.scroller instanceof JudeItemSelectable) {
            return ((JudeItemSelectable)((Object)this.scroller)).getUnCheckedItems();
        }
        return null;
    }

    protected abstract void initPanel();

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.approve = false;
            this.setVisible(false);
            this.dispose();
        }
    }
}

