/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import lombok.NonNull;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.util.Debug;
import net.astah.jmodel.UMLStateChartDiagram;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.GCustomizeComboBox;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.proptab.MyCellRenderer;
import net.astah.jomt.jview.proptab.i;
import net.astah.uml2.operations.StateMachinePresentations;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.StateMachine;

public class ModelSelectionDialog<T extends Element>
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = 8369792579947449096L;
    private int result = 2;
    private T selected;
    private ButtonGroup group;
    private JRadioButton newRadio;
    private JRadioButton oldRadio;
    private GCustomizeComboBox comboBox;
    private JButton okBtn;

    public T getSelected() {
        return this.selected;
    }

    public int getResult() {
        return this.result;
    }

    public ModelSelectionDialog(@NonNull Frame frame, @NonNull List<? extends T> list, @NonNull Object object) {
        super(frame, true);
        if (frame == null) {
            throw new NullPointerException("parent");
        }
        if (list == null) {
            throw new NullPointerException("models");
        }
        if (object == null) {
            throw new NullPointerException("object");
        }
        String string = LabelProviders.getTypeText(object);
        this.a(frame, list, string);
    }

    private void a(@NonNull Frame frame, @NonNull List<? extends T> list, @NonNull String string) {
        if (frame == null) {
            throw new NullPointerException("parent");
        }
        if (list == null) {
            throw new NullPointerException("models");
        }
        if (string == null) {
            throw new NullPointerException("typeText");
        }
        if (list.isEmpty()) {
            Debug.impossible("empty models !");
        }
        JPanel jPanel = this.a(list, string);
        JPanel jPanel2 = this.a();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel3);
        this.getRootPane().setDefaultButton(this.okBtn);
        this.setTitle(this.a("ui.dialog.create_new_model.title", string));
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private String a(String string, String ... stringArray) {
        MessageFormat messageFormat = new MessageFormat(this.getTitle(string));
        return messageFormat.format(stringArray);
    }

    private JPanel a(List<? extends T> list, String string) {
        this.newRadio = new JRadioButton(this.a("ui.dialog.create_new_model.label", string));
        this.oldRadio = new JRadioButton(this.a("ui.dialog.select_exist_model.label", string));
        this.group = new ButtonGroup();
        this.group.add(this.newRadio);
        this.group.add(this.oldRadio);
        this.newRadio.setSelected(true);
        this.newRadio.addActionListener(this);
        this.oldRadio.addActionListener(this);
        this.comboBox = new GCustomizeComboBox();
        this.comboBox.setEditable(false);
        this.comboBox.setMaximumRowCount(20);
        Object object = list.iterator();
        while (object.hasNext()) {
            Element element;
            EModelElement eModelElement = element = (Element)object.next();
            if (element instanceof StateMachine) {
                eModelElement = StateMachinePresentations.getOwnedStateMachineDiagram((StateMachine)element);
            }
            this.comboBox.addItem(eModelElement);
        }
        this.comboBox.setSelectedIndex(-1);
        this.comboBox.setRenderer(new MyCellRenderer<Object>(this.comboBox));
        this.comboBox.setBackground(Color.white);
        this.comboBox.setEditor(new i());
        this.comboBox.addActionListener(this);
        object = new JPanel(new GridLayout(3, 1));
        ((Container)object).add(this.newRadio);
        ((Container)object).add(this.oldRadio);
        ((Container)object).add(this.comboBox);
        return object;
    }

    private JPanel a() {
        JPanel jPanel = new JPanel(new GridLayout());
        this.okBtn = new JButton(this.getTitle("projectview.button.ok.label"));
        this.okBtn.setToolTipText(this.getTitle("projectview.button.ok.tooltip"));
        this.okBtn.setActionCommand("OK");
        this.okBtn.addActionListener(this);
        JButton jButton = new JButton(this.getTitle("projectview.button.cancel.label"));
        jButton.setToolTipText(this.getTitle("projectview.button.cancel.tooltip"));
        jButton.setActionCommand("Cancel");
        jButton.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            jPanel.add(jButton);
            jPanel.add(this.okBtn);
        } else {
            jPanel.add(this.okBtn);
            jPanel.add(jButton);
        }
        return jPanel;
    }

    protected String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("OK".equals(actionEvent.getActionCommand())) {
            if (this.oldRadio.isSelected()) {
                Object object = this.comboBox.getSelectedItem();
                this.selected = object instanceof UMLStateChartDiagram ? ((UMLStateChartDiagram)object).getStateMachine() : (Element)object;
            }
            this.result = 0;
            this.setVisible(false);
        } else if ("Cancel".equals(actionEvent.getActionCommand())) {
            this.result = 2;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.newRadio) {
            this.okBtn.setEnabled(true);
        } else if (actionEvent.getSource() == this.oldRadio) {
            this.okBtn.setEnabled(this.comboBox.getSelectedIndex() != -1);
        } else if (actionEvent.getSource() == this.comboBox) {
            this.oldRadio.setSelected(true);
            this.okBtn.setEnabled(this.comboBox.getSelectedIndex() != -1);
        }
    }
}

