/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.GolfUtilities;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.MindMapPropertyPanel;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.notation.mindmap.edit.layout.MindMapUtilties;

public class MindMapPropertyDialog
extends KeyDialog
implements ActionListener,
TreeSelectionListener {
    private static final long serialVersionUID = -1268425682911110009L;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private int resultState = 2;
    private JLabel categoryLabel;
    private MindMapPropertyPanel currentBodyPanel;
    private Map<String, MindMapPropertyPanel> bodyPanels = new HashMap<String, MindMapPropertyPanel>();
    private JPanel propertyPanel;
    private JTree categoryTree;
    private JScrollPane scrollPane;
    private IEntityStore doc = null;
    private MMDiagram diagram = null;

    public MindMapPropertyDialog(Frame frame, MMDiagram mMDiagram) {
        super(frame, true);
        this.diagram = mMDiagram;
        this.doc = ModelGlobal.prjManager.getCurrentProject().doc;
        JTree jTree = this.a();
        this.propertyPanel = this.b();
        JPanel jPanel = this.c();
        Container container = this.getContentPane();
        container.add((Component)new JScrollPane(jTree), "West");
        container.add((Component)this.propertyPanel, "Center");
        container.add((Component)jPanel, "South");
        this.setTitle(PropertyManager.getProjectViewResourceBundle().getString("ui.dialog.mindmap_properties.title"));
        this.a(jTree);
        int n2 = this.scrollPane.getPreferredSize().width - this.currentBodyPanel.getPreferredSize().width;
        int n3 = this.a(this.bodyPanels) + n2;
        this.scrollPane.setPreferredSize(new Dimension(n3, this.scrollPane.getPreferredSize().height));
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void a(JTree jTree) {
        for (int i2 = jTree.getRowCount(); i2 >= 0; --i2) {
            jTree.setSelectionRow(i2);
        }
    }

    private int a(Map<String, MindMapPropertyPanel> map) {
        int n2 = 0;
        for (String string : map.keySet()) {
            n2 = Math.max(n2, map.get((Object)string).getPreferredSize().width);
        }
        return n2;
    }

    private JTree a() {
        String string = MindMapUtilties.getMindMapProperty().getDefaultValue("ui.mindmapprop.group");
        String[] stringArray = GolfUtilities.tokenize(string);
        Object[] objectArray = new a[stringArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = new a(stringArray[i2], MindMapPropertyDialog.a(stringArray[i2]));
        }
        this.categoryTree = new JTree(objectArray);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        this.categoryTree.setCellRenderer(defaultTreeCellRenderer);
        this.categoryTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.categoryTree.getSelectionModel().setSelectionMode(1);
        this.categoryTree.getSelectionModel().addTreeSelectionListener(this);
        return this.categoryTree;
    }

    private static String a(String string) {
        return MindMapUtilties.getMindMapProperty().getLabelValue(string);
    }

    private JPanel b() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(jPanel.getBackground(), 5));
        this.categoryLabel = new JLabel("");
        this.categoryLabel.setBackground(new Color(200, 200, 255));
        this.categoryLabel.setOpaque(true);
        this.currentBodyPanel = this.b("");
        this.currentBodyPanel.setDiagram(this.diagram);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.apply.label"));
        jButton.setActionCommand("APPLY");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.restore_defaults.label"));
        jButton2.setActionCommand("DEFAULT");
        jButton2.addActionListener(this);
        jPanel2.add(jButton2);
        jPanel.add((Component)this.categoryLabel, "North");
        this.scrollPane = new JScrollPane(this.currentBodyPanel);
        jPanel.add((Component)this.scrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        jPanel.doLayout();
        return jPanel;
    }

    private MindMapPropertyPanel b(String string) {
        MindMapPropertyPanel mindMapPropertyPanel = new MindMapPropertyPanel(string);
        this.bodyPanels.put(string, mindMapPropertyPanel);
        return mindMapPropertyPanel;
    }

    private JPanel c() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.ok.label"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.cancel.label"));
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JSeparator(), "North");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    private void c(String string) {
        this.d(string);
        this.e(string);
        this.propertyPanel.doLayout();
        this.currentBodyPanel.doLayout();
        this.propertyPanel.repaint();
    }

    private void d(String string) {
        this.categoryLabel.setText(MindMapPropertyDialog.a(string));
    }

    private void e(String string) {
        MindMapPropertyPanel mindMapPropertyPanel = this.bodyPanels.get(string);
        if (mindMapPropertyPanel == null) {
            mindMapPropertyPanel = this.b(string);
            mindMapPropertyPanel.setDiagram(this.diagram);
            mindMapPropertyPanel.updatePanel();
        }
        this.propertyPanel.remove(this.scrollPane);
        this.scrollPane = new JScrollPane(mindMapPropertyPanel);
        this.propertyPanel.add((Component)this.scrollPane, "Center");
        this.currentBodyPanel = mindMapPropertyPanel;
    }

    public void resetPanels() {
        if (this.bodyPanels == null || this.bodyPanels.isEmpty()) {
            return;
        }
        for (MindMapPropertyPanel mindMapPropertyPanel : this.bodyPanels.values()) {
            mindMapPropertyPanel.reset();
        }
    }

    public int getResultState() {
        return this.resultState;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.resultState = 1;
            this.e();
            this.setVisible(false);
        } else if (string.equals("CANCEL")) {
            this.resultState = 2;
            this.setVisible(false);
        } else if (string.equals("APPLY")) {
            this.d();
        } else if (string.equals("DEFAULT")) {
            this.f();
        }
    }

    private void d() {
        Map<String, String> map = this.currentBodyPanel.getModifiedPropertyValues();
        if (!map.isEmpty()) {
            this.doc.beginTransaction();
            this.b(map);
            this.currentBodyPanel.updatePanel();
            this.doLayout();
            this.currentBodyPanel.doLayout();
            this.propertyPanel.doLayout();
            this.repaint();
            this.validate();
            this.a(this.diagram);
            this.doc.commitTransaction();
        }
    }

    private void a(MMDiagram mMDiagram) {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (diagramEditor != null) {
            diagramEditor.repaintCanvas();
        }
    }

    private void e() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (MindMapPropertyPanel mindMapPropertyPanel : this.bodyPanels.values()) {
            hashMap.putAll(mindMapPropertyPanel.getModifiedPropertyValues());
        }
        if (!hashMap.isEmpty()) {
            this.doc.beginTransaction();
            this.b(hashMap);
            this.a(this.diagram);
            this.doc.commitTransaction();
        }
    }

    private void b(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            MMStyleSupport.addStyleMap(this.diagram, entry.getKey(), entry.getValue());
        }
    }

    private void f() {
        this.currentBodyPanel.restoreDefaults(this.currentBodyPanel.keys);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        String string = ((a)defaultMutableTreeNode.getUserObject()).a;
        this.c(string);
    }

    public void updateLookAndFeel() {
        SwingUtilities.updateComponentTreeUI(this.getContentPane());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.resultState = 2;
            this.setVisible(false);
        }
    }

    private class a {
        public String a;
        public String b;

        public a(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        public String toString() {
            return this.b;
        }
    }
}

