/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import net.astah.golf.draw.GCamera;
import net.astah.golf.draw.GCanvas;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GScene;
import net.astah.golf.widget.CColor;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jviewElement.DiagramViewElement;
import net.astah.jomt.jviewElement.DiagramViewEvent;
import net.astah.jomt.jviewElement.DiagramViewListener;
import net.astah.jomt.jviewElement.JomtViewElement;

public class MapPanel
extends JPanel
implements DiagramViewListener {
    private static final long serialVersionUID = 6068274302329630358L;
    private GCanvas canvas;
    private GScene dgmViewScene;
    private GScene dgmFrameScene;
    private GCamera camera;
    private DiagramViewElement dve;
    protected CColor[] defaultColorMap = JomtViewElement.DEFAULT_COLOR_MAP;
    private MapPanelComponentListener listener = new MapPanelComponentListener();

    public MapPanel() {
        this.setLayout(new BorderLayout());
        this.canvas = new GCanvas();
        this.canvas.setDoDrawComponent(false);
        this.canvas.addComponentListener(this.listener);
        this.canvas.setColorMap(this.defaultColorMap);
        this.camera = new GCamera();
        this.dgmViewScene = new GScene();
        this.dgmViewScene.setCamera(this.camera);
        this.dgmViewScene.setSelectable(false);
        this.dgmViewScene.setDoAntialiasing(false);
        this.canvas.addScene(this.dgmViewScene);
        this.add("Center", this.canvas);
    }

    public void setDiagramEditor(DiagramEditor diagramEditor) {
        this.unsetDiagramEditor();
        if (diagramEditor != null) {
            this.dve = diagramEditor.getDiagramScene().getDiagramViewElement();
            this.dve.addDiagramViewListener(this);
            this.dgmViewScene.addTree((GNode)((Object)this.dve));
            this.updateCanvas();
        }
    }

    public void unsetDiagramEditor() {
        if (this.dve != null) {
            this.dve.removeDiagramViewListener(this);
            this.dgmViewScene.removeTree((GNode)((Object)this.dve));
            this.dve = null;
        }
    }

    public void remove() {
        this.canvas.removeComponentListener(this.listener);
    }

    public GScene getDiagramEditorFrameScene() {
        if (this.dgmFrameScene == null) {
            this.dgmFrameScene = new GScene();
            this.dgmFrameScene.addTree(new GNode());
            this.dgmFrameScene.setCamera(this.dgmViewScene.getCamera());
            this.canvas.addScene(this.dgmFrameScene);
        }
        return this.dgmFrameScene;
    }

    public void removeDiagramEditorFrameScene() {
        this.canvas.removeScene(this.dgmFrameScene);
        this.dgmFrameScene = null;
    }

    public GCanvas getCanvas() {
        return this.canvas;
    }

    public GCamera getCamera() {
        return this.camera;
    }

    @Override
    public void diagramViewChanged(DiagramViewEvent diagramViewEvent) {
        this.updateCanvas();
    }

    public void updateCanvas() {
        this.updateCamera();
        this.canvas.repaint(() -> {
            this.canvas.clear();
            this.canvas.draw();
            this.canvas.xor();
        });
    }

    public void updateCamera() {
        if (this.dve == null || !this.dve.isDiagramFrameReady()) {
            return;
        }
        double d2 = this.dve.getWidth();
        double d3 = this.canvas.getWidth();
        double d4 = this.dve.getHeight();
        double d5 = this.canvas.getHeight();
        double d6 = this.a(d3, d5, d2, d4);
        this.camera.setPosition(this.dve.getX() - (d3 - d2 * d6) / 2.0 / d6, this.dve.getY() - (d5 - d4 * d6) / 2.0 / d6);
        this.camera.setScale(d6);
    }

    private double a(double d2, double d3, double d4, double d5) {
        return Math.min(d2 / d4, d3 / d5);
    }

    public class MapPanelComponentListener
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MapPanel.this.updateCanvas();
        }
    }
}

