/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import net.astah.dd.di.Diagram;
import net.astah.emf.common.ecore.EObjects;
import net.astah.golf.control.ActionStateManager;
import net.astah.golf.control.DynamicMenuManager;
import net.astah.golf.control.GolfAction;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.GroupUIView;
import net.astah.golf.view.swing.UIViewPeer;
import net.astah.golf.widget.CDesktopPane;
import net.astah.golf.widget.CFrame;
import net.astah.golf.widget.CMenuBar;
import net.astah.golf.widget.CPanel;
import net.astah.golf.widget.CSplitPane;
import net.astah.golf.widget.CTabbedPane;
import net.astah.jmodel.Project;
import net.astah.jmodel.ProjectManager;
import net.astah.jmodel.editor.EditorAlignKeeper;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jutil.EncodeSupport;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.ExternalToolMenuUpdater;
import net.astah.jomt.jview.ManagementActions;
import net.astah.jomt.jview.ManagementViewPeer;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.RecentFileMenuUpdater;
import net.astah.jomt.jview.RecentTemplateMMFileMenuUpdater;
import net.astah.jomt.jview.ViewManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementView
extends GroupUIView
implements PropertyChangeListener {
    static final Logger a = LoggerFactory.getLogger(ManagementView.class);
    private ManagementActions b;
    private static ResourceBundleList c;
    private ActionStateManager d;
    private Project e;

    public ManagementView() {
        this.setSelect(false);
        c = PropertyManager.getManagementWindowResourceBundle();
        if (c == null) {
            MessageManager.displayAlertMessageDialog("app", "no_management_window_property.message");
            throw new RuntimeException("resource for ManagementView was not found.");
        }
        ((ManagementViewPeer)this.uiViewPeer).initialize();
    }

    public ManagementViewPeer getManagementViewPeer() {
        return (ManagementViewPeer)this.uiViewPeer;
    }

    public Point getWindowLocation() {
        return this.getManagementViewPeer().getWindowLocation();
    }

    public Dimension getWindowSize() {
        return this.getManagementViewPeer().getWindowSize();
    }

    public boolean isMaximized() {
        return this.getManagementViewPeer().isMaximized();
    }

    public void updateDiagramEditorAction(DiagramEditor diagramEditor) {
        if (ViewGlobal.isSilentMode) {
            return;
        }
        this.b.updateDiagramEditorAction(diagramEditor);
    }

    public void addEditorTab(Editor editor) {
        this.getManagementViewPeer().addEditorTab(editor);
    }

    public void removeEditorTab(Editor editor) {
        this.getManagementViewPeer().removeEditorTab(editor);
    }

    public Editor getEditor(int n2) {
        return this.getManagementViewPeer().getTabIndex(n2);
    }

    public void selectEditorTab(Editor editor, boolean bl) {
        this.getManagementViewPeer().selectEditorTab(editor, bl);
    }

    public void updateEditorTabTitle(Editor editor) {
        this.getManagementViewPeer().updateEditorTabTitle(editor);
    }

    public void updateLookAndFeel() {
        this.getManagementViewPeer().updateLookAndFeel();
    }

    public void setProjectActionStateInfo(Project project) {
        if (this.e == project) {
            return;
        }
        if (this.e != null) {
            this.e.removePropertyChangeListener(this.d);
            this.d = null;
            this.e.doc.removePropertyChangeListener("modified", this);
        }
        if (project != null) {
            this.d = this.b.getProjectActionStateManager(project);
            project.addPropertyChangeListener(this.d);
            project.doc.addPropertyChangeListener("modified", this);
        }
        this.e = project;
    }

    public void setViewManagerActionStateInfo(ViewManager viewManager) {
        ActionStateManager actionStateManager = this.b.getViewManagerActionStateManager(viewManager);
        viewManager.addPropertyChangeListener(actionStateManager);
        ActionStateManager actionStateManager2 = this.b.getNavigationManagerActionStateManager(viewManager.getNavigationManager());
        viewManager.getNavigationManager().addPropertyChangeListener(actionStateManager2);
    }

    public Action getAction(String string) {
        return this.b.getTable().get(string);
    }

    public void setPrjManagerActionStateInfo(ProjectManager projectManager) {
        ActionStateManager actionStateManager = this.b.getPrjManagerActionStateManager(projectManager);
        projectManager.addPropertyChangeListener(actionStateManager);
    }

    public void setPrjManagerDynamicMenuInfo(ProjectManager projectManager) {
        DynamicMenuManager dynamicMenuManager = this.getPrjManagerDynamicMenuManager(projectManager);
        projectManager.addPropertyChangeListener(dynamicMenuManager);
    }

    public void setDgmEditorActionStateInfo(DiagramEditor diagramEditor) {
        if (ViewGlobal.isSilentMode) {
            return;
        }
        if (EObjects.isReadOnly(diagramEditor.getDiagram())) {
            return;
        }
        ActionStateManager actionStateManager = this.b.getDgmEditorActionStateManager(diagramEditor);
        diagramEditor.addPropertyChangeListener(actionStateManager);
    }

    protected DynamicMenuManager getPrjManagerDynamicMenuManager(ProjectManager projectManager) {
        DynamicMenuManager dynamicMenuManager = new DynamicMenuManager();
        RecentFileMenuUpdater recentFileMenuUpdater = new RecentFileMenuUpdater();
        recentFileMenuUpdater.setInfo(projectManager, "recentFileName", null, null, null);
        dynamicMenuManager.addDynamicMenuInfo(recentFileMenuUpdater);
        RecentFileMenuUpdater recentFileMenuUpdater2 = new RecentFileMenuUpdater();
        recentFileMenuUpdater2.setInfo(projectManager, "recentFileDgm", null, null, null);
        dynamicMenuManager.addDynamicMenuInfo(recentFileMenuUpdater2);
        RecentTemplateMMFileMenuUpdater recentTemplateMMFileMenuUpdater = new RecentTemplateMMFileMenuUpdater();
        recentTemplateMMFileMenuUpdater.setInfo(projectManager, "recentTemplateMMFileName", null, null, null);
        dynamicMenuManager.addDynamicMenuInfo(recentTemplateMMFileMenuUpdater);
        ExternalToolMenuUpdater externalToolMenuUpdater = new ExternalToolMenuUpdater();
        externalToolMenuUpdater.setInfo(projectManager, "recentExternalToolKey", null, null, null);
        dynamicMenuManager.addDynamicMenuInfo(externalToolMenuUpdater);
        return dynamicMenuManager;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        GolfAction golfAction = new GolfAction("Quit");
        ActionEvent actionEvent = new ActionEvent(windowEvent.getSource(), windowEvent.getID(), "Quit");
        golfAction.actionPerformed(actionEvent);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        super.windowDeactivated(windowEvent);
        this.hidePopupMenus();
    }

    public void hidePopupMenus() {
        this.getManagementViewPeer().hidePopupMenus();
    }

    public CDesktopPane getDesktopPane() {
        return this.getManagementViewPeer().getDesktopPane();
    }

    public CTabbedPane getTabbedPane() {
        return this.getManagementViewPeer().getTabbedPane();
    }

    public CSplitPane getBaseSplitPane() {
        return this.getManagementViewPeer().getBaseSplitPane();
    }

    public CSplitPane getExtraSplitPane() {
        return this.getManagementViewPeer().getExtraSplitPane();
    }

    public void updateTitle() {
        CFrame cFrame = (CFrame)this.getComponent();
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        String string = resourceBundleList.getString("product.window.title");
        String string2 = RuntimeGlobal.sysProp.getDefaultString("product.version");
        if (string2.indexOf("b1") != -1 || string2.indexOf("b2") != -1 || string2.indexOf("b3") != -1) {
            string = string + " " + EncodeSupport.decodeReceived(RuntimeGlobal.sysProp.getDefaultString("basic.be"));
        }
        if (JomtGlobal.isOutOfEvaluation) {
            string = string + " " + EncodeSupport.decodeReceived(RuntimeGlobal.sysProp.getDefaultString("basic.o.ee"));
        } else if (JomtGlobal.isEvaluation) {
            string = string + " " + EncodeSupport.decodeReceived(RuntimeGlobal.sysProp.getDefaultString("basic.ee"));
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (this.e != null) {
            stringBuilder.append(" - ");
            if (this.e.isReadOnlyMode()) {
                stringBuilder.append(resourceBundleList.getString("project.read_only.label"));
                stringBuilder.append(" ");
            }
            String string3 = this.e.doc.getName();
            stringBuilder.append("[");
            stringBuilder.append(string3);
            stringBuilder.append("]");
            if (this.e.doc.isModified()) {
                stringBuilder.append(" (*)");
            }
        }
        if (cFrame != null) {
            cFrame.setTitle(stringBuilder.toString());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateTitle();
    }

    public CMenuBar getMenubar() {
        return this.getManagementViewPeer().getMenubar();
    }

    @Override
    public void remove() {
        this.getManagementViewPeer().setVible(false);
        super.remove();
        this.getManagementViewPeer().dispose();
    }

    public void changeStatusBar(boolean bl, String string, String string2, String string3, boolean bl2) {
    }

    public ManagementActions getActions() {
        return this.b;
    }

    public void setActions(ManagementActions managementActions) {
        this.b = managementActions;
    }

    public static ResourceBundleList getResources() {
        return c;
    }

    public static void setResources(ResourceBundleList resourceBundleList) {
        c = resourceBundleList;
    }

    @Override
    protected UIViewPeer createUIPeer() {
        ManagementViewPeer managementViewPeer = JomtGlobal.viewFactory.createManagementViewPeer();
        return managementViewPeer;
    }

    @Override
    public void activated() {
        super.activated();
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (diagramEditor == null) {
            return;
        }
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram == null) {
            return;
        }
        boolean bl = true;
        ViewGlobal.clipboard.firePropertyChange("isEntity", !bl, bl);
    }

    public void setMaximized(boolean bl) {
        this.getManagementViewPeer().setMaximized(bl);
    }

    public CPanel getEditorTabPanel() {
        return this.getManagementViewPeer().getEditorTabPanel();
    }

    public CPanel getEditorTabButtonPanel() {
        return this.getManagementViewPeer().getEditorTabButtonPanel();
    }

    public List<Editor> getAllEditors() {
        return this.getManagementViewPeer().getAllEditors();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        if (componentEvent.getSource() == this.getDesktopPane().getComponent()) {
            EditorAlignKeeper.INSTANCE.realign();
        }
    }
}

