/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.astah.dd.di.Diagram;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLCommunicationDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLSequenceDiagram;
import net.astah.jmodel.UMLStateChartDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.TableUtil;
import net.astah.jomt.jview.JomtComboBox;
import net.astah.jomt.jview.MMTopicToUMLModelKindConverter;
import net.astah.jomt.jview.NamespaceNameFactory;
import net.astah.jomt.jview.SwingCellEditor;
import net.astah.jomt.jview.p;
import net.astah.jomt.jview.q;
import net.astah.jomt.jview.r;
import net.astah.notation.mindmap.MMTopicShape;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;

public class MMTopicUMLConvertTable
extends JPanel {
    private static final long serialVersionUID = -6384946327085085387L;
    protected final String SELECT_HEADER = MMTopicUMLConvertTable.getTitle("projectview.table.header.mindmap_topic_uml_convert.select.label");
    protected final String PARENT_HEADER = MMTopicUMLConvertTable.getTitle("projectview.table.header.mindmap_topic_uml_convert.parent.label");
    protected final String NAME_HEADER = MMTopicUMLConvertTable.getTitle("projectview.table.header.mindmap_topic_uml_convert.name.label");
    protected final String KIND_HEADER = MMTopicUMLConvertTable.getTitle("projectview.table.header.mindmap_topic_uml_convert.kind.label");
    protected final String PACKAGE_HEADER = MMTopicUMLConvertTable.getTitle("projectview.table.header.mindmap_topic_uml_convert.package.label");
    protected DefaultTableModel tableModel;
    protected JTable table;
    protected JScrollPane scroller;
    private JomtComboBox<String> kindCombo;
    protected String[] columnNames;
    protected String[] formerPackage;
    protected List<String> kindList;
    protected List<MMTopicShape> topics;
    protected List<MMTopicShape> convertedTopics;
    protected List<String> convertedTopicsKinds;
    protected List<String> convertedTopicsPackages;

    public MMTopicUMLConvertTable(List<MMTopicShape> list) {
        this.formerPackage = new String[list.size()];
        this.columnNames = this.createColumnNames();
        this.topics = list;
        this.setLayout(new BorderLayout());
        this.initTableWithCheck();
        this.scroller = new JScrollPane(this.table);
        this.add((Component)this.scroller, "Center");
    }

    protected String[] createColumnNames() {
        return new String[]{this.SELECT_HEADER, this.PARENT_HEADER, this.NAME_HEADER, this.KIND_HEADER, this.PACKAGE_HEADER};
    }

    protected void initTableWithCheck() {
        this.initKindList();
        Object[][] objectArray = this.getAllValue(this.columnNames.length);
        this.tableModel = new DefaultTableModel(objectArray, this.columnNames){
            private static final long serialVersionUID = 5750993380003283012L;

            @Override
            public boolean isCellEditable(int n2, int n3) {
                int n4 = TableUtil.getColumnIndex(MMTopicUMLConvertTable.this.table, MMTopicUMLConvertTable.this.SELECT_HEADER);
                int n5 = TableUtil.getColumnIndex(MMTopicUMLConvertTable.this.table, MMTopicUMLConvertTable.this.KIND_HEADER);
                return n3 == n4 || n3 == n5;
            }

            @Override
            public Class<?> getColumnClass(int n2) {
                int n3 = this.findColumn(MMTopicUMLConvertTable.this.SELECT_HEADER);
                if (n2 == n3) {
                    return Boolean.class;
                }
                return Object.class;
            }
        };
        this.table = new AdjustedRowHeightTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.addTableMouseListener();
        this.a();
        this.setInitialWidth();
        this.b();
    }

    private void a() {
        this.kindCombo = new JomtComboBox();
        for (int i2 = 0; i2 < this.kindList.size(); ++i2) {
            this.kindCombo.addItem(this.kindList.get(i2));
        }
        SwingCellEditor swingCellEditor = new SwingCellEditor(this.kindCombo);
        TableColumn tableColumn = this.table.getColumn(this.KIND_HEADER);
        tableColumn.setCellEditor(swingCellEditor);
        this.kindCombo.addItemListener(new p(this));
    }

    protected boolean isPackageDisabled(String string) {
        return string.equalsIgnoreCase(MMTopicUMLConvertTable.getTitle("ui.mindmap_topic_uml_convert.activity.label")) || string.equalsIgnoreCase(MMTopicUMLConvertTable.getTitle("ui.mindmap_topic_uml_convert.state.label")) || string.equalsIgnoreCase(MMTopicUMLConvertTable.getTitle("ui.mindmap_topic_uml_convert.object.label")) || string.equalsIgnoreCase(MMTopicUMLConvertTable.getTitle("ui.mindmap_topic_uml_convert.lifeline.label")) || string.equalsIgnoreCase(MMTopicUMLConvertTable.getTitle("ui.mindmap_topic_uml_convert.processbox.label")) || string.equalsIgnoreCase(MMTopicUMLConvertTable.getTitle("ui.mindmap_topic_uml_convert.anchor.label")) || string.equalsIgnoreCase(MMTopicUMLConvertTable.getTitle("ui.mindmap_topic_uml_convert.note.label")) || string.equalsIgnoreCase(MMTopicUMLConvertTable.getTitle("ui.mindmap_topic_uml_convert.text.label"));
    }

    protected void initKindList() {
        Diagram diagram = JomtGlobal.viewManager.getCurrentDiagramEditor().getDiagram();
        if (!(diagram instanceof UMLDiagram)) {
            return;
        }
        this.kindList = (List)new q(this).doSwitch(diagram);
    }

    protected void setInitialWidth() {
        this.table.getColumn(this.SELECT_HEADER).setPreferredWidth(70);
        this.table.getColumn(this.PARENT_HEADER).setPreferredWidth(200);
        this.table.getColumn(this.NAME_HEADER).setPreferredWidth(200);
        this.table.getColumn(this.KIND_HEADER).setPreferredWidth(200);
        this.table.getColumn(this.PACKAGE_HEADER).setPreferredWidth(200);
    }

    private void b() {
        this.table.getColumn(this.SELECT_HEADER).setCellRenderer(new CheckBoxRenderer());
    }

    protected Object[][] getAllValue(int n2) {
        String string = this.getDiagramPackageNameString();
        Object[][] objectArray = null;
        if (this.topics != null) {
            objectArray = new Object[this.topics.size()][n2];
            for (int i2 = 0; i2 < this.topics.size(); ++i2) {
                int n3;
                MMTopicShape mMTopicShape = this.topics.get(i2);
                int n4 = 0;
                objectArray[i2][n4++] = Boolean.TRUE;
                objectArray[i2][n4++] = this.a(mMTopicShape);
                objectArray[i2][n4++] = mMTopicShape.getText();
                String string2 = "";
                String string3 = MMTopicToUMLModelKindConverter.getModelKind(mMTopicShape);
                string2 = string3 == null ? this.kindList.get(0) : ((n3 = this.kindList.indexOf(string3)) == -1 ? this.kindList.get(0) : this.kindList.get(n3));
                objectArray[i2][n4++] = string2;
                if (this.isPackageDisabled(string2)) {
                    objectArray[i2][n4++] = "";
                    this.formerPackage[i2] = "";
                    continue;
                }
                objectArray[i2][n4++] = string;
                this.formerPackage[i2] = string;
            }
        } else {
            objectArray = new Object[0][n2];
        }
        return objectArray;
    }

    protected String getDiagramPackageNameString() {
        Diagram diagram = JomtGlobal.viewManager.getCurrentDiagramEditor().getDiagram();
        if (!(diagram instanceof UMLDiagram)) {
            return null;
        }
        UMLDiagram uMLDiagram = (UMLDiagram)diagram;
        if (uMLDiagram instanceof UMLActivityDiagram || uMLDiagram instanceof UMLStateChartDiagram || uMLDiagram instanceof UMLSequenceDiagram || uMLDiagram instanceof UMLCommunicationDiagram) {
            return "";
        }
        EObject eObject = uMLDiagram.getParent();
        if (eObject instanceof Namespace && !(eObject instanceof Package)) {
            eObject = ((Namespace)eObject).getNearestPackage();
        }
        return NamespaceNameFactory.getNamespaceContainedName((Namespace)eObject);
    }

    private String a(MMTopicShape mMTopicShape) {
        if (mMTopicShape.isTop()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        MMTopicShape mMTopicShape2 = mMTopicShape.getParent();
        while (!mMTopicShape2.isTop()) {
            stringBuilder.insert(0, "::" + mMTopicShape2.getText());
            mMTopicShape2 = mMTopicShape2.getParent();
        }
        stringBuilder.insert(0, mMTopicShape2.getText());
        return stringBuilder.toString();
    }

    public void topicConvert() {
        int n2 = TableUtil.getColumnIndex(this.table, this.SELECT_HEADER);
        int n3 = TableUtil.getColumnIndex(this.table, this.KIND_HEADER);
        int n4 = TableUtil.getColumnIndex(this.table, this.PACKAGE_HEADER);
        this.convertedTopics = new ArrayList<MMTopicShape>();
        this.convertedTopicsKinds = new ArrayList<String>();
        this.convertedTopicsPackages = new ArrayList<String>();
        for (int i2 = 0; i2 < this.table.getRowCount(); ++i2) {
            if (!((Boolean)this.table.getValueAt(i2, n2)).booleanValue()) continue;
            this.convertedTopics.add(this.topics.get(i2));
            this.convertedTopicsKinds.add((String)this.table.getValueAt(i2, n3));
            this.convertedTopicsPackages.add((String)this.table.getValueAt(i2, n4));
        }
    }

    public List<MMTopicShape> getConvertedTopics() {
        return this.convertedTopics;
    }

    public List<String> getConvertedTopicsKinds() {
        return this.convertedTopicsKinds;
    }

    public List<String> getConvertedTopicsPackages() {
        return this.convertedTopicsPackages;
    }

    public boolean isConvertable() {
        return true;
    }

    protected static List<String> getComboContents(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = MMTopicUMLConvertTable.getTitle(string);
        String[] stringArray = string2 != null ? GolfUtilities.tokenize(string2, ",") : null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(MMTopicUMLConvertTable.getTitle(stringArray[i2] + ".label"));
        }
        return arrayList;
    }

    protected static String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    protected void addTableMouseListener() {
        this.table.addMouseListener(new r(this));
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 2649727373352632040L;

        CheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            this.setSelected((Boolean)object);
            this.setHorizontalAlignment(0);
            this.setBackground(Color.WHITE);
            return this;
        }
    }
}

