/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.MMTopicUMLConvertTable;
import net.astah.notation.mindmap.MMTopicShape;

public class MMTopicUMLConvertDialog
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = 4792522259503894632L;
    protected MMTopicUMLConvertTable mmTopicUMLConvertTable;
    protected JCheckBox copyToModelCheck;
    protected JCheckBox topicToModel;
    protected JCheckBox topicToDiagramElement;
    protected JCheckBox modelToTopic;
    protected String hyperlinkType;
    protected boolean copyHyperlinkToModel;
    protected boolean isTopicToModel;
    protected boolean isTopicToDiagramElement;
    protected boolean isModelToTopic;

    public MMTopicUMLConvertDialog(JFrame jFrame, List<MMTopicShape> list) {
        super((Frame)jFrame, true);
        this.initConvertTable(list);
        this.initPanel(list);
    }

    protected void initPanel(List<MMTopicShape> list) {
        this.mmTopicUMLConvertTable.setPreferredSize(new Dimension(500, 150));
        JPanel jPanel = this.a(this.a(list));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.mmTopicUMLConvertTable, "Center");
        jPanel2.add((Component)jPanel, "South");
        JPanel jPanel3 = this.createButtonPanel();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add("Center", jPanel2);
        jPanel4.add("South", jPanel3);
        this.getContentPane().add(jPanel4);
        this.setTitle(this.getDialogTitle());
        this.pack();
    }

    private boolean a(List<MMTopicShape> list) {
        return false;
    }

    private JPanel a(boolean bl) {
        this.createTopicToModel(bl);
        this.createTopicToDiagramElement(bl);
        this.createModelToTopic();
        JPanel jPanel = new JPanel(this.createHyperlinkPanelLayout());
        this.addTopicToModel(jPanel);
        this.addTopicToDiagramElement(jPanel);
        this.addModelToTopic(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.GRAY), null);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(compoundBorder, MMTopicUMLConvertDialog.getTitle("ui.mindmap_topic_uml_convert_dialog.group.hyperlink.label"));
        jPanel2.setBorder(titledBorder);
        return jPanel2;
    }

    protected JPanel createButtonPanel() {
        this.copyToModelCheck = new JCheckBox(this.getCopyToModelCheckLabel());
        this.copyToModelCheck.setActionCommand("CopyToModel");
        this.copyToModelCheck.addActionListener(this);
        this.copyToModelCheck.setSelected(RuntimeGlobal.sysProp.getBooleanWithDefault("convert_model.copy_link_source_to_target_model"));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(MMTopicUMLConvertDialog.getTitle("projectview.button.ok.label"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(MMTopicUMLConvertDialog.getTitle("projectview.button.cancel.label"));
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.copyToModelCheck, "West");
        jPanel2.add((Component)jPanel, "East");
        return jPanel2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.mmTopicUMLConvertTable.topicConvert();
            this.getSelected();
            if (this.mmTopicUMLConvertTable.isConvertable()) {
                this.dispose();
            }
            if (this.topicToModel != null) {
                RuntimeGlobal.sysProp.setBoolean("convert_model.link_source_to_target_model", this.topicToModel.isSelected());
            }
            if (this.topicToDiagramElement != null) {
                RuntimeGlobal.sysProp.setBoolean("convert_model.link_source_to_target_element", this.topicToDiagramElement.isSelected());
            }
            if (this.modelToTopic != null) {
                RuntimeGlobal.sysProp.setBoolean("convert_model.link_target_to_source_model", this.modelToTopic.isSelected());
            }
            if (this.copyToModelCheck != null) {
                RuntimeGlobal.sysProp.setBoolean("convert_model.copy_link_source_to_target_model", this.copyToModelCheck.isSelected());
            }
            RuntimeGlobal.sysProp.store();
        } else if (actionEvent.getActionCommand().equals("CANCEL")) {
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("CopyToModel")) {
            this.copyHyperlinkToModel = this.copyToModelCheck.isSelected();
        } else {
            this.dispose();
        }
    }

    public List<MMTopicShape> getConvertedTopics() {
        return this.mmTopicUMLConvertTable.getConvertedTopics();
    }

    public List<String> getConvertedTopicsKinds() {
        return this.mmTopicUMLConvertTable.getConvertedTopicsKinds();
    }

    public List<String> getConvertedTopicsPackages() {
        return this.mmTopicUMLConvertTable.getConvertedTopicsPackages();
    }

    public String getHyperlinkType() {
        return this.hyperlinkType;
    }

    public boolean isCopyHyperlinkToModel() {
        return this.copyHyperlinkToModel;
    }

    protected static String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public boolean isModelToTopic() {
        return this.isModelToTopic;
    }

    public boolean isTopicToDiagramElement() {
        return this.isTopicToDiagramElement;
    }

    public boolean isTopicToModel() {
        return this.isTopicToModel;
    }

    protected String getDialogTitle() {
        return MMTopicUMLConvertDialog.getTitle("ui.mindmap_topic_uml_convert_dialog.title");
    }

    protected String getModelToTopicLabel() {
        return MMTopicUMLConvertDialog.getTitle("ui.mindmap_topic_uml_convert_dialog.button.model_to_topic.label");
    }

    protected String getTopicToDiagramElementLabel() {
        return MMTopicUMLConvertDialog.getTitle("ui.mindmap_topic_uml_convert_dialog.button.topic_to_diagram_element.label");
    }

    protected String getTopicToModelLabel() {
        return MMTopicUMLConvertDialog.getTitle("ui.mindmap_topic_uml_convert_dialog.button.topic_to_model.label");
    }

    protected void initConvertTable(List<MMTopicShape> list) {
        this.mmTopicUMLConvertTable = new MMTopicUMLConvertTable(list);
    }

    protected void setMmTopicUMLConvertTable(MMTopicUMLConvertTable mMTopicUMLConvertTable) {
        this.mmTopicUMLConvertTable = mMTopicUMLConvertTable;
    }

    protected void addModelToTopic(JPanel jPanel) {
        jPanel.add(this.modelToTopic);
    }

    protected void addTopicToDiagramElement(JPanel jPanel) {
        jPanel.add(this.topicToDiagramElement);
    }

    protected void createModelToTopic() {
        this.modelToTopic = new JCheckBox(this.getModelToTopicLabel());
        this.modelToTopic.setSelected(RuntimeGlobal.sysProp.getBooleanWithDefault("convert_model.link_target_to_source_model"));
    }

    protected void createTopicToDiagramElement(boolean bl) {
        this.topicToDiagramElement = new JCheckBox(this.getTopicToDiagramElementLabel());
        this.topicToDiagramElement.setEnabled(!bl);
        this.topicToDiagramElement.setSelected(RuntimeGlobal.sysProp.getBooleanWithDefault("convert_model.link_source_to_target_element"));
    }

    protected GridLayout createHyperlinkPanelLayout() {
        return new GridLayout(3, 0);
    }

    protected void addTopicToModel(JPanel jPanel) {
        jPanel.add(this.topicToModel);
    }

    protected void createTopicToModel(boolean bl) {
        this.topicToModel = new JCheckBox(this.getTopicToModelLabel());
        this.topicToModel.setSelected(!bl && RuntimeGlobal.sysProp.getBooleanWithDefault("convert_model.link_source_to_target_model"));
        this.topicToModel.setEnabled(!bl);
    }

    protected String getCopyToModelCheckLabel() {
        return MMTopicUMLConvertDialog.getTitle("ui.mindmap_topic_uml_convert_dialog.button.copy_hyperlink_to_model.label");
    }

    protected void getSelected() {
        this.isTopicToModel = this.topicToModel.isSelected();
        this.isTopicToDiagramElement = this.topicToDiagramElement.isSelected();
        this.isModelToTopic = this.modelToTopic.isSelected();
        this.copyHyperlinkToModel = this.copyToModelCheck.isSelected();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.dispose();
        }
    }
}

