/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.dnd.DropTarget;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.JomtTreeNode;
import net.astah.jomt.jview.ProjectTreeCellRenderer;
import net.astah.jomt.jview.swing.SwingJomtTreeUIViewPeer;
import org.eclipse.emf.ecore.EObject;

public class JomtTree
extends JTree
implements TreeModelListener {
    private static final long serialVersionUID = -4113019736737374659L;
    public static final int WHENEVER = 0;
    public static final int LEVEL = 1;
    public static final int NOEXPAND = 2;
    public static final int LEAVE = 3;
    private TreePath fullPath;
    public static final int SHOW_NAME = 0;
    public static final int SHOW_NAME_ID = 1;
    public static final int SHOW_ID = 2;
    private int nameIDVisibility = 0;
    private boolean isFromPrj = false;
    private boolean isPhysicalModel = false;
    private int expandMode = 0;
    private int expandNodeLevel = 0;

    public void setIsFromPrj(boolean bl) {
        this.isFromPrj = bl;
    }

    public void setExpandMode(int n2) {
        this.expandMode = n2;
    }

    public int getExpandMode() {
        return this.expandMode;
    }

    public void setExpandNodeLevel(int n2) {
        this.expandNodeLevel = n2;
        this.expandMode = 1;
    }

    public int getExpandNodeLevel() {
        return this.expandNodeLevel;
    }

    public JomtTree() {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("view.tree.show_name");
        boolean bl2 = RuntimeGlobal.sysProp.getBooleanWithDefault("view.tree.show_id");
        if (bl && bl2) {
            this.setNameIDVisibility(1);
        } else if (bl2) {
            this.setNameIDVisibility(2);
        } else {
            this.setNameIDVisibility(0);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (JomtGlobal.commandSupport.getIsFromPrjCommand()) {
            this.requestFocus();
        }
        if (this.isFromPrj) {
            this.clearSelection();
            this.setSelectionPath(this.fullPath);
            this.setEditable(true);
            this.startEditingAtPath(this.fullPath);
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        switch (this.expandMode) {
            case 1: {
                JomtTreeNode jomtTreeNode = (JomtTreeNode)treePath.getLastPathComponent();
                if (jomtTreeNode.getLevel() <= this.expandNodeLevel) {
                    this.expandPath(treePath);
                    break;
                }
                return;
            }
            case 2: {
                if (this.isCollapsed(treePath)) break;
                this.collapsePath(treePath);
                break;
            }
            case 3: {
                this.scrollToCurrentNode(treeModelEvent);
                break;
            }
            default: {
                if (RuntimeGlobal.sysProp.getBooleanWithDefault("basic.control_expansion_of_structure_tree")) {
                    this.expandPath(treePath);
                    this.scrollToCurrentNode(treeModelEvent);
                    break;
                }
                if (this.isCollapsed(treePath)) {
                    this.fullPath = null;
                    break;
                }
                this.scrollToCurrentNode(treeModelEvent);
            }
        }
    }

    protected void scrollToCurrentNode(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray[0] != null) {
            this.fullPath = treePath.pathByAddingChild(objectArray[0]);
            this.scrollPathToVisible(this.fullPath);
            this.clearSelection();
            if (this.isFromPrj) {
                this.setSelectionPath(this.fullPath);
                this.setEditable(true);
                this.startEditingAtPath(this.fullPath);
            }
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public void remove() {
        DropTarget dropTarget = this.getDropTarget();
        if (dropTarget != null) {
            this.setDropTarget(null);
        }
        this.setModel(null);
        this.setSelectionModel(null);
        this.setCellEditor(null);
        this.setCellRenderer(null);
        this.listenerList = null;
    }

    public void setNameIDVisibility(int n2) {
        this.nameIDVisibility = n2;
    }

    public int getNameIDVisibility() {
        return this.nameIDVisibility;
    }

    @Override
    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        ProjectTreeCellRenderer projectTreeCellRenderer = null;
        if (treeCellRenderer != null && treeCellRenderer instanceof ProjectTreeCellRenderer) {
            projectTreeCellRenderer = (ProjectTreeCellRenderer)treeCellRenderer;
        }
        String string = null;
        string = projectTreeCellRenderer != null && projectTreeCellRenderer.isIDVisible() && object instanceof JomtTreeNode && (((JomtTreeNode)object).getModelType().equals("usecase") || ((JomtTreeNode)object).getModelType().equals("class")) ? this.handleShowString(object) : super.convertValueToText(object, bl, bl2, bl3, n2, bl4);
        return string;
    }

    protected String handleShowString(Object object) {
        UserObject userObject = (UserObject)((JomtTreeNode)object).getUserObject();
        EObject eObject = userObject.getModel();
        if (this.nameIDVisibility == 0) {
            return object.toString();
        }
        if (this.nameIDVisibility == 1) {
            return this.a(userObject) + ":" + eObject.toString();
        }
        if (this.nameIDVisibility == 2) {
            return this.a(userObject);
        }
        return null;
    }

    private String a(UserObject userObject) {
        throw new UnsupportedOperationException("\u672a\u5bfe\u5fdc");
    }

    public boolean isPhysicalModel() {
        return this.isPhysicalModel;
    }

    public void setPhysicalModel(boolean bl) {
        this.isPhysicalModel = bl;
    }

    @Override
    public void updateUI() {
        TreeCellRenderer treeCellRenderer;
        Object object;
        super.updateUI();
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i2 = 0; i2 < mouseListenerArray.length; ++i2) {
            object = mouseListenerArray[i2];
            if (!(object instanceof SwingJomtTreeUIViewPeer)) continue;
            this.removeMouseListener((MouseListener)object);
            this.addMouseListener((MouseListener)object);
            break;
        }
        if ((treeCellRenderer = this.getCellRenderer()) instanceof DefaultTreeCellRenderer) {
            object = (DefaultTreeCellRenderer)treeCellRenderer;
            ((DefaultTreeCellRenderer)object).setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
            ((DefaultTreeCellRenderer)object).setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
            ((DefaultTreeCellRenderer)object).setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        }
    }
}

