/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.astah.dd.di.Diagram;
import net.astah.golf.model.IEntityRoot;
import net.astah.golf.util.CancelException;
import net.astah.golf.util.NonCompatibleException;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.swing.AdjustToggleButtonSizeFileChooser;
import net.astah.jmodel.Project;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jomt.jcontrol.JudeToPngForPreviewCommand;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.Localizer;
import net.astah.jomt.jutil.TemplateUtilities;
import net.astah.jomt.jview.ImagePreview;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.mindmap.MMDiagram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JomtPreviewFileChooser
extends AdjustToggleButtonSizeFileChooser {
    private static final long serialVersionUID = -622238918263373834L;
    private static final double a = 0.4;
    private BufferedImage exportedImage;
    private JDialog tempDialog;
    private Class<? extends Diagram> diagramClass;
    private boolean isFlowChart = false;
    private boolean isDFD = false;
    private JPanel preview = new JPanel(new BorderLayout());
    private JPanel previewNorth = new JPanel(new GridLayout(2, 1));
    private JLabel previewMSG = new JLabel();
    private ImagePreview previewBase = new ImagePreview(this);
    private JCheckBox previewCheckBox = new JCheckBox(PropertyManager.getProjectViewResourceBundle().getString("ui.preview.dialog.show_preview_option.label"));
    private static final Logger b = LoggerFactory.getLogger(JomtPreviewFileChooser.class);

    public JomtPreviewFileChooser(String string) {
        super(string);
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        JDialog jDialog;
        this.a();
        this.setAccessory(this.preview);
        this.tempDialog = jDialog = super.createDialog(component);
        return jDialog;
    }

    private void a() {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("ui.template_preview.group.show_preview_area");
        this.previewCheckBox.setActionCommand("showOrHidePreview");
        this.previewCheckBox.setSelected(bl);
        this.previewCheckBox.addItemListener(new CheckBoxListener(this));
        this.preview.add((Component)this.previewCheckBox, "North");
        this.previewMSG.setText(Localizer.getMessage("app", "preview_selection_jude.message"));
        this.previewNorth.add(this.previewCheckBox);
        this.previewNorth.add(this.previewMSG);
        this.previewBase.setVisible(bl);
        this.a(this.previewBase);
        this.preview.add((Component)this.previewNorth, "North");
        this.preview.add((Component)this.previewBase, "Center");
    }

    @Override
    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, n5);
        this.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        if (this.tempDialog != null && this.previewCheckBox.isSelected()) {
            Dimension dimension = this.tempDialog.getSize();
            b.debug("Dialog Size={}", dimension);
            double d2 = dimension.getHeight() * 0.4;
            double d3 = dimension.getWidth() * 0.4;
            Dimension dimension2 = new Dimension((int)d3, (int)d2);
            b.debug("newPreviewArea={}]", dimension2);
            this.preview.setPreferredSize(dimension2);
            this.preview.setMinimumSize(dimension2);
            this.preview.setMaximumSize(dimension2);
            Object object = this.getTreeLock();
            synchronized (object) {
                this.invalidate();
                this.doLayout();
                this.validateTree();
            }
            this.tempDialog.invalidate();
            this.tempDialog.doLayout();
            this.previewBase.loadImage();
            this.previewBase.repaint();
        } else if (!this.previewCheckBox.isSelected()) {
            Dimension dimension = this.previewNorth.getPreferredSize();
            b.debug("Preview-OFF: size = {}", dimension);
            this.preview.setPreferredSize(dimension);
            this.preview.setMinimumSize(dimension);
            this.preview.setMaximumSize(dimension);
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
                this.doLayout();
            }
        }
        if (this.tempDialog != null) {
            this.tempDialog.repaint();
        }
    }

    @Override
    public void setSelectedFile(File file) {
        File file2 = this.getSelectedFile();
        File file3 = file;
        Container container = this.tempDialog.getContentPane();
        if (this.previewCheckBox.isSelected()) {
            if (file3 == null) {
                if (container != null) {
                    this.previewMSG.setText(Localizer.getMessage("app", "preview_open_fail.message"));
                    this.previewMSG.setVisible(this.previewCheckBox.isSelected());
                    this.previewBase.setExportedImage(null);
                    this.previewBase.setVisible(this.previewCheckBox.isSelected());
                    this.exportedImage = null;
                }
            } else if (!file3.equals(file2) && container != null) {
                this.a(file);
            }
        }
        super.setSelectedFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(File file) {
        this.exportedImage = this.b(file);
        if (this.exportedImage != null) {
            this.previewMSG.setText("");
            this.previewMSG.setVisible(this.previewCheckBox.isSelected());
            this.previewBase.setExportedImage(this.exportedImage);
            this.previewBase.setVisible(this.previewCheckBox.isSelected());
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
                this.doLayout();
            }
            this.previewBase.loadImage();
            this.previewBase.repaint();
        } else {
            if (UMLActivityDiagram.class.equals(this.diagramClass)) {
                if (this.isFlowChart) {
                    this.previewMSG.setText(Localizer.getMessage("app", "preview_no_flow_chart.message"));
                } else if (this.isDFD) {
                    this.previewMSG.setText(Localizer.getMessage("app", "preview_no_dfd.message"));
                } else {
                    this.previewMSG.setText(Localizer.getMessage("app", "preview_no_activity.message"));
                }
            } else if (MMDiagram.class.equals(this.diagramClass)) {
                this.previewMSG.setText(Localizer.getMessage("app", "preview_no_mindmap.message"));
            }
            this.previewMSG.setVisible(this.previewCheckBox.isSelected());
            this.previewBase.setExportedImage(null);
            this.previewBase.setVisible(this.previewCheckBox.isSelected());
        }
    }

    private synchronized BufferedImage b(File file) {
        Project project = null;
        try {
            project = TemplateUtilities.createReferenceProject(file, true);
        }
        catch (CancelException cancelException) {
            MessageManager.displayErrorMessage("app", "tell_open_fail.message");
            return null;
        }
        catch (NonCompatibleException nonCompatibleException) {
            MessageManager.displayErrorMessage("app", "noncompatible_model_error.message");
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageManager.displayErrorMessage("app", "tell_open_fail.message");
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MessageManager.displayErrorMessage("app", "out_of_memory.message");
        }
        catch (StackOverflowError stackOverflowError) {
            MessageManager.displayErrorMessage("app", "stack_overflow_error.message");
        }
        catch (Error error) {
            MessageManager.requireBugReport(error);
        }
        if (project == null || project.doc == null) {
            return null;
        }
        IEntityRoot iEntityRoot = project.doc.getRoot();
        Diagram diagram = TemplateUtilities.getFirstDiagram(iEntityRoot, this.diagramClass, this.isFlowChart, this.isDFD);
        if (diagram == null) {
            return null;
        }
        JudeToPngForPreviewCommand judeToPngForPreviewCommand = new JudeToPngForPreviewCommand();
        judeToPngForPreviewCommand.setArgumentString("preview");
        judeToPngForPreviewCommand.setDiagrams(Arrays.asList(diagram));
        judeToPngForPreviewCommand.execute();
        BufferedImage bufferedImage = judeToPngForPreviewCommand.getExportedImage();
        return bufferedImage;
    }

    private void a(JComponent jComponent) {
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        String string = PropertyManager.getProjectViewResourceBundle().getString("ui.preview.dialog.title");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(compoundBorder, string);
        jComponent.setBorder(titledBorder);
    }

    @Override
    protected void fireActionPerformed(String string) {
        super.fireActionPerformed(string);
        if ("ApproveSelection".equals(string) || "CancelSelection".equals(string)) {
            RuntimeGlobal.sysProp.setBoolean("ui.template_preview.group.show_preview_area", this.previewCheckBox.isSelected());
        }
    }

    public void setDiagramClass(Class<? extends Diagram> clazz) {
        this.diagramClass = clazz;
    }

    public void setFlowChart(boolean bl) {
        this.isFlowChart = bl;
    }

    public void setDFD(boolean bl) {
        this.isDFD = bl;
    }

    protected class CheckBoxListener
    implements ItemListener,
    PropertyChangeListener {
        private File b = null;

        public CheckBoxListener(JFileChooser jFileChooser) {
            jFileChooser.addPropertyChangeListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == JomtPreviewFileChooser.this.previewCheckBox) {
                if (JomtPreviewFileChooser.this.previewCheckBox.isSelected()) {
                    JomtPreviewFileChooser.this.previewBase.setVisible(true);
                    JomtPreviewFileChooser.this.previewMSG.setVisible(true);
                    JomtPreviewFileChooser.this.b();
                    JomtPreviewFileChooser.this.a(this.b);
                } else {
                    JomtPreviewFileChooser.this.previewBase.setVisible(false);
                    JomtPreviewFileChooser.this.previewMSG.setVisible(false);
                    JomtPreviewFileChooser.this.b();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("directoryChanged".equals(string)) {
                this.b = null;
            } else if ("SelectedFileChangedProperty".equals(string)) {
                this.b = (File)propertyChangeEvent.getNewValue();
            }
        }
    }
}

