/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = -3536899994285319336L;
    private static final int a = 10;
    private File file = null;
    private ImageIcon imageIcon = null;
    private Image exportedImage;
    JFileChooser fc;
    private static final Logger b = LoggerFactory.getLogger(ImagePreview.class);

    public void setImageIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    public void setExportedImage(Image image) {
        this.exportedImage = image;
    }

    public ImagePreview(JFileChooser jFileChooser) {
        this.fc = jFileChooser;
        jFileChooser.addPropertyChangeListener(this);
    }

    @Override
    public void reshape(int n2, int n3, int n4, int n5) {
        this.loadImage();
        super.reshape(n2, n3, n4, n5);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        if ("directoryChanged".equals(string)) {
            this.file = null;
            bl = true;
        } else if ("SelectedFileChangedProperty".equals(string)) {
            this.file = (File)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (bl) {
            this.imageIcon = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    public void loadImage() {
        if (this.file == null || this.exportedImage == null) {
            this.imageIcon = null;
            return;
        }
        b.trace("ImagePreview loadImage()");
        ImageIcon imageIcon = new ImageIcon(this.exportedImage, "");
        Dimension dimension = this.getSize();
        b.debug("size={}", dimension);
        if ((double)(imageIcon.getIconWidth() + 20) > dimension.getWidth()) {
            imageIcon.setImage(imageIcon.getImage().getScaledInstance((int)dimension.getWidth() - 20, -1, 4));
        }
        if ((double)(imageIcon.getIconHeight() + 20) > dimension.getHeight()) {
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(-1, (int)dimension.getHeight() - 20, 4));
        }
        this.imageIcon = imageIcon;
        b.debug("[w={}][h={}]", this.imageIcon.getIconWidth(), (Object)this.imageIcon.getIconHeight());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.imageIcon == null) {
            this.loadImage();
        }
        if (this.imageIcon != null) {
            int n2 = this.getWidth() / 2 - this.imageIcon.getIconWidth() / 2;
            int n3 = this.getHeight() / 2 - this.imageIcon.getIconHeight() / 2;
            if (n3 < 10) {
                n3 = 10;
            }
            if (n2 < 10) {
                n2 = 10;
            }
            this.imageIcon.paintIcon(this, graphics, n2, n3);
            b.debug("[x={}][y={}]", n2, (Object)n3);
        }
    }
}

