/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.lang.reflect.Constructor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.tree.TreeNode;
import net.astah.golf.control.GolfAction;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.CustomerSplitPane;
import net.astah.golf.widget.CFrame;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.golf.widget.swing.SwingSplitPane;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.PathUtil;
import net.astah.jomt.jview.CommonDialog;
import net.astah.jomt.jview.HierarchyTreeModel;
import net.astah.jomt.jview.JomtTree;
import net.astah.jomt.jview.JomtTreeNode;
import net.astah.jomt.jview.JomtTreeUIView;
import net.astah.jomt.jview.ProjectTreeCellRenderer;
import net.astah.jomt.jview.ProjectTreeModel;
import net.astah.jomt.jview.ProjectView;
import net.astah.jomt.jview.swing.b;
import net.astah.jomt.jview.swing.r;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyView
extends JomtTreeUIView {
    protected JToggleButton synchBtn;
    protected JButton filterButton;
    private HierarchyTreeModel a = null;
    private FlowLayout b = new FlowLayout(2, 0, 0);
    private static final Logger c = LoggerFactory.getLogger(HierarchyView.class);

    public HierarchyView(ProjectView projectView, IEntityStore iEntityStore) {
        super(iEntityStore);
        this.initialize(projectView, iEntityStore);
    }

    protected void initialize(ProjectView projectView, IEntityStore iEntityStore) {
        Object[] objectArray;
        JomtTree jomtTree = new JomtTree();
        jomtTree.setName("projectview.hierarchyview");
        jomtTree.setCellRenderer(new ProjectTreeCellRenderer());
        r r2 = new r(jomtTree);
        JomtTreeNode jomtTreeNode = new JomtTreeNode();
        jomtTreeNode.setModelType("package");
        jomtTreeNode.setUserObject(new UserObject(EntityAccessor.getProjectModel(iEntityStore)));
        ProjectTreeModel.updateProjectName(iEntityStore.getName());
        String string = PropertyManager.getJudeResourceBundle().getString("jude.hierarchy_view_tree_model");
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        try {
            objectArray = new Class[]{TreeNode.class};
            clazz = Class.forName(string);
            constructor = clazz.getConstructor((Class<?>[])objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            c.error("error has occurred.", classNotFoundException);
        }
        catch (SecurityException securityException) {
            c.error("error has occurred.", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            c.error("error has occurred.", noSuchMethodException);
        }
        objectArray = new Object[]{jomtTreeNode};
        try {
            if (constructor != null) {
                this.a = (HierarchyTreeModel)constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.a == null) {
            return;
        }
        this.a.addTreeModelListener(jomtTree);
        jomtTree.setModel(this.a);
        jomtTree.setAutoscrolls(true);
        this.addComponent(r2);
        this.setTreeModel(this.a);
        if (PropertyManager.getTarget().equals("J")) {
            JScrollPane jScrollPane = new JScrollPane(jomtTree);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jScrollPane, "Center");
            this.setBaseComponent(new SwingComponent(jPanel));
        } else {
            CustomerSplitPane customerSplitPane = this.createSplitPane(jomtTree, projectView);
            this.setBaseComponent(new SwingSplitPane(customerSplitPane));
        }
    }

    protected void addFilterButton(JToolBar jToolBar, ProjectView projectView) {
        this.filterButton = new JButton();
        this.filterButton.addActionListener(projectView);
        this.filterButton.setActionCommand("HIERARCHY_FILTER");
        ImageIcon imageIcon = PathUtil.getIcon(this.getResourceString("projectview.button.alias.filter.image"));
        this.filterButton.setIcon(imageIcon);
        this.filterButton.setToolTipText(HierarchyView.getTitle("projectview.alias.filter_button.label"));
        jToolBar.add(this.filterButton);
    }

    @Override
    public String getViewTitle() {
        return this.getResourceString("hierarchyview.view.hierarchy.label");
    }

    @Override
    public String getViewDescription() {
        return this.getResourceString("hierarchyview.view.hierarchy.tooltip");
    }

    protected static String getTitle(String string) {
        return PropertyManager.getProjectViewResourceBundle().getString(string);
    }

    protected CustomerSplitPane createSplitPane(JomtTree jomtTree, ProjectView projectView) {
        JScrollPane jScrollPane = new JScrollPane(jomtTree);
        Component component = this.a(projectView);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(component, "Center");
        jPanel.setMinimumSize(new Dimension(0, 0));
        CustomerSplitPane customerSplitPane = new CustomerSplitPane();
        customerSplitPane.setOrientation(0);
        customerSplitPane.setDividerLocation(0.0);
        customerSplitPane.setRightComponent(jScrollPane);
        customerSplitPane.setLeftComponent(jPanel);
        customerSplitPane.setOneTouchExpandable(true);
        customerSplitPane.setEnabled(false);
        customerSplitPane.setDividerSize(8);
        return customerSplitPane;
    }

    private Component a(ProjectView projectView) {
        JToolBar jToolBar = this.a();
        this.a(jToolBar);
        this.addFilterButton(jToolBar, projectView);
        return jToolBar;
    }

    private JToolBar a() {
        JToolBar jToolBar = new JToolBar(){
            private static final long serialVersionUID = 6375020300057705732L;

            @Override
            public void updateUI() {
                this.setUI((ToolBarUI)UIManager.getUI(this));
                if (this.getLayout() == null) {
                    HierarchyView.this.b.setHgap(0);
                    HierarchyView.this.b.setVgap(0);
                    this.setLayout(HierarchyView.this.b);
                }
                this.invalidate();
            }
        };
        jToolBar.setLayout(this.b);
        jToolBar.setFloatable(false);
        jToolBar.setBorder(null);
        return jToolBar;
    }

    private void a(JToolBar jToolBar) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.structure_tree_sync_with_diagram_selection");
        ImageIcon imageIcon = PathUtil.getIcon(this.getResourceString("projectview.button.sync_aliasview_with_diagram_selection.image"));
        this.synchBtn = new JToggleButton(imageIcon, bl);
        this.synchBtn.setToolTipText(this.getResourceString("projectview.view.sync_aliasview_with_diagram_selection.label"));
        this.synchBtn.addActionListener(new GolfAction("SynchronizeDiagramEditor"));
        jToolBar.add(this.synchBtn);
    }

    protected String getResourceString(String string) {
        return PropertyManager.getProjectViewResourceBundle().getString(string);
    }

    public static boolean openFilterDialog() {
        CFrame cFrame = (CFrame)JomtGlobal.viewManager.getManagementView().getComponent();
        CommonDialog commonDialog = JomtWidgetFactory.instance().createHierarchyFilterDiagramDialog(cFrame);
        commonDialog.open();
        int n2 = ((b)commonDialog).a();
        return n2 == 1;
    }

    public HierarchyTreeModel getHierarchyTreeModel() {
        return this.a;
    }

    public void setSynchBtnStatus(boolean bl) {
        this.synchBtn.setSelected(bl);
    }
}

