/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jomt.jview.SortableTable;
import net.astah.swing.SortableTableModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;

public class HiddenRelationsTable
extends SortableTable {
    private static final long serialVersionUID = 8329021772787542462L;
    protected static final String TYPE_HEADER = HiddenRelationsTable.getTitle("projectview.table.header.type.label");
    protected static final String VISIBILITY_HEADER = HiddenRelationsTable.getTitle("projectview.table.header.visibility.label");
    protected static final String FROM_HEADER = HiddenRelationsTable.getTitle("projectview.table.header.from.label");
    protected static final String TO_HEADER = HiddenRelationsTable.getTitle("projectview.table.header.to.label");
    protected static final String ROLE_HEADER = HiddenRelationsTable.getTitle("projectview.table.header.role.label");
    protected List<Element> relatedModels = null;
    boolean isER = false;

    public HiddenRelationsTable(List<Element> list, boolean bl) {
        this.relatedModels = list;
        this.isER = bl;
        this.updateNameHeaderStr();
        this.setLayout(new BorderLayout());
        this.initAttributeTable();
        this.scroller = new JScrollPane(this.table);
        this.add(this.scroller);
    }

    protected Classifier getClassifierModel(ClassifierPresentation classifierPresentation) {
        EObject eObject = classifierPresentation.getModel();
        if (!(eObject instanceof Classifier)) {
            return null;
        }
        return (Classifier)eObject;
    }

    protected void initAttributeTable() {
        if (this.isER) {
            this.columnNames = new String[5];
            this.columnNames[0] = "C";
            this.columnNames[1] = TYPE_HEADER;
            this.columnNames[2] = FROM_HEADER;
            this.columnNames[3] = this.NAME_HEADER;
            this.columnNames[4] = TO_HEADER;
        } else {
            this.columnNames = new String[7];
            this.columnNames[0] = "C";
            this.columnNames[1] = TYPE_HEADER;
            this.columnNames[2] = FROM_HEADER;
            this.columnNames[3] = ROLE_HEADER;
            this.columnNames[4] = this.NAME_HEADER;
            this.columnNames[5] = ROLE_HEADER;
            this.columnNames[6] = TO_HEADER;
        }
        Object[][] objectArray = this.getAllRelationValue(this.columnNames.length);
        this.tableModel = new SortableTableModel(objectArray, this.columnNames);
        this.table = new AdjustedRowHeightTable(this.tableModel){

            @Override
            public TableCellRenderer getCellRenderer(int n2, int n3) {
                if (n3 == 4) {
                    return new ElementRenderer();
                }
                return super.getCellRenderer(n2, n3);
            }
        };
        this.table.setShowGrid(true);
        this.table.getColumnModel().setColumnMargin(0);
        if (this.isER) {
            this.table.getColumn("C").setMaxWidth(30);
            this.table.getColumn(TYPE_HEADER).setPreferredWidth(70);
            this.table.getColumn(FROM_HEADER).setPreferredWidth(80);
            this.table.getColumn(this.NAME_HEADER).setPreferredWidth(100);
            this.table.getColumn(TO_HEADER).setPreferredWidth(80);
        } else {
            this.table.getColumn("C").setMaxWidth(30);
            this.table.getColumn(TYPE_HEADER).setPreferredWidth(70);
            this.table.getColumn(FROM_HEADER).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(30);
            this.table.getColumn(this.NAME_HEADER).setPreferredWidth(120);
            this.table.getColumnModel().getColumn(5).setPreferredWidth(30);
            this.table.getColumn(TO_HEADER).setPreferredWidth(80);
        }
        this.table.setRowSelectionAllowed(true);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(this);
    }

    protected Object[][] getAllRelationValue(int n2) {
        if (this.relatedModels == null || this.relatedModels.size() == 0) {
            return null;
        }
        Object[][] objectArray = new Object[this.relatedModels.size()][n2];
        int n3 = 0;
        for (Element element : this.relatedModels) {
            if (this.isER) {
                objectArray[n3][0] = true;
                objectArray[n3][1] = LabelProviders.getTypeText(element);
                objectArray[n3][2] = "";
                objectArray[n3][3] = element;
                objectArray[n3][4] = "";
            } else {
                Object object;
                EList<Element> eList;
                objectArray[n3][0] = true;
                objectArray[n3][1] = LabelProviders.getTypeText(element);
                objectArray[n3][2] = "";
                objectArray[n3][3] = "";
                objectArray[n3][4] = element;
                objectArray[n3][5] = "";
                objectArray[n3][6] = "";
                if (element instanceof Association) {
                    Property property;
                    eList = ((Association)element).getMemberEnds();
                    if (eList.size() > 0) {
                        object = (Property)eList.get(0);
                        if (object.isNavigable()) {
                            property = (Property)eList.get(1);
                            objectArray[n3][3] = property.getName();
                            objectArray[n3][2] = property.getType().getName();
                        } else {
                            objectArray[n3][3] = object.getName();
                            objectArray[n3][2] = object.getType().getName();
                        }
                    }
                    if (eList.size() > 1) {
                        object = (Property)eList.get(0);
                        if (object.isNavigable()) {
                            objectArray[n3][5] = object.getName();
                            objectArray[n3][6] = object.getType().getName();
                        } else {
                            property = (Property)eList.get(1);
                            objectArray[n3][5] = property.getName();
                            objectArray[n3][6] = property.getType().getName();
                        }
                    }
                } else if (element instanceof Connector) {
                    eList = ((Connector)element).getEnds();
                    if (eList != null && eList.size() > 0 && (object = (ConnectorEnd)eList.get(0)) != null && object.getRole() != null) {
                        objectArray[n3][2] = object.getRole().getName();
                    }
                    if (eList != null && eList.size() > 1 && (object = (ConnectorEnd)eList.get(1)) != null && object.getRole() != null) {
                        objectArray[n3][6] = object.getRole().getName();
                    }
                } else if (element instanceof Dependency) {
                    eList = ((Dependency)element).getClients();
                    object = ((Dependency)element).getSuppliers();
                    objectArray[n3][2] = eList.size() > 0 ? ((NamedElement)eList.get(0)).getName() : "";
                    objectArray[n3][6] = object.size() > 0 ? ((NamedElement)object.get(0)).getName() : "";
                } else if (element instanceof Extend) {
                    objectArray[n3][2] = ((Extend)element).getExtendedCase().getName();
                    objectArray[n3][6] = ((Extend)element).getExtension().getName();
                } else if (element instanceof Generalization) {
                    objectArray[n3][2] = ((Generalization)element).getSpecific().getName();
                    objectArray[n3][6] = ((Generalization)element).getGeneral().getName();
                } else if (element instanceof Include) {
                    objectArray[n3][2] = ((Include)element).getIncludingCase().getName();
                    objectArray[n3][6] = ((Include)element).getAddition().getName();
                } else if (element instanceof TemplateBinding) {
                    objectArray[n3][2] = LabelProviders.getName(((TemplateBinding)element).getBoundElement());
                    objectArray[n3][6] = LabelProviders.getName(((TemplateBinding)element).getSignature().getTemplate());
                }
            }
            ++n3;
        }
        return objectArray;
    }

    protected void updateNameHeaderStr() {
    }

    class ElementRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object object) {
            String string = object instanceof EObject ? LabelProviders.getName((EObject)object) : object.toString();
            this.setText(string == null ? "" : string);
        }
    }
}

