/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import net.astah.golf.control.CommandManager;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.jomt.jcontrol.AddMMUserIconCommand;
import net.astah.jomt.jcontrol.DeleteMMUserIconCommand;
import net.astah.jomt.jcontrol.UpdateMMUserIconCommand;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.TableUtil;
import net.astah.jomt.jview.CEditMMUserIconDialog;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.g;
import net.astah.jomt.jview.h;
import net.astah.uml.mindmap.MMUserIconInfo;
import net.astah.uml.mindmap.MMUserIconManager;
import net.astah.uml.mindmap.UserIcon;

public class EditMMUserIconDialog
extends KeyDialog
implements ActionListener,
CEditMMUserIconDialog {
    private static final long serialVersionUID = 2407867454771740528L;
    private JScrollPane scroller;
    private JPanel buttonPanel;
    protected DefaultTableModel tableModel;
    protected JTable table;
    private List userIcons = new ArrayList();
    protected static final String ADD_USER_ICON = "AddUserIcon";
    protected static final String DEL_USER_ICON = "DeleteUserIcon";
    protected static final String CLOSE = "Close";
    private final String ICON_HEADER = EditMMUserIconDialog.getTitle("projectview.table.header.icon.label");
    private final String NAME_HEADER = EditMMUserIconDialog.getTitle("projectview.table.header.name.label");

    public EditMMUserIconDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.initDialog(jFrame);
    }

    protected void initDialog(JFrame jFrame) {
        this.b();
        this.a();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", this.scroller);
        jPanel.add("South", this.buttonPanel);
        this.getContentPane().add(jPanel);
        this.setTitle(EditMMUserIconDialog.getTitle("ui.edit_user_icon_dialog.title"));
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.d();
    }

    private JPanel a() {
        JButton jButton = new JButton(EditMMUserIconDialog.getTitle("projectview.button.add.label"));
        jButton.setActionCommand(ADD_USER_ICON);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(EditMMUserIconDialog.getTitle("projectview.button.delete.label"));
        jButton2.setActionCommand(DEL_USER_ICON);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton(EditMMUserIconDialog.getTitle("projectview.button.close.label"));
        jButton3.setActionCommand(CLOSE);
        jButton3.addActionListener(this);
        this.buttonPanel = new JPanel(new FlowLayout(2));
        if (PropertyManager.isMacOS()) {
            this.buttonPanel.add(jButton3);
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
        } else {
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
            this.buttonPanel.add(jButton3);
        }
        return this.buttonPanel;
    }

    private void b() {
        this.tableModel = new DefaultTableModel(){
            private static final long serialVersionUID = 2687591390180055102L;

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return this.getColumnName(n3).equals(EditMMUserIconDialog.this.NAME_HEADER);
            }
        };
        this.tableModel.addColumn(this.ICON_HEADER);
        this.tableModel.addColumn(this.NAME_HEADER);
        this.table = new AdjustedRowHeightTable(this.tableModel);
        this.table.setShowGrid(false);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setDefaultRenderer(this.table.getColumnClass(0), new UserIconTableCellRenderer());
        this.table.getColumn(this.ICON_HEADER).setPreferredWidth(50);
        this.table.getColumn(this.NAME_HEADER).setPreferredWidth(250);
        int n2 = TableUtil.getColumnIndex(this.table, EditMMUserIconDialog.getTitle(this.NAME_HEADER));
        this.table.getCellEditor(0, n2).addCellEditorListener(new g(this));
        this.scroller = new JScrollPane(this.table);
        this.scroller.addMouseListener(new h(this));
    }

    protected Object getSelectedUserIcon() {
        int n2 = this.table.getSelectedRow();
        if (n2 == -1) {
            return null;
        }
        return (UserIcon)this.userIcons.get(n2);
    }

    private int c() {
        return this.table.getSelectedRow();
    }

    private void d() {
        MMUserIconInfo mMUserIconInfo = MMUserIconManager.instance().getSystemUserIconInfo();
        this.userIcons.clear();
        int n2 = TableUtil.getColumnIndex(this.table, this.ICON_HEADER);
        int n3 = TableUtil.getColumnIndex(this.table, this.NAME_HEADER);
        if (mMUserIconInfo != null) {
            List<UserIcon> list = mMUserIconInfo.getAllUserIcons();
            this.tableModel.setNumRows(list.size());
            int n4 = 0;
            for (UserIcon userIcon : list) {
                ImageIcon imageIcon = userIcon.getThumbnail();
                this.table.setValueAt(imageIcon, n4, n2);
                this.table.setValueAt(userIcon.getIconLabel(), n4, n3);
                ++n4;
                this.userIcons.add(userIcon);
            }
        }
        this.table.removeEditor();
        this.table.clearSelection();
        this.table.repaint();
    }

    protected static String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ADD_USER_ICON)) {
            this.g();
        } else if (string.equals(DEL_USER_ICON)) {
            this.e();
        } else if (string.equals(CLOSE)) {
            this.dispose();
        }
    }

    protected void callUpdateUserIconCommand(UserIcon userIcon) {
        UpdateMMUserIconCommand updateMMUserIconCommand = new UpdateMMUserIconCommand();
        updateMMUserIconCommand.setUserIcon(userIcon);
        CommandManager.instance().callCommand(updateMMUserIconCommand);
        this.d();
    }

    private void e() {
        DeleteMMUserIconCommand deleteMMUserIconCommand = new DeleteMMUserIconCommand();
        deleteMMUserIconCommand.setSelectedUserIcons(this.f());
        CommandManager.instance().callCommand(deleteMMUserIconCommand);
        this.d();
    }

    private int[] f() {
        return this.table.getSelectedRows();
    }

    private void g() {
        AddMMUserIconCommand addMMUserIconCommand = new AddMMUserIconCommand();
        CommandManager.instance().callCommand(addMMUserIconCommand);
        this.d();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.dispose();
        }
    }

    class UserIconTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 580891043435920023L;

        UserIconTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            if (object instanceof ImageIcon) {
                JLabel jLabel = new JLabel();
                jLabel.setIcon((ImageIcon)object);
                jLabel.setHorizontalAlignment(0);
                return jLabel;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
        }
    }
}

