/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import net.astah.dd.di.Diagram;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.FilterManager;
import net.astah.jomt.jutil.ProtoImageIconUtils;
import net.astah.jomt.jutil.TooltipedTable;
import net.astah.jomt.jview.SortableChooseTable;
import net.astah.jomt.jview.f;
import net.astah.matrix.UMatrixDiagram;
import net.astah.model.operations.DiagramOperations;
import net.astah.swing.SortableTableModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.UseCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramTable
extends SortableChooseTable {
    private static final long serialVersionUID = 6713197180106048211L;
    protected static final String TYPE_HEADER = DiagramTable.getTitle("projectview.table.header.kind.label");
    protected static final String PARENT_HEADER = DiagramTable.getTitle("projectview.table.header.parent.label");
    private boolean isIncludeCrud;
    private boolean isIncludeUCD;
    private boolean isIncludeTable;
    private static final Logger a = LoggerFactory.getLogger(DiagramTable.class);

    public DiagramTable(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.isIncludeCrud = bl2;
        this.isIncludeUCD = bl3;
        this.isIncludeTable = bl4;
        this.setLayout(new BorderLayout());
        if (bl) {
            this.a(bl);
        } else {
            this.b(bl);
        }
        this.scroller = new JScrollPane(this.table);
        this.add("Center", this.scroller);
    }

    private void a(boolean bl) {
        this.columnNames = new String[3];
        this.columnNames[0] = this.NAME_HEADER;
        this.columnNames[1] = TYPE_HEADER;
        this.columnNames[2] = PARENT_HEADER;
        Object[][] objectArray = this.a(this.columnNames.length, bl);
        this.tableModel = new SortableTableModel(objectArray, this.columnNames);
        this.table = new TooltipedTable();
        this.table.setModel(this.tableModel);
        this.table.setShowGrid(true);
        double d2 = SwingIconRegistry.getDefaultScale();
        this.table.getColumnModel().setColumnMargin((int)Math.ceil(0.0 * d2));
        this.table.getColumn(TYPE_HEADER).setPreferredWidth((int)Math.ceil(40.0 * d2));
        this.table.getColumn(TYPE_HEADER).setMaxWidth((int)Math.ceil(40.0 * d2));
        this.table.setRowSelectionAllowed(true);
        this.tableModel.sort(DiagramTable.getColumnIndex(this.table, this.NAME_HEADER));
        this.table.getColumn(this.NAME_HEADER).setCellRenderer(new DiagramTableCellRenderer(null));
        this.table.setName("diagramtable");
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(this);
    }

    private void b(boolean bl) {
        this.columnNames = new String[4];
        this.columnNames[0] = "C";
        this.columnNames[1] = this.NAME_HEADER;
        this.columnNames[2] = TYPE_HEADER;
        this.columnNames[3] = PARENT_HEADER;
        Object[][] objectArray = this.a(this.columnNames.length, bl);
        this.tableModel = new SortableTableModel(objectArray, this.columnNames);
        this.table = new AdjustedRowHeightTable(this.tableModel);
        this.table.setShowGrid(true);
        double d2 = SwingIconRegistry.getDefaultScale();
        this.table.getColumnModel().setColumnMargin((int)Math.ceil(0.0 * d2));
        this.table.getColumn("C").setMaxWidth((int)Math.ceil(30.0 * d2));
        this.table.getColumn(TYPE_HEADER).setPreferredWidth((int)Math.ceil(130.0 * d2));
        this.table.getColumn(TYPE_HEADER).setMaxWidth((int)Math.ceil(200.0 * d2));
        this.table.setRowSelectionAllowed(true);
        this.tableModel.sort(DiagramTable.getColumnIndex(this.table, this.NAME_HEADER));
        this.table.getColumn(this.NAME_HEADER).setCellRenderer(new DiagramTableCellRenderer(null));
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(this);
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    private Object[][] a(int n2, boolean bl) {
        List<Diagram> list = this.a();
        if (list == null || list.size() == 0) {
            return null;
        }
        Object[][] objectArray = new Object[list.size()][n2];
        int n3 = 0;
        for (Diagram diagram : list) {
            int n4 = 0;
            if (diagram instanceof Diagram) {
                Diagram diagram2 = diagram;
                if (bl) {
                    objectArray[n3][n4++] = diagram2;
                    objectArray[n3][n4++] = ProtoImageIconUtils.getIconFor(diagram2);
                } else {
                    objectArray[n3][n4++] = false;
                    objectArray[n3][n4++] = diagram2;
                    objectArray[n3][n4++] = LabelProviders.getTypeText(diagram2);
                }
                objectArray[n3][n4] = LabelProviders.getQualifiedText(DiagramOperations.getParent(diagram2));
            }
            ++n3;
        }
        return objectArray;
    }

    private List<Diagram> a() {
        ArrayList<Diagram> arrayList = new ArrayList<Diagram>();
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        Iterator<EObject> iterator = iJomtEntityStore.entityIterator();
        while (iterator.hasNext()) {
            EObject eObject = iterator.next();
            if (eObject instanceof Diagram) {
                if (!FilterManager.getElementFilter().isPassed(eObject) || eObject instanceof UMatrixDiagram && !this.isIncludeCrud) continue;
                arrayList.add((Diagram)eObject);
                continue;
            }
            if (!(eObject instanceof UseCase) || !this.isIncludeUCD) continue;
            UseCase useCase = (UseCase)eObject;
        }
        return arrayList;
    }

    void updateTable(boolean bl) {
        String[] stringArray = new String[]{this.NAME_HEADER, TYPE_HEADER, PARENT_HEADER};
        Object[][] objectArray = this.a(stringArray.length, bl);
        if (objectArray == null) {
            this.tableModel.setNumRows(0);
            return;
        }
        this.tableModel.setNumRows(objectArray.length);
        int n2 = DiagramTable.getColumnIndex(this.table, this.NAME_HEADER);
        int n3 = DiagramTable.getColumnIndex(this.table, TYPE_HEADER);
        int n4 = DiagramTable.getColumnIndex(this.table, PARENT_HEADER);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.table.setValueAt(objectArray[i2][0], i2, n2);
            this.table.setValueAt(objectArray[i2][1], i2, n3);
            this.table.setValueAt(objectArray[i2][2], i2, n4);
        }
        this.table.clearSelection();
        this.tableModel.sort(DiagramTable.getColumnIndex(this.table, this.NAME_HEADER));
    }

    public void setSelectedDiagram(Point point) {
        int n2 = this.table.rowAtPoint(point);
        if (n2 >= 0 && n2 < this.table.getRowCount()) {
            this.table.setRowSelectionInterval(n2, n2);
        }
    }

    public Object getSelectedItem() {
        int n2 = this.table.getSelectedRow();
        int n3 = DiagramTable.getColumnIndex(this.table, this.NAME_HEADER);
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        return this.table.getValueAt(n2, n3);
    }

    public List getSelectedItems() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int[] nArray = this.table.getSelectedRows();
        int n2 = DiagramTable.getColumnIndex(this.table, this.NAME_HEADER);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(this.table.getValueAt(nArray[i2], n2));
        }
        return arrayList;
    }

    public void clear() {
        SortableTableModel sortableTableModel = (SortableTableModel)this.getTable().getModel();
        sortableTableModel.getDataVector().clear();
    }

    private class DiagramTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3585399040055972764L;

        private DiagramTableCellRenderer() {
        }

        @Override
        protected void setValue(Object object) {
            String string;
            if (object instanceof EObject && (string = LabelProviders.getName((EObject)object)) != null) {
                this.setText(string);
                return;
            }
            super.setValue(object);
        }

        /* synthetic */ DiagramTableCellRenderer(f f2) {
            this();
        }
    }
}

