/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.astah.dd.di.Diagram;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.DNDConvertTable;
import net.astah.jomt.jview.KeyDialog;
import net.astah.notation.mindmap.MMTopicShape;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Package;

public class DNDConvertDialog
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = 8785507303075658578L;
    protected DNDConvertTable convertTable;
    private JCheckBox copyToModelCheck;
    private JCheckBox sourceToTarget;
    private JCheckBox targetToSource;
    private boolean copyHyperlinkToModel;
    private boolean isSourceToTarget;
    private boolean isTargetToSource;
    protected Diagram diagram;
    private int result;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CLOSE = -1;
    protected String kind;
    protected Set models;
    private EObject containerModel;

    public DNDConvertDialog(JFrame jFrame, EObject eObject, Set set, Diagram diagram, String string) {
        super((Frame)jFrame, true);
        this.containerModel = eObject;
        this.diagram = diagram;
        this.kind = string;
        this.models = set;
        this.initConvertTable();
        this.a();
    }

    public DNDConvertDialog(JFrame jFrame, Set set, Diagram diagram, String string) {
        this(jFrame, null, set, diagram, string);
    }

    private void a() {
        this.convertTable.setPreferredSize(new Dimension(500, 150));
        JPanel jPanel = this.b();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.convertTable, "Center");
        jPanel2.add((Component)jPanel, "South");
        JPanel jPanel3 = this.c();
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add("Center", jPanel2);
        jPanel4.add("South", jPanel3);
        this.getContentPane().add(jPanel4);
        this.setTitle(this.getDialogTitle());
        this.pack();
    }

    private JPanel b() {
        this.f();
        this.d();
        JPanel jPanel = new JPanel(this.e());
        this.b(jPanel);
        this.a(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.GRAY), null);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(compoundBorder, DNDConvertDialog.getTitle("ui.mindmap_topic_uml_convert_dialog.group.hyperlink.label"));
        jPanel2.setBorder(titledBorder);
        return jPanel2;
    }

    private JPanel c() {
        this.copyToModelCheck = new JCheckBox(this.getCopyToModelCheckLabel());
        this.copyToModelCheck.setActionCommand("CopyToModel");
        this.copyToModelCheck.addActionListener(this);
        this.copyToModelCheck.setSelected(RuntimeGlobal.sysProp.getBooleanWithDefault("convert_model.copy_link_source_to_target_model"));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(DNDConvertDialog.getTitle("projectview.button.ok.label"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(DNDConvertDialog.getTitle("projectview.button.cancel.label"));
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.copyToModelCheck, "West");
        jPanel2.add((Component)jPanel, "East");
        return jPanel2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.g();
            this.result = 1;
            if (this.convertTable.isConvertable()) {
                this.dispose();
            }
            RuntimeGlobal.sysProp.setBoolean("convert_model.link_source_to_target_model", this.sourceToTarget.isSelected());
            RuntimeGlobal.sysProp.setBoolean("convert_model.link_target_to_source_model", this.targetToSource.isSelected());
            RuntimeGlobal.sysProp.setBoolean("convert_model.copy_link_source_to_target_model", this.copyToModelCheck.isSelected());
            RuntimeGlobal.sysProp.store();
        } else if (actionEvent.getActionCommand().equals("CANCEL")) {
            this.result = 2;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("CopyToModel")) {
            this.copyHyperlinkToModel = this.copyToModelCheck.isSelected();
        } else {
            this.result = -1;
            this.dispose();
        }
    }

    public boolean isCopyHyperlinkToModel() {
        return this.copyHyperlinkToModel;
    }

    public boolean isTargetToSource() {
        return this.isTargetToSource;
    }

    public boolean isSourceToTarget() {
        return this.isSourceToTarget;
    }

    protected static String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    protected String getDialogTitle() {
        return DNDConvertDialog.getTitle("ui.mindmap_topic_uml_convert_dialog.title");
    }

    protected String getTargetToSourceLabel() {
        if (this.isSourceTopic()) {
            return DNDConvertDialog.getTitle("ui.uml_dnd_convert_dialog.button.element_to_topic.label");
        }
        return DNDConvertDialog.getTitle("ui.uml_dnd_convert_dialog.button.diagram_element_to_model.label");
    }

    protected String getSourceToTargetLabel() {
        if (this.isSourceTopic()) {
            return DNDConvertDialog.getTitle("ui.uml_dnd_convert_dialog.button.topic_to_element.label");
        }
        return DNDConvertDialog.getTitle("ui.uml_dnd_convert_dialog.button.model_to_diagram_element.label");
    }

    protected void initConvertTable() {
        this.convertTable = new DNDConvertTable(this.containerModel, this.models, this.diagram, this.kind);
    }

    private void a(JPanel jPanel) {
        jPanel.add(this.targetToSource);
    }

    private void d() {
        this.targetToSource = new JCheckBox(this.getTargetToSourceLabel());
        this.targetToSource.setSelected(RuntimeGlobal.sysProp.getBooleanWithDefault("convert_model.link_target_to_source_model"));
    }

    private GridLayout e() {
        return new GridLayout(2, 0);
    }

    private void b(JPanel jPanel) {
        jPanel.add(this.sourceToTarget);
    }

    private void f() {
        this.sourceToTarget = new JCheckBox(this.getSourceToTargetLabel());
        this.sourceToTarget.setSelected(RuntimeGlobal.sysProp.getBooleanWithDefault("convert_model.link_source_to_target_model"));
    }

    protected String getCopyToModelCheckLabel() {
        return DNDConvertDialog.getTitle("ui.uml_dnd_convert_dialog.button.copy_hyperlink_to_model.label");
    }

    private void g() {
        this.isSourceToTarget = this.sourceToTarget.isSelected();
        this.isTargetToSource = this.targetToSource.isSelected();
        this.copyHyperlinkToModel = this.copyToModelCheck.isSelected();
    }

    public int getResult() {
        return this.result;
    }

    public List<Object> getCheckedItems() {
        return this.convertTable.getCheckedItems();
    }

    public Map getPackageMap() {
        return this.convertTable.getPackageMap();
    }

    protected boolean isSourceTopic() {
        for (Object e2 : this.models) {
            if (e2 instanceof MMTopicShape) continue;
            return false;
        }
        return true;
    }

    public Package getNamespace(EObject eObject) {
        Map map = this.getPackageMap();
        String string = (String)map.get(eObject);
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        String string2 = this.a(string, iJomtEntityStore);
        return EntityAccessor.getPackageByName(iJomtEntityStore.getRoot(), string2);
    }

    public Package getNamespace(MMTopicShape mMTopicShape) {
        Map map = this.getPackageMap();
        String string = (String)map.get(mMTopicShape);
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        String string2 = this.a(string, iJomtEntityStore);
        return EntityAccessor.getPackageByName(iJomtEntityStore.getRoot(), string2);
    }

    private String a(String string, IEntityStore iEntityStore) {
        EObject eObject = EntityAccessor.getProjectModel(iEntityStore);
        if (eObject instanceof Package) {
            return ((Package)eObject).getLabel() + "::" + string;
        }
        return string;
    }
}

