/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.astah.emf.compare.ComparisonSource;
import net.astah.emf.compare.merge.DiffGroup;
import net.astah.emf.compare.merge.MatchAdapter;
import net.astah.emf.compare.provider.CompareTreeAdapterFactory;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.JTreeBuilder;
import net.astah.golf.control.Command;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.swing.AdjustFontSizeTextArea;
import net.astah.golf.widget.swing.NavigableTreeModel;
import net.astah.jomt.jcontrol.ExportProjectDifferenceToCSVCommand;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.provider.CompareTreeBuilder;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.spec.MatchSpec;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareTreePanel
extends JPanel
implements ItemSelectable,
ActionListener {
    private static final Logger a = LoggerFactory.getLogger(CompareTreePanel.class);
    private static final long serialVersionUID = 1L;
    protected final IComparisonScope scope;
    protected final Comparison comparison;
    transient ItemListener itemListener;
    protected Object selectedObject;
    JTree leftTree;
    JTree rightTree;

    public CompareTreePanel(IComparisonScope iComparisonScope, Comparison comparison) {
        super(new BorderLayout());
        this.scope = iComparisonScope;
        this.comparison = comparison;
        this.initialize();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        CompareTreeBuilder.a(this.leftTree);
        CompareTreeBuilder.a(this.rightTree);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        if (this.selectedObject != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.selectedObject;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        switch (Strings.nullToEmpty(actionEvent.getActionCommand())) {
            case "SelectAll": {
                this.setAllDecision(ComparisonSource.RIGHT);
                break;
            }
            case "DeselectAll": {
                this.setAllDecision(null);
                break;
            }
            case "Export": {
                this.a();
                break;
            }
            case "SelectSubTree": {
                this.a(actionEvent.getSource());
            }
        }
    }

    private void a(Object object) {
        AdapterFactory adapterFactory = JTreeBuilder.getAdapterFactory(this.rightTree);
        if (adapterFactory instanceof CompareTreeAdapterFactory && object instanceof JCheckBox) {
            CompareTreeAdapterFactory compareTreeAdapterFactory = (CompareTreeAdapterFactory)adapterFactory;
            boolean bl = ((JCheckBox)object).isSelected();
            compareTreeAdapterFactory.setSelectSubTree(bl);
            TreePath[] treePathArray = this.rightTree.getSelectionPaths();
            if (treePathArray == null || treePathArray.length == 0) {
                return;
            }
            this.rightTree.setSelectionPath(null);
            this.rightTree.setSelectionPaths(treePathArray);
            for (TreePath treePath : treePathArray) {
                ComparisonSource comparisonSource;
                MatchSpec matchSpec;
                MatchAdapter matchAdapter;
                if (!(treePath.getLastPathComponent() instanceof MatchSpec) || (matchAdapter = compareTreeAdapterFactory.getMatchAdapter(matchSpec = (MatchSpec)treePath.getLastPathComponent())) == null) continue;
                ComparisonSource comparisonSource2 = comparisonSource = this.a(compareTreeAdapterFactory, matchSpec) > 0 ? compareTreeAdapterFactory.getSource() : null;
                if (comparisonSource == null) continue;
                matchAdapter.setDecision(null, bl);
                matchAdapter.setDecision(comparisonSource, bl);
            }
        }
    }

    private int a(CompareTreeAdapterFactory compareTreeAdapterFactory, MatchSpec matchSpec) {
        ComparisonSource comparisonSource = compareTreeAdapterFactory.getSource();
        int n2 = 0;
        for (Diff diff : matchSpec.getDifferences()) {
            DiffGroup diffGroup = DiffGroup.get(diff);
            n2 |= diffGroup.getDecision() == comparisonSource ? 1 : 2;
        }
        if (n2 == 1) {
            return 1;
        }
        if (n2 == 3) {
            return -1;
        }
        return 0;
    }

    private void a() {
        List<Diff> list = this.comparison.getDifferences().stream().filter(DiffGroup::isVisible).collect(Collectors.toList());
        ExportProjectDifferenceToCSVCommand exportProjectDifferenceToCSVCommand = new ExportProjectDifferenceToCSVCommand(list);
        ((Command)exportProjectDifferenceToCSVCommand).execute();
    }

    protected void setAllDecision(ComparisonSource comparisonSource) {
        for (Diff diff : this.comparison.getDifferences()) {
            DiffGroup diffGroup = DiffGroup.get(diff, comparisonSource != null);
            if (diffGroup == null) continue;
            diffGroup.setDecision(comparisonSource);
        }
    }

    protected void selectNonConflictedAdd() {
        HashSet<DiffGroup> hashSet = new HashSet<DiffGroup>();
        for (Diff object : Iterables.filter(this.comparison.getDifferences(), DiffGroup::isVisible)) {
            DiffGroup diffGroup = DiffGroup.get(object);
            if (hashSet.contains(diffGroup) || this.comparison.isThreeWay() && diffGroup.getAllConflicts().findFirst().isPresent() || !diffGroup.getDifferences().stream().allMatch(this::isAddedOnRight)) continue;
            hashSet.add(diffGroup);
            hashSet.addAll(diffGroup.getAllRequires());
        }
        for (DiffGroup diffGroup : hashSet) {
            diffGroup.setDecision(ComparisonSource.RIGHT);
        }
    }

    protected boolean isAddedOnRight(Diff diff) {
        if (diff.getSource() == DifferenceSource.LEFT ? diff.getKind() == DifferenceKind.DELETE : diff.getKind() == DifferenceKind.ADD) {
            return true;
        }
        Match match = diff.getMatch();
        return match != null && match.getLeft() == null;
    }

    protected void changeItemState(Object object) {
        if (this.selectedObject != object) {
            Object object2 = this.selectedObject;
            this.selectedObject = object;
            if (this.itemListener != null) {
                ItemEvent itemEvent;
                if (object2 != null) {
                    a.debug("Firing deselected event: {}", object2);
                    itemEvent = new ItemEvent(this, 701, object2, 2);
                    this.itemListener.itemStateChanged(itemEvent);
                }
                if (object != null) {
                    a.debug("Firing selected event: {}", object);
                    itemEvent = new ItemEvent(this, 701, object, 1);
                    this.itemListener.itemStateChanged(itemEvent);
                }
            }
        }
    }

    protected void initialize() {
        this.selectNonConflictedAdd();
        this.add("North", this.createNorthPane());
        this.add("Center", this.createCenterPane());
    }

    protected Component createNorthPane() {
        JCheckBox jCheckBox = new JCheckBox("\u30b5\u30d6\u30c4\u30ea\u30fc\u5168\u4f53\u9078\u629e", true);
        jCheckBox.setActionCommand("SelectSubTree");
        jCheckBox.addActionListener(this);
        JButton jButton = new JButton("\u51fa\u529b");
        jButton.setActionCommand("Export");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("\u5168\u9078\u629e");
        jButton2.setActionCommand("SelectAll");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("\u5168\u89e3\u9664");
        jButton3.setActionCommand("DeselectAll");
        jButton3.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.setBackground(this.getBackground());
        jPanel.setOpaque(true);
        jPanel.add(jCheckBox);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("Center", this.createStatusLine());
        jPanel2.add("East", jPanel);
        return jPanel2;
    }

    protected Component createStatusLine() {
        AdjustFontSizeTextArea adjustFontSizeTextArea = new AdjustFontSizeTextArea();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        adjustFontSizeTextArea.setEditable(false);
        adjustFontSizeTextArea.setLineWrap(true);
        adjustFontSizeTextArea.setOpaque(false);
        adjustFontSizeTextArea.setText(this.formatStatusLine(this.comparison));
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory(this.comparison);
        ((IChangeNotifier)((Object)adapterFactory)).addListener(notification -> {
            if (this.isStatusLineChange(notification) && atomicBoolean.compareAndSet(false, true)) {
                SwingInvoker.runLaterInEDT(() -> {
                    if (atomicBoolean.compareAndSet(true, false)) {
                        adjustFontSizeTextArea.setText(this.formatStatusLine(this.comparison));
                    }
                });
            }
        });
        return adjustFontSizeTextArea;
    }

    protected String formatStatusLine(Comparison comparison) {
        int n2 = 0;
        int n3 = 0;
        EList<Diff> eList = comparison.getDifferences();
        for (Diff diff : Iterables.filter(eList, DiffGroup::isVisible)) {
            DiffGroup diffGroup = DiffGroup.get(diff, false);
            if (diffGroup != null && diffGroup.getDecision() != null) {
                ++n3;
            }
            ++n2;
        }
        String string = "\u30e2\u30c7\u30eb\u306e\u5dee\u5206 {0} \u4ef6 ({1} \u4ef6\u3092\u53d6\u308a\u8fbc\u307f\u5bfe\u8c61\u3068\u3057\u3066\u9078\u629e\u6e08\u307f)";
        return MessageFormat.format("\u30e2\u30c7\u30eb\u306e\u5dee\u5206 {0} \u4ef6 ({1} \u4ef6\u3092\u53d6\u308a\u8fbc\u307f\u5bfe\u8c61\u3068\u3057\u3066\u9078\u629e\u6e08\u307f)", n2, n3);
    }

    protected boolean isStatusLineChange(Notification notification) {
        if (notification.getNotifier() instanceof DiffGroup) {
            switch (notification.getFeatureID(DiffGroup.class)) {
                case 0: {
                    return true;
                }
            }
        }
        return false;
    }

    protected Component createCenterPane() {
        HashMap<ComparisonSource, AdapterFactory> hashMap = new HashMap<ComparisonSource, AdapterFactory>();
        CompareTreeBuilder<?> compareTreeBuilder = this.createTreeBuilder(hashMap, ComparisonSource.LEFT);
        CompareTreeBuilder<?> compareTreeBuilder2 = this.createTreeBuilder(hashMap, ComparisonSource.RIGHT);
        this.leftTree = compareTreeBuilder.build();
        this.rightTree = compareTreeBuilder2.build();
        a a2 = new a(this.rightTree);
        a a3 = new a(this.leftTree);
        this.leftTree.addTreeExpansionListener(a2);
        this.leftTree.addTreeSelectionListener(a2);
        this.leftTree.addMouseListener(a2);
        this.leftTree.setToggleClickCount(0);
        this.rightTree.addTreeExpansionListener(a3);
        this.rightTree.addTreeSelectionListener(a3);
        this.rightTree.addMouseListener(a3);
        this.rightTree.setToggleClickCount(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JSplitPane jSplitPane = new JSplitPane(1, true);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setLeftComponent(this.createTreePanel(this.leftTree, this.scope.getLeft()));
        jSplitPane.setRightComponent(this.createTreePanel(this.rightTree, this.scope.getRight()));
        jPanel.add(jSplitPane);
        return jPanel;
    }

    protected Component createTreePanel(JTree jTree, Notifier notifier) {
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter(notifier);
        Project project = projectManagerAdapter.getRootProject();
        JPanel jPanel = new JPanel(new BorderLayout());
        AdjustFontSizeTextArea adjustFontSizeTextArea = new AdjustFontSizeTextArea();
        adjustFontSizeTextArea.setEditable(false);
        adjustFontSizeTextArea.setLineWrap(true);
        adjustFontSizeTextArea.setBackground(this.getBackground());
        String string = String.valueOf(project.getRealURI());
        adjustFontSizeTextArea.setText(GolfUtilities.decode(string));
        adjustFontSizeTextArea.setMinimumSize(new Dimension(50, 0));
        jPanel.add("North", adjustFontSizeTextArea);
        jPanel.add("Center", new JScrollPane(jTree));
        return jPanel;
    }

    protected CompareTreeBuilder<?> createTreeBuilder(Map<ComparisonSource, AdapterFactory> map, ComparisonSource comparisonSource) {
        Notifier notifier = comparisonSource.get(this.scope);
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter(notifier);
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(notifier);
        return ((CompareTreeBuilder)((CompareTreeBuilder)CompareTreeBuilder.a(transactionalEditingDomain, map, this.comparison, comparisonSource).adapterFactoryDecorator(new net.astah.provider.a())).b(projectManagerAdapter.getRootProject().getContents().get(0))).a();
    }

    private class a
    implements MouseListener,
    TreeExpansionListener,
    TreeSelectionListener {
        protected JTree a;

        public a(JTree jTree) {
            this.a = jTree;
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            TreePath treePath2 = this.a(this.a, treePath);
            if (treePath2 != null) {
                this.a.expandPath(treePath2);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            TreePath treePath2 = this.a(this.a, treePath);
            if (treePath2 != null) {
                this.a.collapsePath(treePath2);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] treePathArray = ((JTree)treeSelectionEvent.getSource()).getSelectionPaths();
            if (treePathArray != null && treePathArray.length == 1) {
                TreePath treePath = this.a(this.a, treePathArray[0]);
                TreePath[] treePathArray2 = this.a.getSelectionPaths();
                if (treePathArray2 == null || treePathArray2.length != 1 || !treePathArray2[0].equals(treePath)) {
                    this.a.setSelectionPath(treePath);
                    this.a.scrollPathToVisible(treePath);
                }
            } else if (treePathArray == null) {
                CompareTreePanel.this.changeItemState(null);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath;
            Object object = mouseEvent.getSource();
            if (mouseEvent.getClickCount() == 2 && object instanceof JTree && (treePath = ((JTree)object).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                CompareTreePanel.this.changeItemState(treePath.getLastPathComponent());
                mouseEvent.consume();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        protected TreePath a(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            return ((NavigableTreeModel)jTree.getModel()).getPath(object);
        }
    }
}

