/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import net.astah.dd.di.Diagram;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.compare.ComparisonSource;
import net.astah.emf.compare.MergeJob;
import net.astah.emf.compare.merge.DiffGroup;
import net.astah.emf.edit.job.Jobs;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.CompareDiagramPanel;
import net.astah.jomt.jview.CompareTreePanel;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.JomtGridBagLayout;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jviewElement.DiagramViewElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareDialog
extends KeyDialog
implements ActionListener {
    private static final Logger a = LoggerFactory.getLogger(CompareDialog.class);
    private static final long serialVersionUID = 1L;
    private static final int b = 2;
    protected final IComparisonScope scope;
    protected final Comparison comparison;

    public CompareDialog(Frame frame, IComparisonScope iComparisonScope, Comparison comparison) {
        super(frame, true);
        this.scope = Objects.requireNonNull(iComparisonScope, "scope");
        this.comparison = Objects.requireNonNull(comparison, "comparison");
        this.setTitle(CompareDialog.a("ui.compare_project_dialog.title"));
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        switch (Strings.nullToEmpty(actionEvent.getActionCommand())) {
            default: {
                this.merge();
                break;
            }
            case "Cancel": {
                this.dispose();
            }
        }
    }

    protected void initialize() {
        CompareTreePanel compareTreePanel = new CompareTreePanel(this.scope, this.comparison);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        JSplitPane jSplitPane = new JSplitPane(0, true);
        jSplitPane.setLeftComponent(compareTreePanel);
        jSplitPane.setResizeWeight(0.3);
        jPanel.add("Center", jSplitPane);
        this.getContentPane().add("Center", jPanel);
        this.getContentPane().add("South", this.b());
        this.setSize(1024, 768);
        compareTreePanel.addItemListener(itemEvent -> {
            Match match;
            Object object;
            if (itemEvent.getStateChange() == 1 && (object = itemEvent.getItem()) instanceof Match && ((match = (Match)object).getLeft() == null || match.getLeft() instanceof Diagram) && (match.getRight() == null || match.getRight() instanceof Diagram)) {
                jSplitPane.setRightComponent(new CompareDiagramPanel(match));
                return;
            }
            jSplitPane.setRightComponent(null);
        });
    }

    protected void merge() {
        boolean bl;
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)iJomtEntityStore.getDomain();
        DiagramViewElement diagramViewElement = this.a();
        boolean bl2 = bl = diagramViewElement != null ? diagramViewElement.getCreateEditState() : false;
        if (diagramViewElement != null) {
            diagramViewElement.setCreateEditState(false);
        }
        MergeJob mergeJob = new MergeJob(transactionalEditingDomain, this.collectDecision());
        mergeJob.addJobChangeListener(Jobs.done(iJobChangeEvent -> {
            this.dispose();
            IStatus iStatus = iJobChangeEvent.getResult();
            if (!iStatus.isOK() && iStatus.getSeverity() != 8) {
                String string = iStatus.getMessage();
                Throwable throwable = iStatus.getException();
                if (throwable instanceof RollbackException && Transactions.isConstraintViolation(iStatus)) {
                    iStatus = ((RollbackException)throwable).getStatus();
                    MessageManager.displayConstraintStatusMessageDialog("app", string, iStatus);
                } else {
                    MessageManager.displayStatusMessageDialog("app", string, iStatus);
                    a.error(string, throwable);
                }
            }
            if (diagramViewElement != null) {
                diagramViewElement.setCreateEditState(bl);
            }
        }, true));
        mergeJob.schedule();
    }

    private DiagramViewElement a() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (diagramEditor != null) {
            return diagramEditor.getDiagramScene().getDiagramViewElement();
        }
        return null;
    }

    protected Map<Diff, ComparisonSource> collectDecision() {
        IdentityHashMap<Diff, ComparisonSource> identityHashMap = new IdentityHashMap<Diff, ComparisonSource>();
        for (Diff diff : this.comparison.getDifferences()) {
            ComparisonSource comparisonSource;
            DiffGroup diffGroup = DiffGroup.get(diff, false);
            if (diffGroup == null || (comparisonSource = diffGroup.getDecision()) == null) continue;
            identityHashMap.put(diff, comparisonSource);
        }
        return identityHashMap;
    }

    private Component b() {
        JomtGridBagLayout jomtGridBagLayout = new JomtGridBagLayout();
        JPanel jPanel = new JPanel(jomtGridBagLayout);
        JButton jButton = new JButton("Merge");
        jButton.setActionCommand("Merge");
        jButton.addActionListener(this);
        jomtGridBagLayout.setLayout(jButton, 1, 1.0, false);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(CompareDialog.a("projectview.button.close.label"));
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(this);
        jomtGridBagLayout.setLayout(jButton2, 1, 1.0, false);
        jPanel.add(jButton2);
        return jPanel;
    }

    private static String a(String string) {
        return MoreObjects.firstNonNull(PropertyManager.getProjectViewResourceBundle().getString(string), string);
    }
}

