/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.print.Printable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.Diagram;
import net.astah.emf.compare.ComparisonSource;
import net.astah.emf.compare.ui.editor.MatchViewElement;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.draw.GCamera;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.view.UIView;
import net.astah.golf.widget.CDesktopPane;
import net.astah.golf.widget.swing.AdjustFontSizeTextArea;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.JomtCanvas;
import net.astah.jomt.jview.u;
import org.eclipse.emf.compare.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareDiagramPanel
extends JPanel {
    private static final Logger a = LoggerFactory.getLogger(CompareDiagramPanel.class);
    private static final long serialVersionUID = 1L;
    private final List<UIView> views = new ArrayList<UIView>();
    protected Match diagramMatch;
    protected JPanel mainPanel;
    private double scale = 1.0;
    private static final int b = 2;

    public CompareDiagramPanel(Match match) {
        super(new BorderLayout());
        assert (match.getLeft() == null || match.getLeft() instanceof Diagram);
        assert (match.getRight() == null || match.getRight() instanceof Diagram);
        this.diagramMatch = match;
        this.initialize();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        while (!this.views.isEmpty()) {
            this.views.remove(this.views.size() - 1).remove();
        }
    }

    protected void initialize() {
        this.add("Center", this.a());
    }

    private Component a() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout(1, 2));
        DiagramEditor diagramEditor = this.createEditor(ComparisonSource.LEFT);
        DiagramEditor diagramEditor2 = this.createEditor(ComparisonSource.RIGHT);
        GNode gNode = diagramEditor != null ? (GNode)((Object)diagramEditor.getDiagramScene().getDiagramViewElement()) : null;
        GNode gNode2 = diagramEditor2 != null ? (GNode)((Object)diagramEditor2.getDiagramScene().getDiagramViewElement()) : null;
        this.createMatchViewElement(ComparisonSource.LEFT, gNode, gNode2, this.diagramMatch);
        this.createMatchViewElement(ComparisonSource.RIGHT, gNode2, gNode, this.diagramMatch);
        Rectangle2d rectangle2d = this.a(diagramEditor, diagramEditor2);
        JScrollPane jScrollPane = diagramEditor != null ? this.createEditorPane(diagramEditor, rectangle2d) : new JScrollPane();
        JScrollPane jScrollPane2 = diagramEditor2 != null ? this.createEditorPane(diagramEditor2, rectangle2d) : new JScrollPane();
        this.a(jScrollPane, jScrollPane2);
        JSplitPane jSplitPane = new JSplitPane(1, true);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setLeftComponent(this.createDiagramPane(ComparisonSource.LEFT, jScrollPane));
        jSplitPane.setRightComponent(this.createDiagramPane(ComparisonSource.RIGHT, jScrollPane2));
        this.mainPanel.add("Center", jSplitPane);
        return this.mainPanel;
    }

    protected Component createDiagramPane(ComparisonSource comparisonSource, Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        AdjustFontSizeTextArea adjustFontSizeTextArea = new AdjustFontSizeTextArea();
        adjustFontSizeTextArea.setEditable(false);
        adjustFontSizeTextArea.setLineWrap(true);
        adjustFontSizeTextArea.setBackground(this.getBackground());
        adjustFontSizeTextArea.setMinimumSize(new Dimension(50, 0));
        adjustFontSizeTextArea.setText(LabelProviders.getQualifiedText(comparisonSource.get(this.diagramMatch)));
        jPanel.add("North", adjustFontSizeTextArea);
        jPanel.add("Center", component);
        return jPanel;
    }

    protected JScrollPane createEditorPane(DiagramEditor diagramEditor, Rectangle2d rectangle2d) {
        PaperPanel paperPanel = new PaperPanel(diagramEditor, rectangle2d);
        JScrollPane jScrollPane = new JScrollPane(paperPanel);
        u u2 = new u(jScrollPane);
        paperPanel.addMouseMotionListener(u2);
        paperPanel.addMouseListener(u2);
        return jScrollPane;
    }

    protected DiagramEditor createEditor(ComparisonSource comparisonSource) {
        Diagram diagram = (Diagram)comparisonSource.get(this.diagramMatch);
        if (diagram == null) {
            return null;
        }
        DiagramViewInfo diagramViewInfo = new DiagramViewInfo(diagram, new GCamera());
        CDesktopPane cDesktopPane = JomtGlobal.viewManager.getManagementView().getDesktopPane();
        DiagramEditor diagramEditor = new DiagramEditor(diagramViewInfo, cDesktopPane);
        diagramEditor.getContainer().setVisible(false);
        this.views.add(diagramEditor);
        return diagramEditor;
    }

    protected void createMatchViewElement(ComparisonSource comparisonSource, GNode gNode, GNode gNode2, Match match) {
        MatchViewElement matchViewElement = new MatchViewElement(match, comparisonSource, gNode2);
        matchViewElement.setDepth(Integer.MIN_VALUE);
        if (gNode != null) {
            gNode.addNode((GNode)matchViewElement);
        }
        matchViewElement.refresh(null, null);
    }

    private void a(JScrollPane jScrollPane, JScrollPane jScrollPane2) {
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
        jScrollBar2.setModel(jScrollPane2.getHorizontalScrollBar().getModel());
        jScrollBar.setModel(jScrollPane2.getVerticalScrollBar().getModel());
    }

    private Rectangle2d a(DiagramEditor diagramEditor, DiagramEditor diagramEditor2) {
        Rectangle2d rectangle2d = new Rectangle2d();
        if (diagramEditor != null) {
            rectangle2d.setRect(diagramEditor.getDiagramScene().getDiagramViewElement().getDgmRect());
        }
        if (diagramEditor2 != null) {
            rectangle2d.add(diagramEditor2.getDiagramScene().getDiagramViewElement().getDgmRect());
        }
        return rectangle2d;
    }

    class PaperPanel
    extends JLabel {
        private static final long serialVersionUID = 6996146103379010685L;
        private Diagram dgm;
        private DiagramEditor de;
        private Dimension size;
        private SoftReference<Image> imageReference;

        public PaperPanel(DiagramEditor diagramEditor, Rectangle2d rectangle2d) {
            this.setOpaque(false);
            this.de = diagramEditor;
            this.dgm = diagramEditor.getDiagram();
            this.size = new Dimension((int)(rectangle2d.getWidth() + 4.0), (int)(rectangle2d.getHeight() + 4.0));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)(this.size.getWidth() * CompareDiagramPanel.this.scale), (int)(this.size.getHeight() * CompareDiagramPanel.this.scale));
        }

        @Override
        public void paint(Graphics graphics) {
            Image image;
            a.trace("paint: in");
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.imageReference == null || this.imageReference.get() == null) {
                this.setupImage();
            }
            if ((image = this.imageReference.get()) != null) {
                graphics2D.drawImage(image, 2, 2, this);
            }
            a.trace("paint: out");
        }

        public void setupImage() {
            Image image = this.createImage((int)Math.ceil(this.size.getWidth() * CompareDiagramPanel.this.scale), (int)Math.ceil(this.size.getHeight() * CompareDiagramPanel.this.scale));
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            graphics2D.setClip(0, 0, (int)Math.ceil(this.size.getWidth() * CompareDiagramPanel.this.scale), (int)Math.ceil(this.size.getHeight() * CompareDiagramPanel.this.scale));
            graphics2D.scale(CompareDiagramPanel.this.scale, CompareDiagramPanel.this.scale);
            this.b(graphics2D);
            this.a(graphics2D);
            graphics2D.dispose();
            this.imageReference = new SoftReference<Image>(image);
        }

        private void a(Graphics2D graphics2D) {
            Printable printable = this.de.getPrintable();
            ((JomtCanvas)printable).print((Graphics)graphics2D, (int)Math.ceil(this.size.getWidth()), (double)((int)Math.ceil(this.size.getHeight())));
        }

        private void b(Graphics2D graphics2D) {
            a.trace("paintBackground: in");
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, (int)Math.ceil(this.size.getWidth()), (int)Math.ceil(this.size.getHeight()));
            graphics2D.setPaint(this.dgm.eIsSet(DIPackage.Literals.DIAGRAM__NAME) ? Color.WHITE : Color.LIGHT_GRAY);
            graphics2D.fill(double_);
            graphics2D.setPaint(Color.BLACK);
            a.trace("paintBackground: out");
        }

        public void clearCacheImage() {
            if (this.imageReference != null) {
                this.imageReference.clear();
            }
            this.imageReference = null;
        }
    }
}

