/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import net.astah.golf.widget.swing.AdjustedRowHeightTable;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.ClassifierPresentationUtil;
import net.astah.jomt.jview.SortableTable;
import net.astah.jomt.jview.a;
import net.astah.swing.SortableTableModel;
import net.astah.uml2.uml.Classifiers;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;

public class AttributeVisibilityTable
extends SortableTable {
    private static final long serialVersionUID = 2586362048371196165L;
    protected static final String TYPE_HEADER = AttributeVisibilityTable.getTitle("projectview.table.header.type.label");
    protected static final String VISIBILITY_HEADER = AttributeVisibilityTable.getTitle("projectview.table.header.visibility.label");
    protected ClassifierPresentation presentation = null;
    protected Classifier model = null;

    public AttributeVisibilityTable(ClassifierPresentation classifierPresentation) {
        this.presentation = classifierPresentation;
        this.model = this.getClassifierModel(classifierPresentation);
        this.updateNameHeaderStr();
        this.setLayout(new BorderLayout());
        this.initAttributeTable();
        this.scroller = new JScrollPane(this.table);
        this.add(this.scroller);
    }

    protected Classifier getClassifierModel(ClassifierPresentation classifierPresentation) {
        return (Classifier)new a(this).doSwitch(classifierPresentation.getModel());
    }

    protected void initAttributeTable() {
        this.columnNames = new String[4];
        this.columnNames[0] = "C";
        this.columnNames[1] = this.NAME_HEADER;
        this.columnNames[2] = TYPE_HEADER;
        this.columnNames[3] = VISIBILITY_HEADER;
        Object[][] objectArray = this.getAllAttributeValue(this.columnNames.length);
        this.tableModel = new SortableTableModel(objectArray, this.columnNames);
        this.table = new AdjustedRowHeightTable(this.tableModel);
        this.table.setShowGrid(true);
        this.table.getColumnModel().setColumnMargin(0);
        this.table.getColumn("C").setMaxWidth(30);
        this.table.getColumn(this.NAME_HEADER).setPreferredWidth(350);
        this.table.getColumn(this.NAME_HEADER).setCellRenderer(new AttributeNameCellRenderer(null));
        this.table.getColumn(TYPE_HEADER).setPreferredWidth(70);
        this.table.getColumn(VISIBILITY_HEADER).setMaxWidth(60);
        this.table.setRowSelectionAllowed(true);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(this);
    }

    protected Object[][] getAllAttributeValue(int n2) {
        List<Property> list = Classifiers.getAttributesWithoutAssociations(this.model);
        if (list == null || list.size() == 0) {
            return null;
        }
        Object[][] objectArray = new Object[list.size()][n2];
        int n3 = 0;
        for (Property property : list) {
            objectArray[n3][0] = !this.presentation.isFeatureVisible(property) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            String[] stringArray = ClassifierPresentationUtil.getPropertyInfo(property);
            objectArray[n3][1] = property;
            objectArray[n3][2] = stringArray[2];
            objectArray[n3][3] = property.getVisibility();
            ++n3;
        }
        return objectArray;
    }

    protected void updateNameHeaderStr() {
    }

    private class AttributeNameCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 5356805651401480861L;

        private AttributeNameCellRenderer() {
        }

        @Override
        protected void setValue(Object object) {
            if (object instanceof Property) {
                this.setText(((Property)Property.class.cast(object)).getName());
                return;
            }
            super.setValue(object);
        }

        /* synthetic */ AttributeNameCellRenderer(a a2) {
            this();
        }
    }
}

